/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.Job;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BoundsHelper;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.core.post.CompoundAction;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.post.input.NBTPatch;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.json.JsonPointer;

public class RandomSelect
extends PostAction
implements CompoundAction {
    public final PostAction[] entries;
    public final int[] weights;
    public final MinMaxBounds.Ints rolls;
    public final boolean canRepeat;
    public final boolean hidden;
    public final boolean preventSync;
    public final int totalWeight;
    public final int emptyWeight;

    public RandomSelect(PostAction[] entries, int[] weights, int totalWeight, int emptyWeight, MinMaxBounds.Ints rolls) {
        Preconditions.checkArgument((entries.length == weights.length ? 1 : 0) != 0);
        this.entries = entries;
        this.weights = weights;
        this.totalWeight = totalWeight;
        this.emptyWeight = emptyWeight;
        this.rolls = rolls;
        this.canRepeat = Arrays.stream(entries).allMatch(PostAction::canRepeat);
        this.hidden = Arrays.stream(entries).allMatch(PostAction::isHidden);
        this.preventSync = Arrays.stream(entries).allMatch(PostAction::preventSync);
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.RANDOM;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        int i;
        if ((times *= IntBoundsHelper.random(this.rolls, ctx.getRandom())) == 0) {
            return;
        }
        ArrayList validActions = Lists.newArrayList();
        int[] validWeights = new int[this.entries.length];
        int totalWeights = 0;
        for (int i2 = 0; i2 < this.entries.length; ++i2) {
            PostAction entry = this.entries[i2];
            if (entry.checkConditions(recipe, ctx, 1) != 1) continue;
            validWeights[validActions.size()] = this.weights[i2];
            validActions.add(entry);
            totalWeights += this.weights[i2];
        }
        if (validActions.isEmpty()) {
            return;
        }
        totalWeights += this.emptyWeight;
        int[] childTimes = new int[validActions.size()];
        for (i = 0; i < times; ++i) {
            int index = this.getRandomEntry(ctx.getRandom(), validWeights, totalWeights);
            if (index < 0) continue;
            int n = index;
            childTimes[n] = childTimes[n] + 1;
        }
        for (i = 0; i < validActions.size(); ++i) {
            if (childTimes[i] <= 0) continue;
            ctx.runtime.jobs.push(new Job((PostAction)validActions.get(i), childTimes[i]));
        }
    }

    private int getRandomEntry(RandomSource random, int[] weights, int totalWeights) {
        int j = random.m_188503_(totalWeights);
        for (int i = 0; i < weights.length; ++i) {
            if ((j -= weights[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
    }

    @Override
    public List<ItemStack> getItemOutputs() {
        return Stream.of(this.entries).map(PostAction::getItemOutputs).flatMap(Collection::stream).toList();
    }

    @Override
    public List<BlockPredicate> getBlockOutputs() {
        return Stream.of(this.entries).map(PostAction::getBlockOutputs).flatMap(Collection::stream).toList();
    }

    @Override
    public Component getDisplayName() {
        if (this.entries.length == 1 && this.emptyWeight == 0) {
            return Component.m_237113_((String)"%s \u00d7 %s".formatted(this.entries[0].getDisplayName().getString(), BoundsHelper.getDescription(this.rolls).getString()));
        }
        return CommonProxy.getCycledItem(List.of(this.entries), this.entries[0], 1000).getDisplayName();
    }

    @Override
    public boolean canRepeat() {
        return this.canRepeat;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean preventSync() {
        return this.preventSync;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        for (PostAction action : this.entries) {
            Preconditions.checkArgument((action.getClass() != NBTPatch.class ? 1 : 0) != 0, (Object)"NBTPatch cannot be used in RandomSelect");
            action.validate(recipe, patchContext);
        }
    }

    @Override
    public void getUsedPointers(ILycheeRecipe<?> recipe, Consumer<JsonPointer> consumer) {
        for (PostAction action : this.entries) {
            action.getUsedPointers(recipe, consumer);
        }
    }

    @Override
    public JsonElement provideJsonInfo(ILycheeRecipe<?> recipe, JsonPointer pointer, JsonObject recipeObject) {
        int i = 0;
        JsonArray array = new JsonArray();
        for (PostAction action : this.entries) {
            array.add(action.provideJsonInfo(recipe, pointer.append("entries/" + i), recipeObject));
            ++i;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("entries", (JsonElement)array);
        return jsonObject;
    }

    @Override
    public Stream<PostAction> getChildActions() {
        return Arrays.stream(this.entries);
    }

    public static class Type
    extends PostActionType<RandomSelect> {
        @Override
        public RandomSelect fromJson(JsonObject o) {
            MinMaxBounds.Ints rolls;
            JsonArray array = o.getAsJsonArray("entries");
            int size = array.size();
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"entries can not be empty");
            PostAction[] entries = new PostAction[size];
            int[] weights = new int[size];
            for (int i = 0; i < size; ++i) {
                JsonObject e = array.get(i).getAsJsonObject();
                weights[i] = GsonHelper.m_13824_((JsonObject)e, (String)"weight", (int)1);
                Preconditions.checkArgument((weights[i] > 0 ? 1 : 0) != 0, (Object)"weight should be greater than 0");
                entries[i] = PostAction.parse(e);
            }
            if (o.has("rolls")) {
                rolls = MinMaxBounds.Ints.m_55373_((JsonElement)o.get("rolls"));
                Objects.requireNonNull((Integer)rolls.m_55305_(), "min");
                Objects.requireNonNull((Integer)rolls.m_55326_(), "max");
            } else {
                rolls = IntBoundsHelper.ONE;
            }
            int emptyWeight = GsonHelper.m_13824_((JsonObject)o, (String)"empty_weight", (int)0);
            Preconditions.checkArgument((emptyWeight >= 0 ? 1 : 0) != 0, (Object)"empty_weight should be greater or equal to 0");
            return new RandomSelect(entries, weights, IntStream.of(weights).sum() + emptyWeight, emptyWeight, rolls);
        }

        @Override
        public void toJson(RandomSelect action, JsonObject o) {
            JsonArray entries = new JsonArray(action.entries.length);
            int i = 0;
            for (PostAction entry : action.entries) {
                JsonObject entryJson = entry.toJson();
                if (action.weights[i] != 1) {
                    entryJson.addProperty("weight", (Number)action.weights[i]);
                }
                entries.add((JsonElement)entryJson);
                ++i;
            }
            o.add("entries", (JsonElement)entries);
            if (action.rolls != IntBoundsHelper.ONE) {
                o.add("rolls", action.rolls.m_55328_());
            }
            if (action.emptyWeight != 0) {
                o.addProperty("empty_weight", (Number)action.emptyWeight);
            }
        }

        @Override
        public RandomSelect fromNetwork(FriendlyByteBuf buf) {
            int totalWeight = buf.m_130242_();
            int emptyWeight = buf.m_130242_();
            int size = buf.m_130242_();
            PostAction[] entries = new PostAction[size];
            int[] weights = new int[size];
            for (int i = 0; i < size; ++i) {
                weights[i] = buf.m_130242_();
                entries[i] = PostAction.read(buf);
            }
            return new RandomSelect(entries, weights, totalWeight, emptyWeight, IntBoundsHelper.fromNetwork(buf));
        }

        @Override
        public void toNetwork(RandomSelect action, FriendlyByteBuf buf) {
            buf.m_130130_(action.totalWeight);
            buf.m_130130_(action.emptyWeight);
            buf.m_130130_((int)Stream.of(action.entries).filter(Predicate.not(PostAction::preventSync)).count());
            for (int i = 0; i < action.entries.length; ++i) {
                PostAction entry = action.entries[i];
                if (entry.preventSync()) continue;
                buf.m_130130_(action.weights[i]);
                PostActionType<?> type = entry.getType();
                CommonProxy.writeRegistryId(LycheeRegistries.POST_ACTION, type, buf);
                type.toNetwork(entry, buf);
                entry.conditionsToNetwork(buf);
            }
            IntBoundsHelper.toNetwork(action.rolls, buf);
        }
    }
}

