/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.post.PlaceBlock;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.util.CommonProxy;

public class CycleStateProperty
extends PlaceBlock {
    public final Property<?> property;

    public CycleStateProperty(BlockPredicate block, BlockPos offset, Property<?> property) {
        super(block, offset);
        this.property = property;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.CYCLE_STATE_PROPERTY;
    }

    @Override
    @Nullable
    protected BlockState getNewState(BlockState oldState) {
        try {
            return (BlockState)oldState.m_61122_(this.property);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Property<?> findProperty(BlockPredicate blockPredicate, String name) {
        BlockState block = BlockPredicateHelper.anyBlockState(blockPredicate);
        for (Property property : block.m_61147_()) {
            if (!name.equals(property.m_61708_())) continue;
            return property;
        }
        throw new IllegalArgumentException("Unknown property name: " + name);
    }

    public static class Type
    extends PostActionType<CycleStateProperty> {
        @Override
        public CycleStateProperty fromJson(JsonObject o) {
            BlockPos offset = CommonProxy.parseOffset(o);
            BlockPredicate block = BlockPredicateHelper.fromJson(o.get("block"));
            return new CycleStateProperty(block, offset, CycleStateProperty.findProperty(block, GsonHelper.m_13906_((JsonObject)o, (String)"property")));
        }

        @Override
        public void toJson(CycleStateProperty action, JsonObject o) {
            PostActionTypes.PLACE.toJson(action, o);
            o.addProperty("property", action.property.m_61708_());
        }

        @Override
        public CycleStateProperty fromNetwork(FriendlyByteBuf buf) {
            BlockPredicate block = BlockPredicateHelper.fromNetwork(buf);
            return new CycleStateProperty(block, buf.m_130135_(), CycleStateProperty.findProperty(block, buf.m_130277_()));
        }

        @Override
        public void toNetwork(CycleStateProperty action, FriendlyByteBuf buf) {
            PostActionTypes.PLACE.toNetwork(action, buf);
            buf.m_130070_(action.property.m_61708_());
        }
    }
}

