/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.input;

import com.google.common.collect.Lists;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.input.ItemHolder;
import snownee.lychee.util.CommonProxy;

public abstract class ItemHolderCollection {
    public static final ItemHolderCollection EMPTY = InWorld.of(new ItemEntity[0]);
    protected final ItemHolder[] holders;
    public final List<ItemStack> tempList = Lists.newArrayList();
    public final BitSet ignoreConsumptionFlags;

    public ItemHolderCollection(ItemHolder ... holders) {
        this.holders = holders;
        this.ignoreConsumptionFlags = new BitSet(holders.length);
    }

    public ItemHolder get(int index) {
        return this.holders[index];
    }

    public ItemHolder split(int index, int amount) {
        ItemHolder holder;
        this.holders[index] = holder = this.get(index).split(amount, this.tempList::add);
        return holder;
    }

    public ItemHolder replace(int index, ItemStack item) {
        ItemHolder holder;
        this.holders[index] = holder = this.get(index).replace(item, this.tempList::add);
        return holder;
    }

    protected int consumeInputs(int times) {
        int total = 0;
        for (int i = 0; i < this.holders.length; ++i) {
            ItemHolder holder = this.holders[i];
            if (this.ignoreConsumptionFlags.get(i) || holder.get().m_41619_()) continue;
            this.holders[i].get().m_41774_(times);
            total += times;
        }
        return total;
    }

    public abstract int postApply(boolean var1, int var2);

    public int size() {
        return this.holders.length;
    }

    public static class InWorld
    extends ItemHolderCollection {
        private ItemEntity itemEntity;

        public InWorld(ItemHolder.InWorld ... holders) {
            super(holders);
            if (holders.length > 0) {
                this.itemEntity = holders[0].getEntity();
            }
        }

        public static ItemHolderCollection of(ItemEntity ... entities) {
            return new InWorld((ItemHolder.InWorld[])Stream.of(entities).map(ItemHolder.InWorld::new).toArray(ItemHolder.InWorld[]::new));
        }

        @Override
        public int postApply(boolean consumeInputs, int times) {
            for (ItemStack stack : this.tempList) {
                if (stack.m_41619_()) continue;
                Vec3 pos = this.itemEntity.m_20182_();
                ItemEntity newEntity = new ItemEntity(this.itemEntity.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, stack);
                this.itemEntity.m_9236_().m_7967_((Entity)newEntity);
            }
            return consumeInputs ? this.consumeInputs(times) : 0;
        }
    }

    public static class Inventory
    extends ItemHolderCollection {
        private LycheeContext ctx;

        public Inventory(LycheeContext ctx, ItemHolder.Simple ... holders) {
            super(holders);
            this.ctx = ctx;
        }

        public static ItemHolderCollection of(LycheeContext ctx, ItemStack ... items) {
            return new Inventory(ctx, (ItemHolder.Simple[])Stream.of(items).map(ItemHolder.Simple::new).toArray(ItemHolder.Simple[]::new));
        }

        @Override
        public int postApply(boolean consumeInputs, int times) {
            Entity entity = (Entity)this.ctx.getParamOrNull(LootContextParams.f_81455_);
            Player player = null;
            if (entity instanceof Player) {
                player = (Player)entity;
            }
            Vec3 pos = (Vec3)this.ctx.getParamOrNull(LootContextParams.f_81460_);
            for (ItemStack stack : this.tempList) {
                if (player != null) {
                    if (player.m_36356_(stack)) continue;
                    player.m_36176_(stack, false);
                    continue;
                }
                if (pos == null) continue;
                CommonProxy.dropItemStack(this.ctx.getLevel(), pos.f_82479_, pos.f_82480_, pos.f_82481_, stack, null);
            }
            return consumeInputs ? this.consumeInputs(times) : 0;
        }
    }
}

