/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;

public class CustomCondition
implements ContextualCondition {
    public final JsonObject data;
    public Test testFunc;
    public BiFunction<Level, @Nullable Player, InteractionResult> testInTooltipsFunc = (level, player) -> InteractionResult.PASS;

    public CustomCondition(JsonObject data) {
        this.data = data;
        CommonProxy.postCustomConditionEvent(GsonHelper.m_13906_((JsonObject)data, (String)"id"), this);
    }

    public ContextualConditionType<?> getType() {
        return ContextualConditionTypes.CUSTOM;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        if (this.testFunc != null) {
            return this.testFunc.test(recipe, ctx, times);
        }
        return 0;
    }

    @Override
    public InteractionResult testInTooltips(Level level, @Nullable Player player) {
        return this.testInTooltipsFunc.apply(level, player);
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        return Component.m_237110_((String)this.makeDescriptionId(inverted), (Object[])new Object[]{GsonHelper.m_13906_((JsonObject)this.data, (String)"id")});
    }

    @FunctionalInterface
    public static interface Test {
        public int test(ILycheeRecipe<?> var1, LycheeContext var2, int var3);
    }

    public static class Type
    extends ContextualConditionType<CustomCondition> {
        @Override
        public CustomCondition fromJson(JsonObject o) {
            return new CustomCondition(o);
        }

        @Override
        public void toJson(CustomCondition condition, JsonObject o) {
            condition.data.entrySet().forEach(e -> o.add((String)e.getKey(), (JsonElement)e.getValue()));
        }

        @Override
        public CustomCondition fromNetwork(FriendlyByteBuf buf) {
            return new CustomCondition(JsonParser.parseString((String)buf.m_130277_()).getAsJsonObject());
        }

        @Override
        public void toNetwork(CustomCondition condition, FriendlyByteBuf buf) {
            buf.m_130070_(condition.data.toString());
        }
    }
}

