/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ChanceRecipe;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;

public class ContextualHolder {
    private static final Component SECRET_TITLE = Component.m_237115_((String)"contextual.lychee.secret").m_130940_(ChatFormatting.GRAY);
    private List<ContextualCondition> conditions = List.of();
    @Nullable
    private BitSet secretFlags;
    @Nullable
    private List<Component> overrideDesc;

    public List<ContextualCondition> getConditions() {
        return this.conditions;
    }

    public int showingConditionsCount() {
        return this.conditions.stream().mapToInt(ContextualCondition::showingCount).sum();
    }

    public void withCondition(ContextualCondition condition) {
        Objects.requireNonNull(condition);
        if (this.conditions.isEmpty()) {
            this.conditions = Lists.newArrayList();
        }
        this.conditions.add(condition);
    }

    public void parseConditions(JsonElement element) {
        if (element != null) {
            if (element.isJsonObject()) {
                this.parse(element.getAsJsonObject());
            } else {
                JsonArray array = element.getAsJsonArray();
                for (int x = 0; x < array.size(); ++x) {
                    this.parse(array.get(x).getAsJsonObject());
                }
            }
        }
    }

    private void parse(JsonObject o) {
        this.withCondition(ContextualCondition.parse(o));
        if (GsonHelper.m_13855_((JsonObject)o, (String)"secret", (boolean)false)) {
            if (this.secretFlags == null) {
                this.secretFlags = new BitSet(this.conditions.size());
            }
            this.secretFlags.set(this.conditions.size() - 1);
        }
        if (o.has("description")) {
            if (this.overrideDesc == null) {
                this.overrideDesc = Lists.newArrayList();
            }
            while (this.overrideDesc.size() + 1 < this.conditions.size()) {
                this.overrideDesc.add(null);
            }
            this.overrideDesc.add((Component)Component.m_237115_((String)GsonHelper.m_13906_((JsonObject)o, (String)"description")));
        }
    }

    public void conditionsFromNetwork(FriendlyByteBuf pBuffer) {
        int i;
        int size = pBuffer.m_130242_();
        for (i = 0; i < size; ++i) {
            ContextualConditionType<?> type = CommonProxy.readRegistryId(LycheeRegistries.CONTEXTUAL, pBuffer);
            this.withCondition((ContextualCondition)type.fromNetwork(pBuffer));
        }
        if (pBuffer.readBoolean()) {
            this.secretFlags = pBuffer.m_178384_();
        }
        if (pBuffer.readBoolean()) {
            this.overrideDesc = Lists.newArrayListWithCapacity((int)size);
            for (i = 0; i < size; ++i) {
                String key = pBuffer.m_130277_();
                if (key.isEmpty()) {
                    this.overrideDesc.add(null);
                    continue;
                }
                this.overrideDesc.add((Component)Component.m_237115_((String)key));
            }
        }
    }

    public void conditionsToNetwork(FriendlyByteBuf pBuffer) {
        pBuffer.m_130130_(this.conditions.size());
        for (ContextualCondition condition : this.conditions) {
            ContextualConditionType<? extends ContextualCondition> type = condition.getType();
            CommonProxy.writeRegistryId(LycheeRegistries.CONTEXTUAL, type, pBuffer);
            type.toNetwork(condition, pBuffer);
        }
        pBuffer.writeBoolean(this.secretFlags != null);
        if (this.secretFlags != null) {
            pBuffer.m_178350_(this.secretFlags);
        }
        pBuffer.writeBoolean(this.overrideDesc != null);
        if (this.overrideDesc != null) {
            for (Component component : this.overrideDesc) {
                ComponentContents componentContents;
                if (component == null || !((componentContents = component.m_214077_()) instanceof TranslatableContents)) {
                    pBuffer.m_130070_("");
                    continue;
                }
                TranslatableContents translatable = (TranslatableContents)componentContents;
                pBuffer.m_130070_(translatable.m_237508_());
            }
        }
    }

    public JsonElement rawConditionsToJson() {
        if (this.conditions.size() == 1) {
            return this.conditions.get(0).toJson();
        }
        JsonArray array = new JsonArray();
        this.conditions.forEach($ -> array.add((JsonElement)$.toJson()));
        return array;
    }

    public int checkConditions(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        try {
            boolean first = true;
            for (ContextualCondition condition : this.conditions) {
                if (first && condition.getType() == ContextualConditionTypes.CHANCE && this instanceof ChanceRecipe) continue;
                first = false;
                if ((times = condition.test(recipe, ctx, times)) != 0) continue;
                break;
            }
            return times;
        }
        catch (Throwable e) {
            Lychee.LOGGER.error("Failed to check conditions for recipe {}", (Object)recipe.lychee$getId(), (Object)e);
            return 0;
        }
    }

    public boolean isSecretCondition(int index) {
        if (this.secretFlags == null) {
            return false;
        }
        return this.secretFlags.get(index);
    }

    public void getConditionTooltips(List<Component> list, int indent, @Nullable Level level, @Nullable Player player) {
        if (level == null) {
            return;
        }
        int i = 0;
        for (ContextualCondition condition : this.getConditions()) {
            if (this.isSecretCondition(i)) {
                result = condition.testInTooltips(level, player);
                ContextualCondition.desc(list, result, indent, SECRET_TITLE.m_6881_());
            } else if (this.isOverridenDesc(i)) {
                result = condition.testInTooltips(level, player);
                ContextualCondition.desc(list, result, indent, this.overrideDesc.get(i).m_6881_());
            } else {
                condition.appendTooltips(list, level, player, indent, false);
            }
            ++i;
        }
    }

    private boolean isOverridenDesc(int i) {
        if (this.overrideDesc != null && this.overrideDesc.size() > i) {
            return this.overrideDesc.get(i) != null;
        }
        return false;
    }
}

