/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.jei.category;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.compat.JEIREI;
import snownee.lychee.compat.jei.category.BaseJEICategory;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.dripstone_dripping.DripstoneContext;
import snownee.lychee.dripstone_dripping.DripstoneRecipe;
import snownee.lychee.util.CommonProxy;

public class DripstoneRecipeCategory
extends BaseJEICategory<DripstoneContext, DripstoneRecipe> {
    private Rect2i sourceBlockRect = new Rect2i(23, 1, 16, 16);
    private Rect2i targetBlockRect = new Rect2i(23, 43, 16, 16);

    public DripstoneRecipeCategory(LycheeRecipeType<DripstoneContext, DripstoneRecipe> recipeType) {
        super(recipeType);
    }

    @Override
    public IDrawable createIcon(IGuiHelper guiHelper, List<DripstoneRecipe> recipes) {
        return guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)Items.f_151087_.m_7968_());
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, DripstoneRecipe recipe, IFocusGroup focuses) {
        int y = recipe.showingActionsCount() > 9 ? 26 : 28;
        this.actionGroup(builder, recipe, this.getWidth() - 28, y);
        DripstoneRecipeCategory.addBlockIngredients(builder, recipe);
    }

    @Override
    public void draw(DripstoneRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.drawInfoBadge(recipe, graphics, mouseX, mouseY);
        BlockState sourceBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getSourceBlock()), Blocks.f_50016_.m_49966_(), 2000);
        BlockState targetBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getBlock()), Blocks.f_50016_.m_49966_(), 2000);
        PoseStack matrixStack = graphics.m_280168_();
        if (targetBlock.m_60791_() < 5) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(31.0f, 56.0f, 0.0f);
            float shadow = 0.5f;
            matrixStack.m_85841_(shadow, shadow, shadow);
            matrixStack.m_85837_(-26.0, -5.5, 0.0);
            AllGuiTextures.JEI_SHADOW.render(graphics, 0, 0);
            matrixStack.m_85849_();
        }
        matrixStack.m_85836_();
        matrixStack.m_252880_(22.0f, 24.0f, 300.0f);
        DripstoneRecipeCategory.drawBlock(sourceBlock, graphics, 0.0, -2.0, 0.0);
        DripstoneRecipeCategory.drawBlock(Blocks.f_152537_.m_49966_(), graphics, 0.0, -1.0, 0.0);
        DripstoneRecipeCategory.drawBlock((BlockState)Blocks.f_152588_.m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)Direction.DOWN), graphics, 0.0, 0.0, 0.0);
        DripstoneRecipeCategory.drawBlock(targetBlock, graphics, 0.0, 1.5, 0.0);
        matrixStack.m_85849_();
    }

    private static void drawBlock(BlockState state, GuiGraphics graphics, double localX, double localY, double localZ) {
        GuiGameElement.of(state).scale(12.0).lighting(JEIREI.BLOCK_LIGHTING).atLocal(localX, localY, localZ).rotateBlock(12.5, 202.5, 0.0).render(graphics);
    }

    @Override
    public List<Component> getTooltipStrings(DripstoneRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int x = (int)mouseX;
        int y = (int)mouseY;
        if (this.sourceBlockRect.m_110087_(x, y)) {
            BlockState sourceBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getSourceBlock()), Blocks.f_50016_.m_49966_(), 2000);
            return BlockPredicateHelper.getTooltips(sourceBlock, recipe.getSourceBlock());
        }
        if (this.targetBlockRect.m_110087_(x, y)) {
            BlockState targetBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getBlock()), Blocks.f_50016_.m_49966_(), 2000);
            return BlockPredicateHelper.getTooltips(targetBlock, recipe.getBlock());
        }
        return super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
    }

    @Override
    public boolean handleInput(DripstoneRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE) {
            int x = (int)mouseX;
            int y = (int)mouseY;
            if (this.sourceBlockRect.m_110087_(x, y)) {
                BlockState fallingBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getSourceBlock()), Blocks.f_50016_.m_49966_(), 2000);
                return this.clickBlock(fallingBlock, input);
            }
            if (this.targetBlockRect.m_110087_(x, y)) {
                BlockState landingBlock = CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getBlock()), Blocks.f_50016_.m_49966_(), 2000);
                return this.clickBlock(landingBlock, input);
            }
        }
        return super.handleInput(recipe, mouseX, mouseY, input);
    }
}

