/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraftforge.registries.ForgeRegistries;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.anvil_crafting.AnvilContext;
import snownee.lychee.anvil_crafting.AnvilCraftingRecipe;
import snownee.lychee.block_crushing.BlockCrushingRecipe;
import snownee.lychee.block_crushing.BlockCrushingRecipeType;
import snownee.lychee.block_exploding.BlockExplodingContext;
import snownee.lychee.block_exploding.BlockExplodingRecipe;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.recipe.type.BlockKeyRecipeType;
import snownee.lychee.core.recipe.type.ItemShapelessRecipeType;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.dripstone_dripping.DripstoneRecipe;
import snownee.lychee.dripstone_dripping.DripstoneRecipeType;
import snownee.lychee.interaction.BlockClickingRecipe;
import snownee.lychee.interaction.BlockInteractingRecipe;
import snownee.lychee.item_burning.ItemBurningRecipe;
import snownee.lychee.item_exploding.ItemExplodingRecipe;
import snownee.lychee.item_inside.ItemInsideRecipe;
import snownee.lychee.item_inside.ItemInsideRecipeType;
import snownee.lychee.lightning_channeling.LightningChannelingRecipe;
import snownee.lychee.random_block_ticking.RandomBlockTickingRecipe;
import snownee.lychee.random_block_ticking.RandomBlockTickingRecipeType;

public final class RecipeTypes {
    public static final Set<LycheeRecipeType<?, ?>> ALL;
    public static final LycheeRecipeType<LycheeContext, ItemBurningRecipe> ITEM_BURNING;
    public static final ItemInsideRecipeType ITEM_INSIDE;
    public static final BlockKeyRecipeType<LycheeContext, BlockInteractingRecipe> BLOCK_INTERACTING;
    public static final BlockKeyRecipeType<LycheeContext, BlockClickingRecipe> BLOCK_CLICKING;
    public static final LycheeRecipeType<AnvilContext, AnvilCraftingRecipe> ANVIL_CRAFTING;
    public static final BlockCrushingRecipeType BLOCK_CRUSHING;
    public static final ItemShapelessRecipeType<ItemShapelessContext, LightningChannelingRecipe> LIGHTNING_CHANNELING;
    public static final ItemShapelessRecipeType<ItemShapelessContext, ItemExplodingRecipe> ITEM_EXPLODING;
    public static final BlockKeyRecipeType<BlockExplodingContext, BlockExplodingRecipe> BLOCK_EXPLODING;
    public static final RandomBlockTickingRecipeType RANDOM_BLOCK_TICKING;
    public static final DripstoneRecipeType DRIPSTONE_DRIPPING;

    public static void init() {
        RecipeTypes.BLOCK_INTERACTING.requiresClient = true;
        RecipeTypes.BLOCK_CLICKING.requiresClient = true;
        RecipeTypes.DRIPSTONE_DRIPPING.requiresClient = true;
        RecipeTypes.RANDOM_BLOCK_TICKING.extractChance = true;
        RecipeTypes.RANDOM_BLOCK_TICKING.hasStandaloneCategory = false;
        RecipeTypes.DRIPSTONE_DRIPPING.extractChance = true;
        RecipeTypes.BLOCK_INTERACTING.canPreventConsumeInputs = true;
        RecipeTypes.BLOCK_CLICKING.canPreventConsumeInputs = true;
        RecipeTypes.BLOCK_CLICKING.categoryId = RecipeTypes.BLOCK_INTERACTING.categoryId;
        RecipeTypes.ITEM_INSIDE.canPreventConsumeInputs = true;
        RecipeTypes.LIGHTNING_CHANNELING.canPreventConsumeInputs = true;
        RecipeTypes.ITEM_EXPLODING.canPreventConsumeInputs = true;
        RecipeTypes.ANVIL_CRAFTING.hasStandaloneCategory = false;
    }

    public static <T extends LycheeRecipeType<?, ?>> T register(T recipeType) {
        ForgeRegistries.RECIPE_TYPES.register(recipeType.id, recipeType);
        return recipeType;
    }

    public static void buildCache() {
        ALL.forEach(LycheeRecipeType::buildCache);
        ALL.forEach(LycheeRecipeType::updateEmptyState);
    }

    static {
        LycheeLootContextParams.init();
        LycheeLootContextParamSets.init();
        ALL = Sets.newLinkedHashSet();
        ITEM_BURNING = RecipeTypes.register(new LycheeRecipeType("item_burning", ItemBurningRecipe.class, null));
        ITEM_INSIDE = RecipeTypes.register(new ItemInsideRecipeType("item_inside", ItemInsideRecipe.class, null));
        BLOCK_INTERACTING = RecipeTypes.register(new BlockKeyRecipeType("block_interacting", BlockInteractingRecipe.class, LycheeLootContextParamSets.BLOCK_INTERACTION));
        BLOCK_CLICKING = RecipeTypes.register(new BlockKeyRecipeType("block_clicking", BlockClickingRecipe.class, LycheeLootContextParamSets.BLOCK_INTERACTION));
        ANVIL_CRAFTING = RecipeTypes.register(new LycheeRecipeType("anvil_crafting", AnvilCraftingRecipe.class, null));
        BLOCK_CRUSHING = RecipeTypes.register(new BlockCrushingRecipeType("block_crushing", BlockCrushingRecipe.class, null));
        LIGHTNING_CHANNELING = RecipeTypes.register(new ItemShapelessRecipeType("lightning_channeling", LightningChannelingRecipe.class, null));
        ITEM_EXPLODING = RecipeTypes.register(new ItemShapelessRecipeType("item_exploding", ItemExplodingRecipe.class, null));
        BLOCK_EXPLODING = RecipeTypes.register(new BlockKeyRecipeType("block_exploding", BlockExplodingRecipe.class, LycheeLootContextParamSets.BLOCK_ONLY));
        RANDOM_BLOCK_TICKING = RecipeTypes.register(new RandomBlockTickingRecipeType("random_block_ticking", RandomBlockTickingRecipe.class, LycheeLootContextParamSets.BLOCK_ONLY));
        DRIPSTONE_DRIPPING = RecipeTypes.register(new DripstoneRecipeType("dripstone_dripping", DripstoneRecipe.class, LycheeLootContextParamSets.BLOCK_ONLY));
    }
}

