/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetracelium.compat.twilightforest.effects;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.ApplyHitTargetEffectsEvent;
import se.mickelus.tetra.effect.ApplyUsageEffectsEvent;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.StatsHelper;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatFormat;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatFormat;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectEfficiency;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterMultiValue;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;
import se.mickelus.tetracelium.TetraceliumMod;
import se.mickelus.tetracelium.compat.twilightforest.effects.SapParticlePacket;
import twilightforest.data.tags.EntityTagGenerator;
import twilightforest.item.LifedrainScepterItem;

public class SappingEffect {
    public static final ItemEffect sappingEffect = ItemEffect.get((String)"sapping");

    @SubscribeEvent
    public static void onApplyHitTargetEffects(ApplyHitTargetEffectsEvent event) {
        ItemStack itemStack = event.getUsedItemStack();
        int effectLevel = EffectHelper.getEffectLevel((ItemStack)itemStack, (ItemEffect)sappingEffect);
        LivingEntity attacker = event.getAttacker();
        if (effectLevel > 0) {
            attacker.m_5634_((float)effectLevel);
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                player.m_36324_().m_38707_(effectLevel, 0.1f);
            }
            Level level = event.getTarget().m_9236_();
            InteractionHand hand = SappingEffect.getHand(itemStack, attacker);
            Vec3 targetPosition = event.getTarget().m_146892_();
            if (level.f_46443_) {
                SappingEffect.makeRedMagicTrail(level, hand, attacker, targetPosition);
            } else {
                TetraceliumMod.packetHandler.sendToAllPlayersNear((AbstractPacket)new SapParticlePacket(hand, targetPosition), attacker.m_20183_(), 64.0, level.m_46472_());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ItemStack itemStack;
        Entity entity2;
        if ("trident".equals(event.getSource().m_19385_()) && (entity2 = event.getSource().m_7640_()) instanceof ThrownModularItemEntity) {
            ThrownModularItemEntity modularEntity = (ThrownModularItemEntity)entity2;
            itemStack = modularEntity.getThrownStack();
        } else {
            itemStack = Optional.ofNullable(event.getSource().m_7639_()).filter(entity -> entity instanceof Player).map(entity -> (LivingEntity)entity).map(LivingEntity::m_21205_).filter(stack -> stack.m_41720_() instanceof IModularItem).orElse(null);
        }
        if (itemStack != null) {
            Level level = event.getEntity().m_9236_();
            if (!level.f_46443_ && !event.getEntity().m_6095_().m_204039_(EntityTagGenerator.LIFEDRAIN_DROPS_NO_FLESH) && EffectHelper.getEffectLevel((ItemStack)itemStack, (ItemEffect)sappingEffect) > 0) {
                LifedrainScepterItem.animateTargetShatter((ServerLevel)((ServerLevel)level), (LivingEntity)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onApplyUsageEffects(ApplyUsageEffectsEvent event) {
        ItemStack itemStack = event.getItemStack();
        double effectEfficiency = EffectHelper.getEffectEfficiency((ItemStack)itemStack, (ItemEffect)sappingEffect);
        if (effectEfficiency > 0.0) {
            ServerPlayer player = CastOptional.cast((Object)event.getUsingEntity(), ServerPlayer.class).orElse(null);
            itemStack.m_220157_((int)Math.ceil((double)itemStack.m_41776_() * 0.01 * effectEfficiency), event.getUsingEntity().m_217043_(), player);
        }
    }

    private static String getIdentifier(ItemStack itemStack) {
        return CastOptional.cast((Object)itemStack.m_41720_(), IModularItem.class).map(item -> item.getIdentifier(itemStack)).orElse(null);
    }

    @Nullable
    private static InteractionHand getHand(ItemStack itemStack, LivingEntity entity) {
        String usedIdentifier = SappingEffect.getIdentifier(itemStack);
        if (usedIdentifier.equals(SappingEffect.getIdentifier(entity.m_21120_(InteractionHand.MAIN_HAND)))) {
            return InteractionHand.MAIN_HAND;
        }
        if (usedIdentifier.equals(SappingEffect.getIdentifier(entity.m_21120_(InteractionHand.OFF_HAND)))) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    public static void makeRedMagicTrail(Level level, InteractionHand hand, LivingEntity source, Vec3 target) {
        double handOffset = 0.0;
        if (hand == InteractionHand.MAIN_HAND) {
            handOffset = 0.35;
        }
        if (hand == InteractionHand.OFF_HAND) {
            handOffset = -0.35;
        }
        int particles = 32;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            float f = 1.0f;
            float f1 = 0.5f;
            float f2 = 0.5f;
            double tx = source.m_20185_() + (target.m_7096_() - source.m_20185_()) * trailFactor + level.m_213780_().m_188583_() * 0.005 + handOffset * (double)Direction.m_122364_((double)source.f_20883_).m_122416_();
            double ty = source.m_20188_() - 0.1 + (target.m_7098_() - source.m_20188_()) * trailFactor + level.m_213780_().m_188583_() * 0.005 - 0.1;
            double tz = source.m_20189_() + (target.m_7094_() - source.m_20189_()) * trailFactor + level.m_213780_().m_188583_() * 0.005 + handOffset * (double)Direction.m_122364_((double)source.f_20883_).m_122416_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, tx, ty, tz, (double)f, (double)f1, (double)f2);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        StatGetterEffectLevel statGetter = new StatGetterEffectLevel(sappingEffect, 1.0);
        StatGetterEffectLevel saturationGetter = new StatGetterEffectLevel(sappingEffect, (double)0.2f);
        StatGetterEffectEfficiency durabilityGetter = new StatGetterEffectEfficiency(sappingEffect, 1.0);
        GuiStatBar statBar = new GuiStatBar(0, 0, 59, "tetra.stats.sapping", 0.0, 4.0, false, false, false, (IStatGetter)statGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterMultiValue("tetra.stats.sapping.tooltip", StatsHelper.withStats((IStatGetter[])new IStatGetter[]{statGetter, saturationGetter, durabilityGetter}), StatsHelper.withFormat((IStatFormat[])new IStatFormat[]{StatFormat.noDecimal, StatFormat.oneDecimal, StatFormat.noDecimal})));
        WorkbenchStatsGui.addBar((GuiStatBase)statBar);
        HoloStatsGui.addBar((GuiStatBase)statBar);
    }
}

