/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetracelium.compat.twilightforest.effects;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.event.ModularLooseProjectilesEvent;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.bar.GuiStatIndicator;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterNone;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;
import se.mickelus.tetracelium.TetraceliumTextures;

public class EnderProjectilesEffect {
    public static final String yankKey = "tetracelium:ender_yank";
    public static final String jauntKey = "tetracelium:ender_jaunt";
    public static final ItemEffect enderProjectilesEffect = ItemEffect.get((String)"enderProjectiles");
    public static final ItemEffect enderProjectilesYankEffect = ItemEffect.get((String)"enderProjectilesYank");
    public static final ItemEffect enderProjectilesJauntEffect = ItemEffect.get((String)"enderProjectilesJaunt");

    public static AbstractArrow addYankData(AbstractArrow arrow) {
        arrow.getPersistentData().m_128379_(yankKey, true);
        return arrow;
    }

    public static AbstractArrow addJauntData(AbstractArrow arrow) {
        arrow.getPersistentData().m_128379_(jauntKey, true);
        return arrow;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onModularLooseProjectiles(ModularLooseProjectilesEvent event) {
        if (EffectHelper.getEffectLevel((ItemStack)event.getFiringStack(), (ItemEffect)enderProjectilesEffect) > 0) {
            if (EffectHelper.getEffectLevel((ItemStack)event.getFiringStack(), (ItemEffect)enderProjectilesYankEffect) > 0) {
                event.addProjectileRemapper(EnderProjectilesEffect::addYankData);
            }
            if (EffectHelper.getEffectLevel((ItemStack)event.getFiringStack(), (ItemEffect)enderProjectilesJauntEffect) > 0) {
                event.addProjectileRemapper(EnderProjectilesEffect::addJauntData);
            }
        }
    }

    @SubscribeEvent
    public static void onEnderBowHit(ProjectileImpactEvent evt) {
        Projectile arrow = evt.getProjectile();
        Entity entity = arrow.m_19749_();
        if (entity instanceof Player) {
            EntityHitResult result;
            Player player = (Player)entity;
            entity = evt.getRayTraceResult();
            if (entity instanceof EntityHitResult && (entity = (result = (EntityHitResult)entity).m_82443_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (arrow.m_19749_() != result.m_82443_()) {
                    double playerX = player.m_20185_();
                    double playerY = player.m_20186_();
                    double playerZ = player.m_20189_();
                    float playerYaw = player.m_146908_();
                    @Nullable Entity playerVehicle = player.m_20202_();
                    boolean hasJaunt = arrow.getPersistentData().m_128441_(jauntKey);
                    boolean hasYank = arrow.getPersistentData().m_128441_(yankKey);
                    if (hasJaunt) {
                        Entity vehicle = living.m_20159_() ? living.m_20202_() : null;
                        EnderProjectilesEffect.teleport((LivingEntity)player, vehicle, living.m_146908_(), living.m_20185_(), living.m_20186_(), living.m_20189_());
                        if (vehicle != null) {
                            living.m_8127_();
                        }
                    }
                    if (hasYank) {
                        EnderProjectilesEffect.teleport(living, playerVehicle, playerYaw, playerX, playerY, playerZ);
                        if (playerVehicle != null) {
                            player.m_8127_();
                        }
                    }
                    if (hasYank || hasJaunt) {
                        player.f_19802_ = 40;
                    }
                }
            }
        }
    }

    private static void teleport(LivingEntity teleportingEntity, @Nullable Entity targetVehicle, float yRot, double x, double y, double z) {
        teleportingEntity.m_146922_(yRot);
        teleportingEntity.m_6021_(x, y, z);
        teleportingEntity.m_9236_().m_7605_((Entity)teleportingEntity, (byte)46);
        if (targetVehicle != null) {
            teleportingEntity.m_7998_(targetVehicle, true);
        }
        teleportingEntity.m_5496_(SoundEvents.f_11757_, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        StatGetterEffectLevel statGetter = new StatGetterEffectLevel(enderProjectilesEffect, 1.0);
        GuiStatBar statBar = new GuiStatBar(0, 0, 59, "tetra.stats.enderProjectiles", 0.0, 1.0, false, false, false, (IStatGetter)statGetter, LabelGetterBasic.noLabel, (ITooltipGetter)new TooltipGetterNone("tetra.stats.enderProjectiles.tooltip")).setIndicators(new GuiStatIndicator[]{new GuiStatIndicator(0, 0, "tetra.stats.enderProjectilesYank", 0, 160, TetraceliumTextures.glyphs, (IStatGetter)new StatGetterEffectLevel(enderProjectilesYankEffect, 1.0), (ITooltipGetter)new TooltipGetterNone("tetra.stats.enderProjectilesYank.tooltip")), new GuiStatIndicator(0, 0, "tetra.stats.enderProjectilesJaunt", 8, 160, TetraceliumTextures.glyphs, (IStatGetter)new StatGetterEffectLevel(enderProjectilesJauntEffect, 1.0), (ITooltipGetter)new TooltipGetterNone("tetra.stats.enderProjectilesJaunt.tooltip"))});
        WorkbenchStatsGui.addBar((GuiStatBase)statBar);
        HoloStatsGui.addBar((GuiStatBase)statBar);
    }
}

