/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.crafting;

import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import thetadev.constructionwand.api.IWandUpgrade;
import thetadev.constructionwand.basics.ConfigServer;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.items.wand.ItemWand;

public class RecipeWandUpgrade
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<RecipeWandUpgrade> SERIALIZER = new SimpleCraftingRecipeSerializer(RecipeWandUpgrade::new);

    public RecipeWandUpgrade(ResourceLocation resourceLocation, CraftingBookCategory category) {
        super(resourceLocation, category);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        ItemStack wand = null;
        IWandUpgrade upgrade = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (wand == null && stack.m_41720_() instanceof ItemWand) {
                wand = stack;
                continue;
            }
            if (upgrade == null && stack.m_41720_() instanceof IWandUpgrade) {
                upgrade = (IWandUpgrade)stack.m_41720_();
                continue;
            }
            return false;
        }
        if (wand == null || upgrade == null) {
            return false;
        }
        return !new WandOptions(wand).hasUpgrade(upgrade) && ConfigServer.getWandProperties(wand.m_41720_()).isUpgradeable();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess registryAccess) {
        ItemStack wand = null;
        IWandUpgrade upgrade = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemWand) {
                wand = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof IWandUpgrade)) continue;
            upgrade = (IWandUpgrade)stack.m_41720_();
        }
        if (wand == null || upgrade == null) {
            return ItemStack.f_41583_;
        }
        ItemStack newWand = wand.m_41777_();
        new WandOptions(newWand).addUpgrade(upgrade);
        return newWand;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

