/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.config.ListHandler;
import tschipp.carryon.common.pickupcondition.PickupCondition;
import tschipp.carryon.common.pickupcondition.PickupConditionHandler;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.ScriptManager;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.platform.Services;

public class PickupHandler {
    public static boolean canCarryGeneral(ServerPlayer player, Vec3 pos) {
        if (!player.m_21205_().m_41619_() || !player.m_21206_().m_41619_()) {
            return false;
        }
        if (player.m_20182_().m_82554_(pos) > Constants.COMMON_CONFIG.settings.maxDistance) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (carry.isCarrying()) {
            return false;
        }
        if (!carry.isKeyPressed()) {
            return false;
        }
        if (player.f_19797_ == carry.getTick()) {
            return false;
        }
        return player.f_8941_.m_9290_() != GameType.SPECTATOR && player.f_8941_.m_9290_() != GameType.ADVENTURE;
    }

    public static boolean tryPickUpBlock(ServerPlayer player, BlockPos pos, Level level, @Nullable BiFunction<BlockState, BlockPos, Boolean> pickupCallback) {
        boolean doPickup;
        if (!PickupHandler.canCarryGeneral(player, Vec3.m_82512_((Vec3i)pos))) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        BlockEntity blockEntity = level.m_7702_(pos);
        BlockState state = level.m_8055_(pos);
        CompoundTag nbt = null;
        if (blockEntity != null) {
            nbt = blockEntity.m_187481_();
        }
        if (!ListHandler.isPermitted(state.m_60734_())) {
            return false;
        }
        if (state.m_60800_((BlockGetter)level, pos) == -1.0f && !player.m_7500_() && !Constants.COMMON_CONFIG.settings.pickupUnbreakableBlocks) {
            return false;
        }
        if (blockEntity == null && !Constants.COMMON_CONFIG.settings.pickupAllBlocks) {
            return false;
        }
        if (blockEntity != null && nbt.m_128441_("Lock") && !nbt.m_128461_("Lock").equals("")) {
            return false;
        }
        Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(state);
        if (cond.isPresent() && !cond.get().isFulfilled(player)) {
            return false;
        }
        boolean bl = doPickup = pickupCallback == null ? true : pickupCallback.apply(state, pos);
        if (!doPickup) {
            return false;
        }
        Optional<CarryOnScript> result = ScriptManager.inspectBlock(state, level, pos, nbt);
        if (result.isPresent()) {
            CarryOnScript script = result.get();
            if (!script.fulfillsConditions(player)) {
                return false;
            }
            carry.setActiveScript(script);
            String cmd = script.scriptEffects().commandInit();
            if (!cmd.isEmpty()) {
                player.m_20194_().m_129892_().m_230957_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + cmd);
            }
        }
        carry.setBlock(state, blockEntity);
        level.m_46747_(pos);
        level.m_7471_(pos, false);
        CarryOnDataManager.setCarryData((Player)player, carry);
        level.m_5594_(null, pos, state.m_60827_().m_56778_(), SoundSource.BLOCKS, 1.0f, 0.5f);
        player.m_21011_(InteractionHand.MAIN_HAND, true);
        return true;
    }

    public static boolean tryPickupEntity(ServerPlayer player, Entity entity, @Nullable Function<Entity, Boolean> pickupCallback) {
        String cmd;
        boolean doPickup;
        Optional<PickupCondition> cond;
        block21: {
            block22: {
                if (!PickupHandler.canCarryGeneral(player, entity.m_20182_())) {
                    return false;
                }
                if (entity.f_19802_ != 0) {
                    return false;
                }
                if (entity.m_213877_()) {
                    return false;
                }
                if (entity instanceof TamableAnimal) {
                    TamableAnimal tame = (TamableAnimal)entity;
                    UUID owner = tame.m_21805_();
                    UUID playerID = player.m_36316_().getId();
                    if (owner != null && !owner.equals(playerID)) {
                        return false;
                    }
                }
                if (ListHandler.isPermitted(entity)) break block21;
                if (!(entity instanceof AgeableMob)) break block22;
                AgeableMob ageableMob = (AgeableMob)entity;
                if (Constants.COMMON_CONFIG.settings.allowBabies && (ageableMob.m_146764_() < 0 || ageableMob.m_6162_())) break block21;
            }
            return false;
        }
        if (!player.m_7500_()) {
            if (!Constants.COMMON_CONFIG.settings.pickupHostileMobs && entity.m_6095_().m_20674_() == MobCategory.MONSTER) {
                return false;
            }
            if (Constants.COMMON_CONFIG.settings.maxEntityHeight < (double)entity.m_20206_() || Constants.COMMON_CONFIG.settings.maxEntityWidth < (double)entity.m_20205_()) {
                return false;
            }
        }
        if ((cond = PickupConditionHandler.getPickupCondition(entity)).isPresent() && !cond.get().isFulfilled(player)) {
            return false;
        }
        boolean bl = doPickup = pickupCallback == null ? true : pickupCallback.apply(entity);
        if (!doPickup) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        Optional<CarryOnScript> result = ScriptManager.inspectEntity(entity);
        if (result.isPresent()) {
            CarryOnScript script = result.get();
            if (!script.fulfillsConditions(player)) {
                return false;
            }
            carry.setActiveScript(script);
        }
        if (entity instanceof Player) {
            String cmd2;
            Player otherPlayer = (Player)entity;
            if (!Constants.COMMON_CONFIG.settings.pickupPlayers) {
                return false;
            }
            if (!player.m_7500_() && otherPlayer.m_7500_()) {
                return false;
            }
            otherPlayer.m_20153_();
            otherPlayer.m_8127_();
            if (result.isPresent() && !(cmd2 = result.get().scriptEffects().commandInit()).isEmpty()) {
                player.m_20194_().m_129892_().m_230957_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + cmd2);
            }
            otherPlayer.m_20329_((Entity)player);
            Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_START_RIDING, new ClientboundStartRidingPacket(otherPlayer.m_19879_(), true), player);
            carry.setCarryingPlayer();
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_11675_, SoundSource.AMBIENT, 1.0f, 0.5f);
            CarryOnDataManager.setCarryData((Player)player, carry);
            return true;
        }
        entity.m_20153_();
        entity.m_8127_();
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            animal.m_21455_(true, true);
        }
        if (result.isPresent() && !(cmd = result.get().scriptEffects().commandInit()).isEmpty()) {
            player.m_20194_().m_129892_().m_230957_(player.m_20194_().m_129893_(), "/execute as " + player.m_36316_().getName() + " run " + cmd);
        }
        carry.setEntity(entity);
        entity.m_142687_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_11675_, SoundSource.AMBIENT, 1.0f, 0.5f);
        CarryOnDataManager.setCarryData((Player)player, carry);
        player.m_21011_(InteractionHand.MAIN_HAND, true);
        return true;
    }
}

