/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.common.level;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.handler.CustomRandomTickHandler;
import com.teamtea.eclipticseasons.compat.vanilla.VanillaWeather;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerLevel
extends Level {
    protected MixinServerLevel(WritableLevelData pLevelData, ResourceKey<Level> pDimension, RegistryAccess pRegistryAccess, Holder<DimensionType> pDimensionTypeRegistration, Supplier<ProfilerFiller> pProfiler, boolean pIsClientSide, boolean pIsDebug, long pBiomeZoomSeed, int pMaxChainedNeighborUpdates) {
        super(pLevelData, pDimension, pRegistryAccess, pDimensionTypeRegistration, pProfiler, pIsClientSide, pIsDebug, pBiomeZoomSeed, pMaxChainedNeighborUpdates);
    }

    @Inject(at={@At(value="HEAD")}, method={"resetWeatherCycle"}, cancellable=true)
    public void eclipticseasons$resetWeatherCycle(CallbackInfo ci) {
        if (EclipticUtil.hasLocalWeather(this)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"advanceWeatherCycle"}, cancellable=true)
    public void eclipticseasons$advanceWeatherCycle(CallbackInfo ci) {
        boolean cancel = WeatherManager.agentAdvanceWeatherCycle((ServerLevel)this, null, null, ((ServerLevel)this).m_213780_());
        if (cancel && EclipticUtil.hasLocalWeather(this)) {
            ci.cancel();
        }
    }

    @WrapOperation(method={"advanceWeatherCycle"}, at={@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/util/valueproviders/IntProvider;sample(Lnet/minecraft/util/RandomSource;)I")})
    private int eclipticseasons$advanceWeatherCycle_sample_THUNDER_DELAY(IntProvider intProvider, RandomSource randomSource, Operation<Integer> original) {
        if (!EclipticUtil.hasLocalWeather(this)) {
            return VanillaWeather.replaceThunderDelay(this, (Integer)original.call(new Object[]{intProvider, randomSource}));
        }
        return (Integer)original.call(new Object[]{intProvider, randomSource});
    }

    @WrapOperation(method={"advanceWeatherCycle"}, at={@At(value="INVOKE", ordinal=3, target="Lnet/minecraft/util/valueproviders/IntProvider;sample(Lnet/minecraft/util/RandomSource;)I")})
    private int eclipticseasons$advanceWeatherCycle_sample_RAIN_DELAY(IntProvider intProvider, RandomSource randomSource, Operation<Integer> original) {
        if (!EclipticUtil.hasLocalWeather(this)) {
            return VanillaWeather.replaceRainDelay(this, (Integer)original.call(new Object[]{intProvider, randomSource}));
        }
        return (Integer)original.call(new Object[]{intProvider, randomSource});
    }

    @Inject(method={"tickChunk"}, at={@At(value="HEAD")})
    private void eclipticseasons$tickChunk_handleRandomTick_clear(LevelChunk chunk, int randomTickSpeed, CallbackInfo ci) {
        CropGrowthHandler.handleChunkTick(this, chunk);
    }

    @WrapOperation(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;getPrecipitationAt(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/biome/Biome$Precipitation;")})
    private Biome.Precipitation eclipticseasons$tickChunk_getPrecipitationAt(Biome biome, BlockPos pos, Operation<Biome.Precipitation> original) {
        if (EclipticUtil.hasLocalWeather(this)) {
            return WeatherManager.getPrecipitationAt(this, biome, pos);
        }
        return VanillaWeather.handlePrecipitationAt(this, biome, pos);
    }

    @WrapOperation(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isThundering()Z")})
    private boolean eclipticseasons$tickChunk_initIfThunder(ServerLevel serverLevel, Operation<Boolean> original) {
        if (EclipticUtil.hasLocalWeather(this)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{serverLevel});
    }

    @ModifyExpressionValue(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isRainingAt(Lnet/minecraft/core/BlockPos;)Z")})
    private boolean eclipticseasons$tickChunk_setIfThunder(boolean original, @Local(ordinal=0) BlockPos blockPos) {
        if (original && EclipticUtil.hasLocalWeather(this)) {
            original = WeatherManager.isThunderAt((Level)((ServerLevel)this), blockPos);
        }
        return original;
    }

    @WrapOperation(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isRaining()Z")})
    private boolean eclipticseasons$tickChunk_initIfRain(ServerLevel serverLevel, Operation<Boolean> original) {
        if (EclipticUtil.hasLocalWeather(this)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{serverLevel});
    }

    @Inject(remap=false, method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isAreaLoaded(Lnet/minecraft/core/BlockPos;I)Z")})
    private void eclipticseasons$tickChunk_setIfRain(LevelChunk pChunk, int pRandomTickSpeed, CallbackInfo ci, @Local(ordinal=0) BlockPos blockPos, @Local Biome biome, @Local LocalBooleanRef booleanRef) {
        if (EclipticUtil.hasLocalWeather(this)) {
            booleanRef.set(WeatherManager.getRainOrSnow((Level)((ServerLevel)this), biome, blockPos) != Biome.Precipitation.NONE);
        }
    }

    @Inject(remap=false, method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isAreaLoaded(Lnet/minecraft/core/BlockPos;I)Z")})
    private void eclipticseasons$tickChunk_melt(LevelChunk pChunk, int pRandomTickSpeed, CallbackInfo ci, @Local Biome biome, @Local(ordinal=0) BlockPos blockPos) {
        if (((Boolean)CommonConfig.Temperature.iceMelt.get()).booleanValue()) {
            CustomRandomTickHandler.SNOW_MELT_2.tick((ServerLevel)this, biome, blockPos);
        }
    }

    @WrapOperation(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;shouldFreeze(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z")})
    private boolean eclipticseasons$tickChunk_freeze(Biome instance, LevelReader pLevel, BlockPos pPos, Operation<Boolean> original) {
        return CustomRandomTickHandler.checkExtraFreezeCondition((ServerLevel)this, instance, pPos);
    }

    @WrapOperation(method={"tickChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;shouldSnow(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z")})
    private boolean eclipticseasons$tickChunk_snow(Biome instance, LevelReader pLevel, BlockPos pPos, Operation<Boolean> original) {
        return CustomRandomTickHandler.checkExtraSnowCondition((ServerLevel)this, instance, pPos);
    }
}

