/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.common.level;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.teamtea.eclipticseasons.api.misc.IBiomeWeatherProvider;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public class MixinLevel
implements IBiomeWeatherProvider {
    @Unique
    private ArrayList<WeatherManager.BiomeWeather> eclipticseasons$biomeWeathers;

    @Inject(at={@At(value="HEAD")}, method={"isRaining"}, cancellable=true)
    private void eclipticseasons$isRaining(CallbackInfoReturnable<Boolean> cir) {
        ServerLevel serverLevel;
        MixinLevel mixinLevel = this;
        if (mixinLevel instanceof ServerLevel && EclipticUtil.hasLocalWeather((Level)(serverLevel = (ServerLevel)mixinLevel))) {
            if (((Boolean)CommonConfig.Debug.logIllegalUse.get()).booleanValue()) {
                try {
                    throw new IllegalCallerException("Use isRainAt to check if rain");
                }
                catch (IllegalCallerException e) {
                    e.printStackTrace();
                }
            }
            cir.setReturnValue((Object)WeatherManager.isRainingEverywhere(serverLevel));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getRainLevel"}, cancellable=true)
    private void eclipticseasons$getRainLevel(float p_46723_, CallbackInfoReturnable<Float> cir) {
        ServerLevel serverLevel;
        MixinLevel mixinLevel = this;
        if (mixinLevel instanceof ServerLevel && EclipticUtil.hasLocalWeather((Level)(serverLevel = (ServerLevel)mixinLevel))) {
            if (((Boolean)CommonConfig.Debug.logIllegalUse.get()).booleanValue()) {
                try {
                    throw new IllegalCallerException("Shouldn't call getRainLevel now");
                }
                catch (IllegalCallerException e) {
                    e.printStackTrace();
                }
            }
            cir.setReturnValue((Object)Float.valueOf(WeatherManager.getMinRainLevel((Level)serverLevel, p_46723_)));
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isRaining()Z")}, method={"isRainingAt"})
    private boolean eclipticseasons$isRainingAt_skipRainCheck(Level instance, Operation<Boolean> original) {
        return EclipticUtil.hasLocalWeather(instance) && instance instanceof ServerLevel || (Boolean)original.call(new Object[]{instance}) != false;
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;")}, method={"isRainingAt"}, cancellable=true)
    private void eclipticseasons$isRainingAt_endBiomeCheck(BlockPos p_46759_, CallbackInfoReturnable<Boolean> cir) {
        ServerLevel level;
        MixinLevel mixinLevel = this;
        if (mixinLevel instanceof ServerLevel && EclipticUtil.hasLocalWeather((Level)(level = (ServerLevel)mixinLevel))) {
            cir.setReturnValue((Object)WeatherManager.isRainingUnderSky((Level)level, p_46759_));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isThundering"}, cancellable=true)
    private void eclipticseasons$isThundering(CallbackInfoReturnable<Boolean> cir) {
        ServerLevel serverLevel;
        MixinLevel mixinLevel = this;
        if (mixinLevel instanceof ServerLevel && EclipticUtil.hasLocalWeather((Level)(serverLevel = (ServerLevel)mixinLevel))) {
            if (((Boolean)CommonConfig.Debug.logIllegalUse.get()).booleanValue()) {
                try {
                    throw new IllegalCallerException("Use isThunderingAt to check if rain");
                }
                catch (IllegalCallerException e) {
                    e.printStackTrace();
                }
            }
            cir.setReturnValue((Object)WeatherManager.isThunderEverywhere(serverLevel));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getThunderLevel"}, cancellable=true)
    private void eclipticseasons$getThunderLevel(float p_46723_, CallbackInfoReturnable<Float> cir) {
        ServerLevel serverLevel;
        MixinLevel mixinLevel = this;
        if (mixinLevel instanceof ServerLevel && EclipticUtil.hasLocalWeather((Level)(serverLevel = (ServerLevel)mixinLevel))) {
            if (((Boolean)CommonConfig.Debug.logIllegalUse.get()).booleanValue()) {
                try {
                    throw new IllegalCallerException("Shouldn't call getThunderLevel now");
                }
                catch (IllegalCallerException e) {
                    e.printStackTrace();
                }
            }
            cir.setReturnValue((Object)Float.valueOf(WeatherManager.getMinThunderLevel((Level)serverLevel, p_46723_)));
        }
    }

    @Override
    public ArrayList<WeatherManager.BiomeWeather> es$get() {
        return this.eclipticseasons$biomeWeathers;
    }

    @Override
    public void es$set(ArrayList<WeatherManager.BiomeWeather> biomeWeathers) {
        this.eclipticseasons$biomeWeathers = biomeWeathers;
    }
}

