/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.mixin.client.render.chunk;

import com.teamtea.eclipticseasons.api.misc.client.IMapSlice;
import com.teamtea.eclipticseasons.compat.vanilla.IExtendBlockView;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Pseudo
@Mixin(value={RenderChunkRegion.class})
public abstract class MixinChunkSlice
implements IMapSlice,
IExtendBlockView {
    @Shadow
    @Final
    protected Level f_112908_;
    @Shadow
    @Final
    private int f_112899_;
    @Shadow
    @Final
    private int f_112900_;
    @Unique
    private int[][] HEIGHT_MAP;
    @Unique
    private int[][] SOLID_HEIGHT_MAP;
    @Unique
    private int[][] BIOME_MAP;
    @Unique
    private int SIZE_X;
    @Unique
    private int SIZE_Z;
    @Unique
    BakedModel eclipticseasons$bakedModelSnow = null;
    @Unique
    private BlockPos.MutableBlockPos eclipticseasons$mutableBlockPos = new BlockPos.MutableBlockPos();

    @Override
    public void forceMapSliceUpdate(int[][] heights, int[][] solidHeights, int[][] biomes, int sizex, int sizez) {
        this.HEIGHT_MAP = heights;
        this.SOLID_HEIGHT_MAP = solidHeights;
        this.BIOME_MAP = biomes;
        this.SIZE_X = sizex;
        this.SIZE_Z = sizez;
    }

    @Override
    public int getSolidBlockHeight(BlockPos pos) {
        if (this.SOLID_HEIGHT_MAP == null || this.SOLID_HEIGHT_MAP[0] == null) {
            return 0;
        }
        int relBlockX = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int relBlockZ = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        int[] lightArrays = this.SOLID_HEIGHT_MAP[relBlockX + relBlockZ * this.SIZE_X];
        int localBlockX = pos.m_123341_() & 0xF;
        int localBlockZ = pos.m_123343_() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getBlockHeight(BlockPos pos) {
        if (this.HEIGHT_MAP == null || this.HEIGHT_MAP[0] == null) {
            return 0;
        }
        int relBlockX = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int relBlockZ = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        int[] lightArrays = this.HEIGHT_MAP[relBlockX + relBlockZ * this.SIZE_X];
        int localBlockX = pos.m_123341_() & 0xF;
        int localBlockZ = pos.m_123343_() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public int getSurfaceFaceBiomeId(BlockPos pos) {
        if (this.BIOME_MAP == null || this.BIOME_MAP[0] == null) {
            return 0;
        }
        int relBlockX = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int relBlockZ = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        int[] lightArrays = this.BIOME_MAP[relBlockX + relBlockZ * this.SIZE_X];
        int localBlockX = pos.m_123341_() & 0xF;
        int localBlockZ = pos.m_123343_() & 0xF;
        return lightArrays[localBlockX * 16 + localBlockZ];
    }

    @Override
    public BakedModel eclipticseasons$getSnowModel() {
        return this.eclipticseasons$bakedModelSnow;
    }

    @Override
    public void eclipticseasons$setSnowModel(BakedModel bakedModel) {
        this.eclipticseasons$bakedModelSnow = bakedModel;
    }

    @Override
    public BlockPos.MutableBlockPos getModelCheckPos() {
        return this.eclipticseasons$mutableBlockPos;
    }
}

