/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.data.general.model;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ESItemModelProvider
extends ItemModelProvider {
    public static final String GENERATED = "item/generated";
    public static final String HANDHELD = "item/handheld";

    public ESItemModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    private String blockName(BlockItem blockItem) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)blockItem.m_40614_()).m_135815_();
    }

    protected void registerModels() {
        this.addSimple((Item)ItemRegistry.calendar_item.get());
        this.addSimple((Item)ItemRegistry.broom.get());
        this.addSimple((Item)ItemRegistry.wind_chimes_item.get());
        this.addSimple((Item)ItemRegistry.paper_wind_chimes_item.get());
        this.addSimple((Item)ItemRegistry.bamboo_wind_chimes_item.get());
        this.addSimple((ItemLike)ItemRegistry.pinwheel_blue_item.get(), "pinwheel_blue_item");
        this.addSimple((ItemLike)ItemRegistry.pinwheel_lime_item.get(), "pinwheel_lime_item");
        this.addSimple((ItemLike)ItemRegistry.pinwheel_orange_item.get(), "pinwheel_orange_item");
        this.addSimple((Item)ItemRegistry.seasonal_prayer_scroll_item.get());
        this.addSimple((Item)ItemRegistry.growth_detector.get());
        this.withExistingParent(this.resourceItem(ItemRegistry.block_in_wooden_grate_block_item.getId().m_135815_()).m_135815_(), this.resourceBlock(ItemRegistry.block_in_wooden_grate_block_item.getId().m_135815_()));
        this.withExistingParent(this.itemName((Item)ItemRegistry.spring_greenhouse_essence_item.get()), this.resourceItem("empty"));
        this.withExistingParent(this.itemName((Item)ItemRegistry.summer_greenhouse_essence_item.get()), this.resourceItem("empty"));
        this.withExistingParent(this.itemName((Item)ItemRegistry.autumn_greenhouse_essence_item.get()), this.resourceItem("empty"));
        this.withExistingParent(this.itemName((Item)ItemRegistry.winter_greenhouse_essence_item.get()), this.resourceItem("empty"));
    }

    public void addSimple(Item item) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), new ResourceLocation(GENERATED))).texture("layer0", this.resourceItem(this.itemName(item)));
    }

    public void addSimple(ItemLike item, String texture) {
        ((ItemModelBuilder)this.withExistingParent(this.itemName(item), new ResourceLocation(GENERATED))).texture("layer0", this.resourceItem(texture));
    }

    private String itemName(ItemLike item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()).m_135815_();
    }

    private String itemName(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
    }

    public ResourceLocation resourceItem(String path) {
        return EclipticSeasons.rl("item/" + path);
    }

    public ResourceLocation resourceBlock(String path) {
        return EclipticSeasons.rl("block/" + path);
    }
}

