/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.network.message;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChunkBiomeUpdateMessage
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public int[] biomes;
    public int x;
    public int z;
    public int version;
    public static final Capability<ChunkBiomeUpdateMessage> CHUNK_BIOME_UPDATE_MESSAGE_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkBiomeUpdateMessage>(){});
    public static final int FLAG_NEED_VERSION = -1;
    public static final int FLAG_FILL_SMALL = -2;
    public static final int FLAG_EMPTY = -3;

    public ChunkBiomeUpdateMessage() {
        this(new int[256], 0, 0, -3);
    }

    public ChunkBiomeUpdateMessage(int[] biomes, int x, int z, int version) {
        this.biomes = biomes;
        this.x = x;
        this.z = z;
        this.version = version;
    }

    public ChunkBiomeUpdateMessage(FriendlyByteBuf buf) {
        int size = buf.readInt();
        int[] list = new int[size];
        for (int i = 0; i < size; ++i) {
            list[i] = buf.m_130242_();
        }
        this.biomes = list;
        this.x = buf.m_130242_();
        this.z = buf.m_130242_();
        this.version = buf.m_130242_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.biomes.length);
        for (int i : this.biomes) {
            buf.m_130130_(i);
        }
        buf.m_130130_(this.x);
        buf.m_130130_(this.z);
        buf.m_130130_(this.version);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CHUNK_BIOME_UPDATE_MESSAGE_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128385_("biomes", this.biomes);
        tag.m_128405_("x", this.x);
        tag.m_128405_("z", this.z);
        tag.m_128405_("version", this.version);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.biomes = nbt.m_128465_("biomes");
        this.x = nbt.m_128451_("x");
        this.z = nbt.m_128451_("z");
        this.version = nbt.m_128451_("version");
    }
}

