/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.network;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.common.network.NetworkUtil;
import com.teamtea.eclipticseasons.common.network.message.BiomeWeatherMessage;
import com.teamtea.eclipticseasons.common.network.message.BroomUseMessage;
import com.teamtea.eclipticseasons.common.network.message.ChunkBiomeUpdateMessage;
import com.teamtea.eclipticseasons.common.network.message.DataPackEventMessage;
import com.teamtea.eclipticseasons.common.network.message.EmptyMessage;
import com.teamtea.eclipticseasons.common.network.message.HumidModifyMessage;
import com.teamtea.eclipticseasons.common.network.message.MapFixerMessage;
import com.teamtea.eclipticseasons.common.network.message.SolarTermsMessage;
import com.teamtea.eclipticseasons.common.network.message.UpdateTempChangeMessage;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public final class SimpleNetworkHandler {
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)EclipticSeasons.rl("main")).networkProtocolVersion(() -> "1.0").serverAcceptedVersions("1.0"::equals).clientAcceptedVersions("1.0"::equals).simpleChannel();

    public static void init() {
        int id = 0;
        SimpleChannel.MessageBuilder a = CHANNEL.messageBuilder(SolarTermsMessage.class, id++).encoder(SolarTermsMessage::toBytes).decoder(SolarTermsMessage::new);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            a.consumerNetworkThread(NetworkUtil::processSolarTermsMessage);
        }
        a.add();
        SimpleChannel.MessageBuilder c = CHANNEL.messageBuilder(BiomeWeatherMessage.class, id++).encoder(BiomeWeatherMessage::toBytes).decoder(BiomeWeatherMessage::new);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            c.consumerNetworkThread(NetworkUtil::processBiomeWeatherMessage);
        }
        c.add();
        SimpleChannel.MessageBuilder d = CHANNEL.messageBuilder(EmptyMessage.class, id++).encoder(EmptyMessage::toBytes).decoder(EmptyMessage::new);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            d.consumerNetworkThread(NetworkUtil::processEmptyMessage);
        }
        d.add();
        SimpleChannel.MessageBuilder e = CHANNEL.messageBuilder(BroomUseMessage.class, id++).encoder(BroomUseMessage::toBytes).decoder(BroomUseMessage::new);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            e.consumerNetworkThread(NetworkUtil::processBroomUseMessage);
        }
        e.add();
        SimpleChannel.MessageBuilder f = CHANNEL.messageBuilder(DataPackEventMessage.class, id++).encoder(DataPackEventMessage::toBytes).decoder(DataPackEventMessage::new);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            f.consumerNetworkThread(NetworkUtil::processDataPackEvent);
        }
        f.add();
        SimpleChannel.MessageBuilder g = CHANNEL.messageBuilder(HumidModifyMessage.class, id++).encoder(HumidModifyMessage::toBytes).decoder(HumidModifyMessage::new);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            g.consumerNetworkThread(NetworkUtil::processHumidModifyMessage);
        }
        g.add();
        SimpleChannel.MessageBuilder h = CHANNEL.messageBuilder(MapFixerMessage.class, id++).encoder(MapFixerMessage::toBytes).decoder(MapFixerMessage::new);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            h.consumerNetworkThread(NetworkUtil::processMapFixerMessage);
        }
        h.add();
        SimpleChannel.MessageBuilder i = CHANNEL.messageBuilder(UpdateTempChangeMessage.class, id++).encoder(UpdateTempChangeMessage::toBytes).decoder(UpdateTempChangeMessage::new);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            i.consumerNetworkThread(NetworkUtil::processUpdateTempChangeMessage);
        }
        i.add();
        SimpleChannel.MessageBuilder j = CHANNEL.messageBuilder(ChunkBiomeUpdateMessage.class, id++).encoder(ChunkBiomeUpdateMessage::toBytes).decoder(ChunkBiomeUpdateMessage::new);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            j.consumerNetworkThread(NetworkUtil::processChunkBiomeUpdateMessage);
        }
        j.add();
    }

    private static void registerMessage(int i, Class<BiomeWeatherMessage> biomeWeatherMessageClass, Object o) {
    }

    public static <MSG> void send(ServerPlayer player, MSG msg) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), msg);
    }

    public static <MSG> void send(List<ServerPlayer> players, MSG msg) {
        players.forEach(player -> SimpleNetworkHandler.send(player, msg));
    }
}

