/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.network;

import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.client.color.season.BiomeColorsHandler;
import com.teamtea.eclipticseasons.client.core.ClientWeatherChecker;
import com.teamtea.eclipticseasons.client.map.ClientMapFixer;
import com.teamtea.eclipticseasons.client.render.WorldRenderer;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.network.message.BiomeWeatherMessage;
import com.teamtea.eclipticseasons.common.network.message.BroomUseMessage;
import com.teamtea.eclipticseasons.common.network.message.ChunkBiomeUpdateMessage;
import com.teamtea.eclipticseasons.common.network.message.DataPackEventMessage;
import com.teamtea.eclipticseasons.common.network.message.EmptyMessage;
import com.teamtea.eclipticseasons.common.network.message.HumidModifyMessage;
import com.teamtea.eclipticseasons.common.network.message.MapFixerMessage;
import com.teamtea.eclipticseasons.common.network.message.SolarTermsMessage;
import com.teamtea.eclipticseasons.common.network.message.UpdateTempChangeMessage;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class NetworkUtil {
    public static Level getClient() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static Player getPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static boolean processSolarTermsMessage(SolarTermsMessage solarTermsMessage, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                SolarHolders.getSaveDataLazy(NetworkUtil.getClient()).ifPresent(data -> {
                    data.setSolarTermsDay(solarTermsMessage.solarDay);
                    BiomeColorsHandler.needRefresh = true;
                    ClientCon.tick(NetworkUtil.getClient());
                });
            }
        });
        return true;
    }

    public static boolean processBiomeWeatherMessage(BiomeWeatherMessage biomeWeatherMessage, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ArrayList<WeatherManager.BiomeWeather> lists;
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (lists = WeatherManager.getBiomeList(NetworkUtil.getClient())) != null) {
                for (WeatherManager.BiomeWeather biomeWeather : lists) {
                    if (biomeWeatherMessage.rain[biomeWeather.id] == 0 && biomeWeather.rainTime > 0) {
                        ClientWeatherChecker.addLastRainyBiome((Biome)biomeWeather.biomeHolder.m_203334_(), (long)(1.0f / ClientWeatherChecker.getRate()));
                    }
                    biomeWeather.rainTime = biomeWeatherMessage.rain[biomeWeather.id] * 10000;
                    biomeWeather.clearTime = biomeWeatherMessage.clear[biomeWeather.id] * 10000;
                    biomeWeather.thunderTime = biomeWeatherMessage.thuder[biomeWeather.id] * 10000;
                    biomeWeather.snowDepth = biomeWeatherMessage.snowDepth[biomeWeather.id];
                }
            }
        });
        return true;
    }

    public static boolean processEmptyMessage(EmptyMessage emptyMessage, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                if (((Boolean)ClientConfig.Renderer.resetRendererAfterSleep.get()).booleanValue()) {
                    Minecraft.m_91087_().f_91060_.m_109818_();
                } else {
                    Entity patt4451$temp = Minecraft.m_91087_().f_91075_;
                    if (patt4451$temp instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)patt4451$temp;
                        WorldRenderer.setAllDirty(SectionPos.m_123199_((BlockPos)livingEntity.m_20097_()));
                    }
                }
            }
        });
        return true;
    }

    public static boolean processBroomUseMessage(BroomUseMessage broomUseMessage, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Level client;
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (client = NetworkUtil.getClient()) != null) {
                int startY = client.m_151558_() + 1;
                BlockPos blockPos = broomUseMessage.blockPos;
                ClientMapFixer.addPlanner(client, Blocks.f_50016_.m_49966_(), blockPos, client.m_46467_(), startY);
                WorldRenderer.setSectionDirtyWithNeighbors(SectionPos.m_123199_((BlockPos)blockPos));
            }
        });
        return true;
    }

    public static boolean processDataPackEvent(DataPackEventMessage dataPackEvent, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                RegistryAccess registryAccess = ClientCon.getUseLevel().m_9598_();
                if (dataPackEvent.resourceKey.equals(ESRegistries.HUMIDITY_CONTROL)) {
                    List<HumidityControl> build = dataPackEvent.build(registryAccess, HumidityControl.class);
                    ClientCon.humidityControls.addAll(build);
                } else if (dataPackEvent.resourceKey.equals(ESRegistries.BIOME_CLIMATE_SETTING)) {
                    ClientCon.biomeDataPackCache = dataPackEvent;
                } else if (dataPackEvent.resourceKey.equals(ESRegistries.SNOW_DEFINITIONS)) {
                    ClientCon.snowDefCache = dataPackEvent;
                } else if (dataPackEvent.resourceKey.equals(ESRegistries.SEASON_CYCLE)) {
                    ClientCon.seasonCycleCache = dataPackEvent;
                } else if (dataPackEvent.resourceKey.equals(ESRegistries.BIOME_RAIN)) {
                    ClientCon.biomeRainCache = dataPackEvent;
                } else if (dataPackEvent.resourceKey.equals(ESRegistries.SNOW_TERM)) {
                    ClientCon.snowTermCache = dataPackEvent;
                } else if (dataPackEvent.resourceKey.equals(ESRegistries.AGRO_CLIMATE)) {
                    ClientCon.aczCache = dataPackEvent;
                } else if (dataPackEvent.resourceKey.equals(ESRegistries.CROP)) {
                    ClientCon.cropCache = dataPackEvent;
                }
            }
        });
        return true;
    }

    public static boolean processHumidModifyMessage(HumidModifyMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Level client;
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (client = NetworkUtil.getClient()) != null) {
                ClientCon.humidityModificationLevel = message.value;
            }
        });
        return true;
    }

    public static boolean processMapFixerMessage(MapFixerMessage mapFixerMessage, Supplier<NetworkEvent.Context> context) {
        HashSet<SectionPos> sectionPosSet = new HashSet<SectionPos>();
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>(mapFixerMessage.blockPosList);
        for (int i = 0; i < mapFixerMessage.blockPosList.size(); ++i) {
            BlockPos blockPos = (BlockPos)blockPosList.get(i);
            BlockPos blockPos1 = new BlockPos(blockPos.m_123341_(), mapFixerMessage.startYList.get(i).intValue(), blockPos.m_123343_());
            blockPosList.add(blockPos1);
            sectionPosSet.add(SectionPos.m_123199_((BlockPos)blockPos));
            sectionPosSet.add(SectionPos.m_123199_((BlockPos)blockPos1));
        }
        context.get().enqueueWork(() -> {
            Level level = NetworkUtil.getClient();
            if (level != null && level.m_5776_()) {
                for (BlockPos blockPos : mapFixerMessage.blockPosList) {
                    MapChecker.updatePosForce(level, blockPos, blockPos.m_123342_());
                }
                for (SectionPos ySection : sectionPosSet) {
                    WorldRenderer.setSectionDirty(ySection);
                }
            }
        });
        return true;
    }

    public static boolean processUpdateTempChangeMessage(UpdateTempChangeMessage emptyMessage, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (NetworkUtil.getClient() != null) {
                SolarHolders.getSaveDataLazy(NetworkUtil.getClient()).ifPresent(solarDataManager -> solarDataManager.setSolarTempChange(emptyMessage.change));
            }
        });
        return true;
    }

    public static boolean processChunkBiomeUpdateMessage(ChunkBiomeUpdateMessage chunkBiomeUpdateMessage, Supplier<NetworkEvent.Context> iPayloadContext) {
        iPayloadContext.get().enqueueWork(() -> {
            if (ClientCon.getUseLevel() != null) {
                ChunkPos chunkPos = new ChunkPos(chunkBiomeUpdateMessage.x, chunkBiomeUpdateMessage.z);
                int minBlockX = chunkPos.m_45604_();
                int minBlockZ = chunkPos.m_45605_();
                ChunkInfoMap chunkMap = MapChecker.getChunkInfoMapOrCreate(ClientCon.getUseLevel(), chunkPos.m_151394_(64));
                if (chunkMap != null) {
                    int[] biomes = chunkBiomeUpdateMessage.biomes;
                    for (int i = 0; i < 16; ++i) {
                        for (int j = 0; j < 16; ++j) {
                            chunkMap.updateBiome(minBlockX + i, minBlockZ + j, biomes[i * 16 + j]);
                        }
                    }
                }
            }
        });
        return true;
    }
}

