/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.handler;

import com.teamtea.eclipticseasons.api.misc.CustomRandomTick2;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.config.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public final class CustomRandomTickHandler {
    public static final CustomRandomTick2 SNOW_MELT_2 = (world, biome, blockpos) -> {
        if (WeatherManager.getSnowStatus(world, biome, blockpos) == WeatherManager.SnowRenderStatus.SNOW_MELT) {
            BlockState belowState;
            BlockState topState = world.m_8055_(blockpos);
            if (topState.m_60713_(Blocks.f_50125_)) {
                int layer = (Integer)topState.m_61143_((Property)SnowLayerBlock.f_56581_);
                world.m_46597_(blockpos, layer <= 2 ? Blocks.f_50016_.m_49966_() : (BlockState)topState.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layer - 2)));
            }
            if ((belowState = world.m_8055_(blockpos.m_7495_())).m_60713_(Blocks.f_50126_)) {
                if (world.m_6042_().f_63857_()) {
                    world.m_7471_(blockpos, false);
                } else {
                    world.m_46597_(blockpos.m_7495_(), Blocks.f_49990_.m_49966_());
                }
            }
        }
    };
    @Deprecated(forRemoval=true)
    public static final CustomRandomTick2 SNOW_MELT = (world, biome, blockpos) -> {
        if (WeatherManager.getSnowStatus(world, biome, blockpos) == WeatherManager.SnowRenderStatus.SNOW) {
            BlockPos below;
            BlockState blockstate;
            int layers;
            if (blockpos.m_123342_() >= world.m_141937_() && blockpos.m_123342_() < world.m_151558_() && world.m_45517_(LightLayer.BLOCK, blockpos) < 10 && (layers = world.m_46469_().m_46215_(GameRules.f_254637_)) > 0) {
                blockstate = world.m_8055_(blockpos);
                if (blockstate.m_60713_(Blocks.f_50125_)) {
                    int k = (Integer)blockstate.m_61143_((Property)SnowLayerBlock.f_56581_);
                    if (k < Math.min(layers, 8)) {
                        BlockState snowState = (BlockState)blockstate.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(k + 1));
                        Block.m_49897_((BlockState)blockstate, (BlockState)snowState, (LevelAccessor)world, (BlockPos)blockpos);
                        world.m_46597_(blockpos, snowState);
                    }
                } else {
                    world.m_46597_(blockpos, Blocks.f_50125_.m_49966_());
                }
            }
            if ((below = blockpos.m_7495_()).m_123342_() >= world.m_141937_() && below.m_123342_() < world.m_151558_() && world.m_45517_(LightLayer.BLOCK, below) < 10) {
                blockstate = world.m_8055_(below);
                FluidState fluidstate = world.m_6425_(below);
                if (fluidstate.m_76152_() == Fluids.f_76193_ && blockstate.m_60734_() instanceof LiquidBlock) {
                    boolean flag;
                    boolean bl = flag = world.m_46801_(below.m_122024_()) && world.m_46801_(below.m_122029_()) && world.m_46801_(below.m_122012_()) && world.m_46801_(below.m_122019_());
                    if (!flag) {
                        world.m_46597_(below, Blocks.f_50126_.m_49966_());
                    }
                }
            }
        }
    };

    public static boolean checkExtraSnowCondition(ServerLevel level, Biome biomeHolder, BlockPos pos) {
        if (((Boolean)CommonConfig.Temperature.snowDown.get()).booleanValue() && WeatherManager.getSnowStatus(level, biomeHolder, pos) == WeatherManager.SnowRenderStatus.SNOW) {
            BlockState blockstate;
            return pos.m_123342_() >= level.m_141937_() && pos.m_123342_() < level.m_151558_() && level.m_45517_(LightLayer.BLOCK, pos) < 10 && ((blockstate = level.m_8055_(pos)).m_60795_() || blockstate.m_60713_(Blocks.f_50125_)) && Blocks.f_50125_.m_49966_().m_60710_((LevelReader)level, pos);
        }
        return false;
    }

    public static boolean checkExtraFreezeCondition(ServerLevel level, Biome biomeHolder, BlockPos water) {
        if (((Boolean)CommonConfig.Temperature.snowDown.get()).booleanValue() && WeatherManager.getSnowStatus(level, biomeHolder, water) == WeatherManager.SnowRenderStatus.SNOW) {
            if (water.m_123342_() >= level.m_141937_() && water.m_123342_() < level.m_151558_() && level.m_45517_(LightLayer.BLOCK, water) < 10) {
                BlockState blockstate = level.m_8055_(water);
                FluidState fluidstate = level.m_6425_(water);
                if (fluidstate.m_76152_() == Fluids.f_76193_ && blockstate.m_60734_() instanceof LiquidBlock) {
                    boolean flag;
                    boolean bl = flag = level.m_46801_(water.m_122024_()) && level.m_46801_(water.m_122029_()) && level.m_46801_(water.m_122012_()) && level.m_46801_(water.m_122019_());
                    if (!flag) {
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }
}

