/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.game;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.game.BreedSeasonType;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.tag.AnimalBehaviorTag;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.common.core.SolarHolders;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.solar.SolarDataManager;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class AnimalHooks {
    public static Season findCurrentSeason(List<Pair<Season, Integer>> localSeason, int index, Season defaultGet) {
        if (localSeason.isEmpty()) {
            return defaultGet;
        }
        if (localSeason.size() == 1) {
            return (Season)localSeason.get(0).getFirst();
        }
        int accumulatedLength = 0;
        for (int i = 0; i < localSeason.size(); ++i) {
            Season season = (Season)localSeason.get(i).getFirst();
            int seasonLength = (Integer)localSeason.get(i).getSecond();
            if (index < accumulatedLength + seasonLength) {
                return season;
            }
            accumulatedLength += seasonLength;
        }
        return defaultGet;
    }

    public static Season getUseSeason(Level level, Entity entity) {
        BlockPos pos = entity.m_20183_();
        return AnimalHooks.getUseSeason(level, pos);
    }

    public static Season getUseSeason(Level level, BlockPos pos) {
        SolarTerm nowSolarTerm = EclipticSeasonsApi.getInstance().getSolarTerm(level);
        Holder<Biome> cropBiome = CropGrowthHandler.getCropBiome((LevelAccessor)level, pos);
        Holder<AgroClimaticZone> agroClimaticZoneHolder = CropGrowthHandler.getclimateTypeHolder(cropBiome);
        if (agroClimaticZoneHolder != null) {
            List<Pair<Season, Integer>> pairs = ((AgroClimaticZone)agroClimaticZoneHolder.m_203334_()).seasonalSignalDurations();
            return AnimalHooks.findCurrentSeason(pairs, nowSolarTerm.ordinal(), nowSolarTerm.getSeason());
        }
        return nowSolarTerm.getSeason();
    }

    public static boolean cancelBreed(Animal animal) {
        if (!((Boolean)CommonConfig.Animal.enableBreed.get()).booleanValue()) {
            return false;
        }
        Season season = AnimalHooks.getUseSeason(animal.m_9236_(), (Entity)animal);
        BreedSeasonType breedSeasonType = null;
        for (BreedSeasonType seasonType : BreedSeasonType.values()) {
            if (!animal.m_6095_().m_204039_(seasonType.getTag())) continue;
            breedSeasonType = seasonType;
            break;
        }
        if (breedSeasonType != null) {
            if (!breedSeasonType.getInfo().isSuitable(season)) {
                ArrayList<Season> seasons = new ArrayList<Season>();
                for (Season collectValidValue : Season.collectValidValues()) {
                    if (!breedSeasonType.getInfo().isSuitable(collectValidValue)) continue;
                    seasons.add(collectValidValue);
                }
                if (!((Boolean)CommonConfig.Animal.enableCoreWork.get()).booleanValue() || AnimalHooks.withoutSeasonBonus(animal.m_9236_(), animal.m_20183_(), seasons)) {
                    return true;
                }
            }
            boolean isDay = EclipticSeasonsApi.getInstance().isDay(animal.m_9236_());
            if (animal.m_6095_().m_204039_(AnimalBehaviorTag.DAY)) {
                return !isDay;
            }
            if (animal.m_6095_().m_204039_(AnimalBehaviorTag.NIGHT)) {
                return isDay;
            }
            if (animal.m_6095_().m_204039_(AnimalBehaviorTag.ALL_TIME)) {
                return false;
            }
            return !isDay;
        }
        return true;
    }

    public static boolean withoutSeasonBonus(Level level, BlockPos pos, List<Season> seasons) {
        if (!seasons.isEmpty()) {
            SolarDataManager saveData = SolarHolders.getSaveData(level);
            return saveData != null && saveData.findNearGreenHouseProvider(pos, seasons) == null;
        }
        return true;
    }

    public static boolean cancelBeePollinate(Bee bee) {
        Season season;
        if (!((Boolean)CommonConfig.Animal.enableBee.get()).booleanValue()) {
            return false;
        }
        List seasons = (List)CommonConfig.Animal.beePollinateSeasons.get();
        return !seasons.contains(season = AnimalHooks.getUseSeason(bee.m_9236_(), (Entity)bee)) && ((Boolean)CommonConfig.Animal.enableCoreWork.get() == false || AnimalHooks.withoutSeasonBonus(bee.m_9236_(), bee.m_20183_(), seasons));
    }

    public static boolean cancelBeeOut(Level level, BlockPos blockPos) {
        Season season;
        if (!((Boolean)CommonConfig.Animal.enableBee.get()).booleanValue()) {
            return false;
        }
        List seasons = (List)CommonConfig.Animal.beeActiveSeasons.get();
        if (!seasons.contains(season = AnimalHooks.getUseSeason(level, blockPos)) && EclipticSeasonsApi.getInstance().getPrecipitationAt(level, blockPos) == Biome.Precipitation.SNOW) {
            return (Boolean)CommonConfig.Animal.enableCoreWork.get() == false || AnimalHooks.withoutSeasonBonus(level, blockPos, seasons);
        }
        List seasons2 = (List)CommonConfig.Animal.beePollinateSeasons.get();
        return !seasons2.contains(season) && (level.m_213780_().m_188499_() || (Boolean)CommonConfig.Animal.enableCoreWork.get() == false || AnimalHooks.withoutSeasonBonus(level, blockPos, seasons2));
    }

    public static List<Component> getBreedInfo(LivingEntity entity) {
        return entity == null ? List.of() : AnimalHooks.getBreedInfo(entity.m_6095_());
    }

    public static List<Component> getBreedInfo(EntityType<?> entity) {
        if (!((Boolean)CommonConfig.Animal.enableBreed.get()).booleanValue()) {
            return List.of();
        }
        BreedSeasonType breedSeasonType = null;
        for (BreedSeasonType seasonType : BreedSeasonType.values()) {
            if (!entity.m_204039_(seasonType.getTag())) continue;
            breedSeasonType = seasonType;
            break;
        }
        if (breedSeasonType != null) {
            return breedSeasonType.getInfo().getTooltip();
        }
        return List.of();
    }
}

