/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.map;

import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.map.XZPos;
import com.teamtea.eclipticseasons.common.misc.MapColorReplacer;
import com.teamtea.eclipticseasons.common.network.SimpleNetworkHandler;
import com.teamtea.eclipticseasons.common.network.message.MapFixerMessage;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class ServerMapFixer {
    private static final Map<Level, Map<ChunkPos, List<XZPos>>> CHUNK_POS_XZ_POS_MAP = new IdentityHashMap<Level, Map<ChunkPos, List<XZPos>>>();
    public static long tickBlocksCount = 0L;
    public static long lastTick;
    private static final long MIN_TICK_CHECK_INTERVAL = 10L;
    private static final long MAX_TICK_BLOCK_RESET = 100000L;
    private static final long MAX_COUNT_PER_TICK = 1000000L;

    public static Map<ChunkPos, List<XZPos>> getMap(Level level) {
        return CHUNK_POS_XZ_POS_MAP.computeIfAbsent(level, level1 -> new HashMap());
    }

    public static void unloadLevel(Level level) {
        ServerMapFixer.getMap(level).clear();
        CHUNK_POS_XZ_POS_MAP.remove(level);
    }

    public static void unloadChunk(Level level, ChunkPos chunkPos) {
        ServerMapFixer.getMap(level).remove(chunkPos);
    }

    public static void unloadBlockPos(Level level, BlockPos blockPos) {
        List orDefault = ServerMapFixer.getMap(level).getOrDefault(new ChunkPos(blockPos), new ArrayList());
        for (int i = 0; i < orDefault.size(); ++i) {
            XZPos xzPos = (XZPos)orDefault.get(i);
            if (xzPos.x() != blockPos.m_123341_() || xzPos.z() != blockPos.m_123343_()) continue;
            orDefault.remove(i);
            --i;
        }
    }

    public static int agentGetLevelHeight(Level level, BlockPos pos) {
        ChunkInfoMap chunkMap = MapChecker.getChunkMap(level, pos);
        Integer old = null;
        if (chunkMap != null && (old = Integer.valueOf(chunkMap.getHeight(pos))) > level.m_151558_()) {
            return old;
        }
        return MapChecker.getMCHeightWithCheck(level, pos, old);
    }

    public static boolean solidTest(BlockState state) {
        return Heightmap.Types.MOTION_BLOCKING.m_64299_().test(state) && !MapChecker.extraSnowPassable(state);
    }

    public static void addLightPlanner(Level level, long packedPos, int brightness) {
        if (CommonConfig.isSnowyWinter() && ((Boolean)CommonConfig.Map.delayedUpdates.get()).booleanValue() && ((Boolean)CommonConfig.Season.notSnowyNearGlowingBlock.get()).booleanValue()) {
            boolean isTooLight;
            boolean bl = isTooLight = brightness >= (Integer)CommonConfig.Season.notSnowyNearGlowingBlockLevel.get();
            if (isTooLight) {
                boolean isOldHeight;
                boolean updateAndInformClientImmediately = false;
                int newy = level.m_141937_();
                boolean addToList = false;
                BlockPos pos = new BlockPos(BlockPos.m_121983_((long)packedPos), BlockPos.m_122008_((long)packedPos), BlockPos.m_122015_((long)packedPos));
                long startTick = level.m_46467_();
                pos = pos.m_7495_();
                BlockState state = level.m_8055_(pos);
                boolean bl2 = isOldHeight = pos.m_123342_() == ServerMapFixer.agentGetLevelHeight(level, pos);
                if (ServerMapFixer.solidTest(state) && isOldHeight && MapColorReplacer.getTopSnowColor((BlockGetter)level, state, pos, true) != null) {
                    newy = level.m_151558_() + 1;
                    updateAndInformClientImmediately = true;
                    addToList = true;
                }
                if (addToList) {
                    if (lastTick <= 0L) {
                        lastTick = level.m_46467_();
                    }
                    if (++tickBlocksCount > 100000L) {
                        long nowTick = level.m_46467_();
                        if (nowTick - lastTick < 10L) {
                            addToList = false;
                        } else {
                            lastTick = nowTick;
                            tickBlocksCount = 0L;
                        }
                    }
                    if (addToList) {
                        ChunkPos chunkPos = new ChunkPos(pos);
                        List xzPosList = ServerMapFixer.getMap(level).computeIfAbsent(chunkPos, k -> new ArrayList());
                        xzPosList.add(new XZPos(pos.m_123341_(), pos.m_123343_(), startTick, pos.m_123342_()));
                    }
                }
                if (updateAndInformClientImmediately && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    MapChecker.updatePosForce(level, pos, newy);
                    BlockPos nextPos = new BlockPos(pos.m_123341_(), newy, pos.m_123343_());
                    SimpleNetworkHandler.send(serverLevel.m_6907_(), new MapFixerMessage(List.of(nextPos), List.of(Integer.valueOf(pos.m_123342_()))));
                }
            }
        }
    }

    public static void addPlanner(Level level, BlockState state, BlockState oldState, BlockPos pos, long startTick, int startY, boolean broomUse) {
        if (!MapChecker.isValidDimension(level)) {
            return;
        }
        if (!((Boolean)CommonConfig.Map.delayedUpdates.get()).booleanValue()) {
            MapChecker.getHeightOrUpdate(level, pos, true);
            return;
        }
        boolean updateAndInformClientImmediately = false;
        int newy = level.m_141937_();
        boolean addToList = false;
        if (!broomUse) {
            boolean isNotOldHeight;
            int mcHeight = ServerMapFixer.agentGetLevelHeight(level, pos);
            boolean bl = isNotOldHeight = startY != mcHeight;
            if (isNotOldHeight && (ServerMapFixer.solidTest(state) || state.m_60734_() == Blocks.f_50016_) && EclipticUtil.isHereWithSnow(level, pos)) {
                addToList = true;
                newy = level.m_151558_() + 1;
                updateAndInformClientImmediately = true;
            } else if (isNotOldHeight) {
                MapChecker.updatePosForce(level, pos, mcHeight);
            }
        } else {
            newy = level.m_151558_() + 1;
            updateAndInformClientImmediately = true;
            addToList = true;
        }
        if (addToList) {
            if (lastTick <= 0L) {
                lastTick = level.m_46467_();
            }
            if (++tickBlocksCount > 100000L) {
                long nowTick = level.m_46467_();
                if (nowTick - lastTick < 10L) {
                    addToList = false;
                } else {
                    lastTick = nowTick;
                    tickBlocksCount = 0L;
                }
            }
            if (addToList) {
                ChunkPos chunkPos = new ChunkPos(pos);
                List xzPosList = ServerMapFixer.getMap(level).computeIfAbsent(chunkPos, k -> new ArrayList());
                xzPosList.add(new XZPos(pos.m_123341_(), pos.m_123343_(), startTick, startY));
            }
        }
        if (updateAndInformClientImmediately && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MapChecker.updatePosForce(level, pos, newy);
            BlockPos nextPos = new BlockPos(pos.m_123341_(), newy, pos.m_123343_());
            SimpleNetworkHandler.send(serverLevel.m_6907_(), new MapFixerMessage(List.of(nextPos), List.of(Integer.valueOf(startY))));
        }
    }

    public static void tick(Level level) {
        if (!MapChecker.isValidDimension(level)) {
            return;
        }
        Map<ChunkPos, List<XZPos>> chunkPosListMap = ServerMapFixer.getMap(level);
        long tick = level.m_46467_();
        ArrayList removeNeedChunkPosList = new ArrayList();
        HashSet updateSectionsList = new HashSet();
        ArrayList<BlockPos> updatePosList = new ArrayList<BlockPos>();
        ArrayList<Integer> oldYs = new ArrayList<Integer>();
        AtomicLong countPerTick = new AtomicLong();
        chunkPosListMap.forEach((chunkPos, xzPosList) -> {
            for (int i = 0; i < xzPosList.size() && countPerTick.get() < 1000000L; ++i) {
                countPerTick.getAndIncrement();
                XZPos xzPos = (XZPos)xzPosList.get(i);
                if (tick - xzPos.startTick() <= 160L || updateSectionsList.size() >= 12) break;
                BlockPos.MutableBlockPos updatePos = new BlockPos.MutableBlockPos(xzPos.x(), xzPos.startY(), xzPos.z());
                if (!EclipticUtil.isHereSnowy(level, (BlockPos)updatePos) && EclipticUtil.isHereWithSnow(level, (BlockPos)updatePos)) {
                    xzPos = new XZPos(xzPos.x(), xzPos.z(), tick - 50L, xzPos.startY());
                    xzPosList.set(i, xzPos);
                    continue;
                }
                xzPosList.remove(0);
                --i;
                int newY = MapChecker.getHeightOrUpdate(level, (BlockPos)updatePos, true);
                updatePos.m_142448_(newY);
                updateSectionsList.add(SectionPos.m_123199_((BlockPos)updatePos));
                updatePosList.add((BlockPos)updatePos);
                oldYs.add(xzPos.startY());
            }
            if (xzPosList.isEmpty()) {
                removeNeedChunkPosList.add(chunkPos);
            }
        });
        for (ChunkPos chunkPos2 : removeNeedChunkPosList) {
            chunkPosListMap.remove(chunkPos2);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!updatePosList.isEmpty()) {
                ServerMapFixer.sendToAll(serverLevel, updatePosList, oldYs);
            }
        }
    }

    public static void sendToAll(ServerLevel serverLevel, List<BlockPos> blockPos, List<Integer> startY) {
        SimpleNetworkHandler.send(serverLevel.m_6907_(), new MapFixerMessage(blockPos, startY));
    }
}

