/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.crop;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.season.definition.ChangeMode;
import com.teamtea.eclipticseasons.api.data.season.definition.ISeasonChangeContext;
import com.teamtea.eclipticseasons.api.data.season.definition.SeasonDefinition;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.IChangeSelector;
import com.teamtea.eclipticseasons.api.misc.BiomeHolderPredicate;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import com.teamtea.eclipticseasons.config.CommonConfig;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class NaturalPlantHandler {
    public static final Map<Block, EnumMap<SolarTerm, List<Pair<BiomeHolderPredicate, ChangeMode>>>> SEASON_DEFINITIONS = new IdentityHashMap<Block, EnumMap<SolarTerm, List<Pair<BiomeHolderPredicate, ChangeMode>>>>();
    private static final ThreadLocal<ISeasonChangeContext> SEASON_CHANGE_CONTEXT_THREAD_LOCAL = ThreadLocal.withInitial(ISeasonChangeContext::of);

    public static void resetUpdate(RegistryAccess registryAccess, boolean isServer) {
        if (isServer) {
            SEASON_DEFINITIONS.clear();
            Optional registry = registryAccess.m_6632_(ESRegistries.SEASON_DEFINITION);
            if (registry.isEmpty()) {
                SimpleUtil.warningForModWrongCalling(ESRegistries.SEASON_DEFINITION);
            } else {
                for (SeasonDefinition seasonDefinition : (Registry)registry.get()) {
                    EnumMap<SolarTerm, List<ChangeMode>> combine = seasonDefinition.changes().combine();
                    combine.forEach((solarTerm, changeModes) -> {
                        for (ChangeMode changeMode : changeModes) {
                            for (Block possibleBlock : changeMode.getPossibleBlocks()) {
                                EnumMap blockMap = SEASON_DEFINITIONS.computeIfAbsent(possibleBlock, b -> new EnumMap(SolarTerm.class));
                                List pairList = blockMap.computeIfAbsent(solarTerm, b -> new ArrayList());
                                if (seasonDefinition.biomes().isPresent()) {
                                    pairList.add(Pair.of((Object)BiomeHolderPredicate.of(seasonDefinition.biomes().get()), (Object)changeMode));
                                    continue;
                                }
                                pairList.add(Pair.of((Object)BiomeHolderPredicate.of(), (Object)changeMode));
                            }
                        }
                    });
                }
            }
        }
    }

    public static void clearOnClientExitOrServerClose() {
        SEASON_DEFINITIONS.clear();
    }

    public static boolean shouldTick(BlockState state) {
        EnumMap map = SEASON_DEFINITIONS.getOrDefault(state.m_60734_(), null);
        if (map == null || map.isEmpty()) {
            return false;
        }
        for (List value : map.values()) {
            for (Pair pair : value) {
                if (!((ChangeMode)pair.getSecond()).matchesState(state)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean testChance(long seed, float chance) {
        long mixed = HashCommon.mix((long)seed);
        double rand = (double)(mixed & 0x1FFFFFFFFFFFFFL) / 9.007199254740992E15;
        return rand < (double)chance;
    }

    public static void tickBlock(ServerLevel level, BlockPos pos, BlockState state) {
        EnumMap mapMap;
        SolarTerm nowSolarTerm;
        if (CommonConfig.isSeasonDefinition() && (nowSolarTerm = EclipticUtil.getNowSolarTerm((Level)level)).isValid() && (mapMap = (EnumMap)SEASON_DEFINITIONS.getOrDefault(state.m_60734_(), null)) != null) {
            List pairs = mapMap.getOrDefault(nowSolarTerm, null);
            if (pairs == null) {
                return;
            }
            Holder<Biome> cropBiome = null;
            long fixedSeedValue = -1L;
            boolean hasCheckFixedSeed = false;
            int pairsSize = pairs.size();
            for (int i = 0; i < pairsSize; ++i) {
                Pair pair = (Pair)pairs.get(i);
                ChangeMode changeMode = (ChangeMode)pair.getSecond();
                if (changeMode.fixedSeed()) {
                    if (!hasCheckFixedSeed) {
                        fixedSeedValue = level.m_7328_();
                        fixedSeedValue ^= HashCommon.mix((long)state.m_60726_(pos));
                        fixedSeedValue ^= (long)HashCommon.mix((int)EclipticSeasonsApi.getInstance().getSolarDays((Level)level));
                        fixedSeedValue ^= (long)HashCommon.mix((int)EclipticSeasonsApi.getInstance().getTimeInTerm((Level)level));
                        fixedSeedValue ^= (long)HashCommon.mix((int)EclipticSeasonsApi.getInstance().getLastingDaysOfEachTerm((Level)level));
                        hasCheckFixedSeed = true;
                    }
                    if (!NaturalPlantHandler.testChance(fixedSeedValue, changeMode.chance())) {
                        continue;
                    }
                } else if (level.m_213780_().m_188501_() >= changeMode.chance()) continue;
                if (!changeMode.matches(state, (Level)level, pos)) continue;
                cropBiome = cropBiome == null ? CropGrowthHandler.getCropBiome((LevelAccessor)level, pos) : cropBiome;
                int totalWeight = 0;
                List<IChangeSelector> selectors = changeMode.selectors();
                ISeasonChangeContext context = SEASON_CHANGE_CONTEXT_THREAD_LOCAL.get();
                int selectorsSize = selectors.size();
                for (int j = 0; j < selectorsSize; ++j) {
                    IChangeSelector blockStatePlaced = selectors.get(j);
                    if (!blockStatePlaced.shouldApply((Level)level, pos, context)) continue;
                    totalWeight += blockStatePlaced.getWeight();
                }
                if (totalWeight <= 0) {
                    return;
                }
                int weightIndex = changeMode.fixedSeed() ? Math.floorMod(fixedSeedValue, totalWeight) : level.m_213780_().m_188503_(totalWeight);
                IChangeSelector chosen = null;
                List<IChangeSelector> selectorsed = changeMode.selectors();
                int selectorsedSize = selectorsed.size();
                for (int j = 0; j < selectorsedSize; ++j) {
                    IChangeSelector blockStatePlaced = selectorsed.get(j);
                    if (!blockStatePlaced.shouldApply((Level)level, pos, context) || (weightIndex -= blockStatePlaced.getWeight()) > 0) continue;
                    chosen = blockStatePlaced;
                    break;
                }
                if (chosen == null) continue;
                boolean applied = chosen.place(level, pos, context);
                if (applied && chosen.getLoot().isPresent() && chosen.dropWhenApplied((Level)level, pos, context)) {
                    NaturalPlantHandler.dropLootTable(level, pos, chosen.getLoot().get(), changeMode.fixedSeed() ? fixedSeedValue : level.m_213780_().m_188505_(), state);
                }
                return;
            }
        }
    }

    public static boolean setBlockAndSelfCheck(ServerLevel level, BlockPos pos, BlockState chosen) {
        return NaturalPlantHandler.setBlockAndSelfCheck(level, pos, chosen, level.m_8055_(pos));
    }

    public static boolean setBlockAndSelfCheck(ServerLevel level, BlockPos pos, BlockState chosen, BlockState old) {
        boolean set;
        if (old != chosen && (set = level.m_7731_(pos, chosen, 2))) {
            SoundType soundType = chosen.getSoundType((LevelReader)level, pos, null);
            if (soundType != null) {
                level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public static void dropLootTable(ServerLevel level, BlockPos pos, ResourceLocation resourcekey, long seed, BlockState state) {
        if (resourcekey != null && level != null) {
            LootTable loottable = level.m_7654_().m_278653_().m_278676_(resourcekey);
            LootParams.Builder lootparams$builder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81461_, (Object)state).m_287289_(LootContextParams.f_81462_, (Object)level.m_7702_(pos));
            for (ItemStack randomItem : loottable.m_287214_(lootparams$builder.m_287235_(LootContextParamSets.f_81421_), seed)) {
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)randomItem);
            }
        }
    }
}

