/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.core.crop;

import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityInfo;
import com.teamtea.eclipticseasons.api.constant.crop.CropHumidityType;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonInfo;
import com.teamtea.eclipticseasons.api.constant.crop.CropSeasonType;
import com.teamtea.eclipticseasons.api.event.RegisterAndModifyCropInfoEvent;
import com.teamtea.eclipticseasons.compat.CompatModule;
import com.teamtea.eclipticseasons.config.CommonConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.Event;

public final class CropInfoManager {
    static final Map<Block, CropHumidityInfo> CROP_HUMIDITY_INFO = new HashMap<Block, CropHumidityInfo>();
    static final Map<Block, CropSeasonInfo> CROP_SEASON_INFO = new HashMap<Block, CropSeasonInfo>();
    static final Map<Item, CropHumidityInfo> ITEM_CROP_HUMIDITY_INFO = new HashMap<Item, CropHumidityInfo>();
    static final Map<Item, CropSeasonInfo> ITEM_CROP_SEASON_INFO = new HashMap<Item, CropSeasonInfo>();
    private static final TagKey<Block> ss1 = CropInfoManager.createBlockTag("sereneseasons", "spring_crops");
    private static final TagKey<Block> ss2 = CropInfoManager.createBlockTag("sereneseasons", "summer_crops");
    private static final TagKey<Block> ss3 = CropInfoManager.createBlockTag("sereneseasons", "autumn_crops");
    private static final TagKey<Block> ss4 = CropInfoManager.createBlockTag("sereneseasons", "winter_crops");
    private static final TagKey<Block> SERENE_SEASONS_UNBREAKABLE_FERTILE_CROPS = CropInfoManager.createBlockTag("sereneseasons", "unbreakable_infertile_crops");
    private static final TagKey<Block> SERENE_SEASONS_YEAR_ROUND_CROPS = CropInfoManager.createBlockTag("sereneseasons", "year_round_crops");
    private static final TagKey<Item> ITEM_SERENE_SEASONS_YEAR_ROUND_CROPS = CropInfoManager.createItemTag("sereneseasons", "year_round_crops");
    private static final TagKey<Item> ssi1 = CropInfoManager.createItemTag("sereneseasons", "spring_crops");
    private static final TagKey<Item> ssi2 = CropInfoManager.createItemTag("sereneseasons", "summer_crops");
    private static final TagKey<Item> ssi3 = CropInfoManager.createItemTag("sereneseasons", "autumn_crops");
    private static final TagKey<Item> ssi4 = CropInfoManager.createItemTag("sereneseasons", "winter_crops");
    private static final List<Integer> seasonInfoList = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(4), Integer.valueOf(8));
    private static final List<TagKey<Block>> ss_blockList = List.of(ss1, ss2, ss3, ss4);
    private static final List<TagKey<Item>> ss_itemList = List.of(ssi1, ssi2, ssi3, ssi4);

    private static TagKey<Item> createItemTag(String modId, String path) {
        return ItemTags.create((ResourceLocation)new ResourceLocation(modId, path));
    }

    private static TagKey<Block> createBlockTag(String modId, String path) {
        return BlockTags.create((ResourceLocation)new ResourceLocation(modId, path));
    }

    static CropSeasonType getCropSeasonTypeFrom(CropSeasonInfo cropSeasonInfo) {
        for (CropSeasonType value : CropSeasonType.collectValues()) {
            if (!value.getInfo().equals(cropSeasonInfo)) continue;
            return value;
        }
        return null;
    }

    static CropHumidityType getCropHumidityTypeFrom(CropHumidityInfo cropSeasonInfo) {
        for (CropHumidityType value : CropHumidityType.collectValues()) {
            if (!value.getInfo().equals(cropSeasonInfo)) continue;
            return value;
        }
        return null;
    }

    public static void init(TagsUpdatedEvent event) {
        CROP_HUMIDITY_INFO.clear();
        CROP_SEASON_INFO.clear();
        Optional items = event.getRegistryAccess().m_6632_(Registries.f_256913_);
        Optional blocks = event.getRegistryAccess().m_6632_(Registries.f_256747_);
        if (blocks.isPresent()) {
            Optional tagBlocks;
            for (CropHumidityType cropHumidityType : CropHumidityType.collectValues()) {
                tagBlocks = ((Registry)blocks.get()).m_203431_(cropHumidityType.getBlockTag());
                tagBlocks.ifPresent(holders -> holders.m_203614_().forEach(action -> CropInfoManager.registerCropHumidityInfo((Block)action.m_203334_(), cropHumidityType, true)));
            }
            for (Enum enum_ : CropSeasonType.collectValues()) {
                tagBlocks = ((Registry)blocks.get()).m_203431_(((CropSeasonType)enum_).getBlockTag());
                tagBlocks.ifPresent(arg_0 -> CropInfoManager.lambda$init$3((CropSeasonType)enum_, arg_0));
            }
        }
        if (items.isPresent()) {
            Optional tagItems;
            for (Enum enum_ : CropHumidityType.collectValues()) {
                tagItems = ((Registry)items.get()).m_203431_(((CropHumidityType)enum_).getTag());
                tagItems.ifPresent(arg_0 -> CropInfoManager.lambda$init$5((CropHumidityType)enum_, arg_0));
            }
            for (Enum enum_ : CropSeasonType.collectValues()) {
                tagItems = ((Registry)items.get()).m_203431_(((CropSeasonType)enum_).getTag());
                tagItems.ifPresent(arg_0 -> CropInfoManager.lambda$init$7((CropSeasonType)enum_, arg_0));
            }
        }
        if (((Boolean)CompatModule.CommonConfig.sereneSeasons.get()).booleanValue()) {
            CropInfoManager.registerForSS(blocks, Registries.f_256747_);
            CropInfoManager.registerForSS(items, Registries.f_256913_);
            blocks.flatMap(br -> br.m_203431_(SERENE_SEASONS_YEAR_ROUND_CROPS)).ifPresent(nblocks -> {
                for (Holder nblock : nblocks) {
                    CropInfoManager.registerCropSeasonInfo((Block)nblock.m_203334_(), CropSeasonType.ALL, true);
                    if (!((Boolean)CommonConfig.Crop.registerCropDefaultValue.get()).booleanValue()) continue;
                    CropInfoManager.registerCropHumidityInfo((Block)nblock.m_203334_(), CropHumidityType.AVERAGE_MOIST, true);
                }
            });
            items.flatMap(br -> br.m_203431_(ITEM_SERENE_SEASONS_YEAR_ROUND_CROPS)).ifPresent(itemNamed -> {
                for (Holder itemHolder : itemNamed) {
                    CropInfoManager.registerCropSeasonInfo((Item)itemHolder.m_203334_(), CropSeasonType.ALL);
                    if (!((Boolean)CommonConfig.Crop.registerCropDefaultValue.get()).booleanValue()) continue;
                    CropInfoManager.registerCropHumidityInfo((Item)itemHolder.m_203334_(), CropHumidityType.AVERAGE_MOIST);
                }
            });
        }
        MinecraftForge.EVENT_BUS.post((Event)new RegisterAndModifyCropInfoEvent(CROP_HUMIDITY_INFO, CROP_SEASON_INFO));
        if (((Boolean)CommonConfig.Crop.registerCropDefaultValue.get()).booleanValue()) {
            BuiltInRegistries.f_256975_.forEach(block -> {
                if (block instanceof CropBlock) {
                    CropInfoManager.registerCropHumidityInfo(block, CropHumidityType.AVERAGE_MOIST, true);
                    CropInfoManager.registerCropSeasonInfo(block, CropSeasonType.SP_SU_AU, true);
                }
            });
        }
    }

    public static <T> void registerForSS(Optional<Registry<T>> blocks, ResourceKey<Registry<T>> registryResourceKey) {
        blocks.ifPresent(blocks1 -> {
            ArrayList nameBlockList = new ArrayList();
            List<TagKey<Block>> useTag = registryResourceKey.equals((Object)Registries.f_256747_) ? ss_blockList : ss_itemList;
            for (TagKey<Block> blockTagKey : useTag) {
                Optional tag = Optional.empty();
                tag = blocks1.m_203431_(blockTagKey);
                tag.ifPresent(holders -> nameBlockList.add(holders.m_203614_().map(Holder::m_203334_).toList()));
            }
            ArrayList nameBlockSet = new ArrayList(new HashSet(nameBlockList.stream().flatMap(Collection::stream).toList()));
            for (Object t : nameBlockSet) {
                int season = 0;
                for (int i = 0; i < nameBlockList.size(); ++i) {
                    if (!((List)nameBlockList.get(i)).contains(t)) continue;
                    season += seasonInfoList.get(i).intValue();
                }
                if (t instanceof Block) {
                    Block block = (Block)t;
                    CropInfoManager.registerCropSeasonInfo(block, CropInfoManager.getCropSeasonTypeFrom(new CropSeasonInfo(season)), true);
                } else if (t instanceof Item) {
                    Item item = (Item)t;
                    CropInfoManager.registerCropSeasonInfo(item, CropInfoManager.getCropSeasonTypeFrom(new CropSeasonInfo(season)));
                }
                if (!((Boolean)CommonConfig.Crop.registerCropDefaultValue.get()).booleanValue()) continue;
                CropHumidityType humid = season == 1 ? CropHumidityType.AVERAGE_HUMID : (season == 5 ? CropHumidityType.AVERAGE_MOIST : CropHumidityType.DRY_MOIST);
                if (t instanceof Block) {
                    Block block = (Block)t;
                    CropInfoManager.registerCropHumidityInfo(block, humid, true);
                    continue;
                }
                if (!(t instanceof Item)) continue;
                Item item = (Item)t;
                CropInfoManager.registerCropHumidityInfo(item, humid);
            }
        });
    }

    public static void registerCropHumidityInfo(Item item, CropHumidityType info) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            CropInfoManager.registerCropHumidityInfo(blockItem.m_40614_(), info, false);
        }
        if (!ITEM_CROP_HUMIDITY_INFO.containsKey(item)) {
            ITEM_CROP_HUMIDITY_INFO.put(item, info.getInfo());
        }
    }

    public static void registerCropHumidityInfo(Block block, CropHumidityType info, boolean force) {
        if (!CROP_HUMIDITY_INFO.containsKey(block)) {
            CROP_HUMIDITY_INFO.put(block, info.getInfo());
        }
    }

    public static void registerCropSeasonInfo(Item item, CropSeasonType info) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            CropInfoManager.registerCropSeasonInfo(blockItem.m_40614_(), info, false);
        }
        if (!ITEM_CROP_SEASON_INFO.containsKey(item)) {
            ITEM_CROP_SEASON_INFO.put(item, info.getInfo());
        }
    }

    public static void registerCropSeasonInfo(Block block, CropSeasonType info, boolean force) {
        if (!CROP_SEASON_INFO.containsKey(block)) {
            CROP_SEASON_INFO.put(block, info.getInfo());
        }
    }

    public static Collection<Block> getHumidityCrops() {
        return CROP_HUMIDITY_INFO.keySet();
    }

    public static Collection<Block> getSeasonCrops() {
        return CROP_SEASON_INFO.keySet();
    }

    @Nullable
    public static CropHumidityInfo getHumidityInfo(Block crop) {
        return CROP_HUMIDITY_INFO.get(crop);
    }

    @Nullable
    public static CropSeasonInfo getSeasonInfo(Block crop) {
        return CROP_SEASON_INFO.get(crop);
    }

    @Nullable
    public static CropHumidityInfo getHumidityInfo(Item crop) {
        return ITEM_CROP_HUMIDITY_INFO.get(crop);
    }

    @Nullable
    public static CropSeasonInfo getSeasonInfo(Item crop) {
        return ITEM_CROP_SEASON_INFO.get(crop);
    }

    public static List<Component> appendInfo(Block block) {
        Object info;
        ArrayList<Component> toolTip = new ArrayList<Component>();
        if (((Boolean)CommonConfig.Crop.enableCropHumidityControl.get()).booleanValue() && CropInfoManager.getHumidityCrops().contains(block) && (info = CropInfoManager.getHumidityInfo(block)) != null) {
            toolTip.addAll(((CropHumidityInfo)info).getTooltip());
        }
        if (((Boolean)CommonConfig.Crop.enableCrop.get()).booleanValue() && CropInfoManager.getSeasonCrops().contains(block) && (info = CropInfoManager.getSeasonInfo(block)) != null) {
            toolTip.addAll(((CropSeasonInfo)info).getTooltip());
        }
        return toolTip;
    }

    public static List<Component> appendInfo(Item item) {
        Object info;
        ArrayList<Component> toolTip = new ArrayList<Component>();
        if (((Boolean)CommonConfig.Crop.enableCropHumidityControl.get()).booleanValue() && ITEM_CROP_HUMIDITY_INFO.containsKey(item) && (info = CropInfoManager.getHumidityInfo(item)) != null) {
            toolTip.addAll(((CropHumidityInfo)info).getTooltip());
        }
        if (((Boolean)CommonConfig.Crop.enableCrop.get()).booleanValue() && ITEM_CROP_SEASON_INFO.containsKey(item) && (info = CropInfoManager.getSeasonInfo(item)) != null) {
            toolTip.addAll(((CropSeasonInfo)info).getTooltip());
        }
        return toolTip;
    }

    private static /* synthetic */ void lambda$init$7(CropSeasonType cropSeasonType, HolderSet.Named holders) {
        holders.m_203614_().forEach(action -> CropInfoManager.registerCropSeasonInfo((Item)action.m_203334_(), cropSeasonType));
    }

    private static /* synthetic */ void lambda$init$5(CropHumidityType cropHumidityType, HolderSet.Named holders) {
        holders.m_203614_().forEach(action -> CropInfoManager.registerCropHumidityInfo((Item)action.m_203334_(), cropHumidityType));
    }

    private static /* synthetic */ void lambda$init$3(CropSeasonType cropSeasonType, HolderSet.Named holders) {
        holders.m_203614_().forEach(action -> CropInfoManager.registerCropSeasonInfo((Block)action.m_203334_(), cropSeasonType, true));
    }
}

