/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block.blockentity;

import com.mojang.serialization.DynamicOps;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.quest.SeasonQuest;
import com.teamtea.eclipticseasons.api.data.quest.WarpItemPredicate;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.api.util.SimpleUtil;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class QuestHangingSignBlockEntity
extends SignBlockEntity {
    public static final ModelProperty<SignBlock> SIGN_BLOCK_MODEL_PROPERTY = new ModelProperty();
    private SignBlock sign;
    private SeasonQuest seasonQuest;
    private int sleepTime = 0;

    public QuestHangingSignBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.season_quest_hanging_sign_entity_type.get(), pos, blockState);
    }

    public static void popSign(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof QuestHangingSignBlockEntity) {
            QuestHangingSignBlockEntity blockEntity2 = (QuestHangingSignBlockEntity)blockEntity;
            if (blockEntity2.sign != null) {
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)blockEntity2.getSignType().m_5456_().m_7968_());
            }
        }
    }

    public static void removeSign(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof QuestHangingSignBlockEntity) {
            QuestHangingSignBlockEntity blockEntity2 = (QuestHangingSignBlockEntity)blockEntity;
            blockEntity2.setSignType(null);
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        RegistryOps registryops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)this.f_58857_.m_9598_());
        tag.m_128359_("sign_type", BuiltInRegistries.f_256975_.m_7981_((Object)this.getSignType()).toString());
        if (this.seasonQuest != null) {
            SeasonQuest.CODEC.encodeStart((DynamicOps)registryops, (Object)this.seasonQuest).resultOrPartial(EclipticSeasons::logger).ifPresent(tag1 -> tag.m_128365_("season_quest", tag1));
        }
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        Block block;
        super.m_142466_(tag);
        if (tag.m_128441_("sign_type") && (block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(tag.m_128461_("sign_type")))) instanceof SignBlock) {
            SignBlock signBlock;
            this.sign = signBlock = (SignBlock)block;
        }
        if (tag.m_128441_("season_quest")) {
            RegistryAccess registryAccess = SimpleUtil.getRegistryAccess((BlockEntity)this);
            RegistryOps registryops = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)registryAccess);
            SeasonQuest.CODEC.parse((DynamicOps)registryops, (Object)tag.m_128423_("season_quest")).resultOrPartial(EclipticSeasons::logger).ifPresent(seasonQuest1 -> {
                this.seasonQuest = seasonQuest1;
            });
        } else {
            this.seasonQuest = null;
        }
    }

    protected void inventoryChanged() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void setSignType(SignBlock signType) {
        this.sign = signType;
        this.inventoryChanged();
    }

    public SignBlock getSignType() {
        return this.sign != null ? this.sign : (SignBlock)Blocks.f_244093_;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, QuestHangingSignBlockEntity sign) {
        if (!level.m_5776_()) {
            if (sign.getSeasonQuest() == null) {
                if (sign.sleepTime == 0) {
                    sign.createSeasonalQuest();
                    if (sign.getSeasonQuest() != null) {
                        sign.setQuestText();
                    } else {
                        sign.sleepTime = 100;
                    }
                } else {
                    --sign.sleepTime;
                }
                sign.m_6596_();
            } else if (level.m_213780_().m_188503_(128) == 0) {
                SolarTerm nowSolarTerm = EclipticUtil.getNowSolarTerm(level);
                Holder<AgroClimaticZone> agroClimaticZoneHolder = CropGrowthHandler.getclimateTypeHolder(CropGrowthHandler.getCropBiome((LevelAccessor)level, pos));
                if (QuestHangingSignBlockEntity.isInvalidQuest(sign.getSeasonQuest(), nowSolarTerm, agroClimaticZoneHolder)) {
                    sign.resetQuest();
                }
            }
        }
    }

    private void setQuestText() {
        SeasonQuest signSeasonQuest = this.getSeasonQuest();
        if (signSeasonQuest != null) {
            SignText signText = new SignText();
            String title = signSeasonQuest.tittle().orElse("block.eclipticseasons.season_quest_ceiling_hanging_sign");
            signText = signText.m_276913_(0, (Component)Component.m_237115_((String)title));
            if (signSeasonQuest.description().isPresent()) {
                for (int i = 0; i < signSeasonQuest.description().get().size() && i < 3; ++i) {
                    signText = signText.m_276913_(i + 1, (Component)Component.m_237115_((String)signSeasonQuest.description().get().get(i)));
                }
            } else if (!signSeasonQuest.need().isEmpty()) {
                for (int i = 0; i < signSeasonQuest.need().size() && i < 3; ++i) {
                    WarpItemPredicate itemPredicate = signSeasonQuest.need().get(i);
                    HolderSet<Item> holders = itemPredicate.items();
                    if (holders.m_203632_() <= 0) continue;
                    Item value = (Item)holders.m_203662_(0).m_203334_();
                    MutableComponent c = Component.m_237110_((String)"eclipticseasons.season_quest.hint.item_count", (Object[])new Object[]{value.m_7626_(value.m_7968_()), itemPredicate.count()});
                    signText = signText.m_276913_(i + 1, (Component)c);
                }
            }
            this.m_276956_(signText, true);
        }
    }

    public void createSeasonalQuest() {
        this.f_58857_.m_9598_().m_6632_(ESRegistries.SEASON_QUEST).ifPresent(seasonQuests -> {
            SolarTerm nowSolarTerm = EclipticUtil.getNowSolarTerm(this.f_58857_);
            Holder<AgroClimaticZone> agroClimaticZoneHolder = CropGrowthHandler.getclimateTypeHolder(CropGrowthHandler.getCropBiome((LevelAccessor)this.f_58857_, this.m_58899_()));
            ArrayList<SeasonQuest> seasonQuestList = new ArrayList<SeasonQuest>();
            int totalWeight = 0;
            for (Map.Entry entry : seasonQuests.m_6579_()) {
                SeasonQuest quest = (SeasonQuest)entry.getValue();
                if (QuestHangingSignBlockEntity.isInvalidQuest(quest, nowSolarTerm, agroClimaticZoneHolder)) continue;
                seasonQuestList.add(quest);
                totalWeight += quest.weight().orElse(10).intValue();
            }
            if (totalWeight < 1) {
                return;
            }
            int randWeight = this.f_58857_.m_213780_().m_188503_(totalWeight);
            int currentWeight = 0;
            for (SeasonQuest quest : seasonQuestList) {
                if (randWeight >= (currentWeight += quest.weight().orElse(1).intValue())) continue;
                this.seasonQuest = quest;
            }
        });
        if (this.seasonQuest == null) {
            this.showLoadingText();
        }
    }

    private static boolean isInvalidQuest(SeasonQuest quest, SolarTerm nowSolarTerm, Holder<AgroClimaticZone> agroClimaticZoneHolder) {
        if (quest.start().isPresent() != quest.end().isPresent()) {
            return true;
        }
        if (quest.start().isPresent() && !nowSolarTerm.isInTerms(quest.start().get(), quest.end().get())) {
            return true;
        }
        return agroClimaticZoneHolder == null || quest.climate().isPresent() && !quest.climate().get().m_203333_(agroClimaticZoneHolder);
    }

    public SeasonQuest getSeasonQuest() {
        return this.seasonQuest;
    }

    public void finishSeasonQuest(ServerPlayer player) {
        SeasonQuest quest = this.getSeasonQuest();
        if (quest != null) {
            boolean isOk = true;
            for (WarpItemPredicate itemPredicate : quest.need()) {
                int i = player.m_150109_().m_36022_(itemPredicate::test, 0, (Container)player.f_36095_.m_39730_());
                if (i >= itemPredicate.count()) continue;
                isOk = false;
                break;
            }
            if (isOk) {
                for (WarpItemPredicate itemPredicate : quest.need()) {
                    player.m_150109_().m_36022_(itemPredicate::test, itemPredicate.count(), (Container)player.f_36095_.m_39730_());
                }
                for (ItemStack stack : quest.award()) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.m_41777_());
                }
                this.resetQuest();
            }
        }
    }

    private void resetQuest() {
        this.seasonQuest = null;
        this.sleepTime = 100;
        this.inventoryChanged();
        this.showLoadingText();
    }

    private void showLoadingText() {
        this.m_276956_(new SignText().m_276913_(1, (Component)Component.m_237115_((String)"eclipticseasons.season_quest.hint.loading")), true);
    }

    public int m_245123_() {
        return 400;
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with(SIGN_BLOCK_MODEL_PROPERTY, (Object)this.getSignType()).build();
    }
}

