/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.common.block;

import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.data.craft.HumidityControl;
import com.teamtea.eclipticseasons.common.block.base.SimpleEntityBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.BlockInCopperGrateBlockEntity;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockInGrateBlock
extends SimpleEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public BlockInGrateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public static Pair<BlockItem, HumidityControl> getItemMatch(Level level, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            for (HumidityControl humidityControl : level.m_9598_().m_175515_(ESRegistries.HUMIDITY_CONTROL)) {
                if (!humidityControl.ingredient().test(stack)) continue;
                return Pair.of((Object)blockItem, (Object)humidityControl);
            }
        }
        return null;
    }

    @Nullable
    public static InteractionResult getItemInteractionResult(ItemStack stack, Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        Pair<BlockItem, HumidityControl> itemMatch = BlockInGrateBlock.getItemMatch(level, stack);
        if (itemMatch != null) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof BlockInCopperGrateBlockEntity) {
                BlockInCopperGrateBlockEntity blockEntity2 = (BlockInCopperGrateBlockEntity)blockEntity;
                blockEntity2.setInnerBlock(((BlockItem)itemMatch.getFirst()).m_40614_());
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (stack.m_41619_()) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof BlockInCopperGrateBlockEntity) {
                BlockInCopperGrateBlockEntity blockEntity3 = (BlockInCopperGrateBlockEntity)blockEntity;
                blockEntity3.setInnerBlock(null);
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return null;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResult interactionResult = BlockInGrateBlock.getItemInteractionResult(stack, level, pos);
        if (!level.m_5776_() && interactionResult == InteractionResult.m_19078_((boolean)level.m_5776_()) && !player.m_7500_()) {
            stack.m_41774_(1);
        }
        if (interactionResult != null) {
            return interactionResult;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.block_in_copper_grate_block_entity_type.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level worldIn, @NotNull BlockState state, @NotNull BlockEntityType<T> blockEntityType) {
        return !worldIn.f_46443_ ? SimpleEntityBlock.m_152132_(blockEntityType, (BlockEntityType)BlockEntityRegistry.block_in_copper_grate_block_entity_type.get(), BlockInCopperGrateBlockEntity::tick) : null;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (!level.m_5776_() && player.m_7500_()) {
            BlockInCopperGrateBlockEntity.removeBlock(level, pos);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!(movedByPiston || level.m_5776_() || newState.m_60713_((Block)this))) {
            BlockInCopperGrateBlockEntity.popResource(level, pos);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public VoxelShape m_5909_(BlockState pState, BlockGetter pReader, BlockPos pPos, CollisionContext pContext) {
        return Shapes.m_83040_();
    }

    public float m_7749_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext p_313836_) {
        FluidState fluidstate = p_313836_.m_43725_().m_6425_(p_313836_.m_8083_());
        return (BlockState)super.m_5573_(p_313836_).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_192917_((Fluid)Fluids.f_76193_)));
    }

    public BlockState m_7417_(BlockState p_313906_, Direction p_313739_, BlockState p_313829_, LevelAccessor p_313692_, BlockPos p_313842_, BlockPos p_313843_) {
        if (((Boolean)p_313906_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_313692_.m_186469_(p_313842_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_313692_));
        }
        return super.m_7417_(p_313906_, p_313739_, p_313829_, p_313692_, p_313842_, p_313843_);
    }

    public FluidState m_5888_(BlockState p_313789_) {
        return (Boolean)p_313789_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(true) : super.m_5888_(p_313789_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_313896_) {
        p_313896_.m_61104_(new Property[]{WATERLOGGED});
    }
}

