/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.util;

import java.util.ArrayList;
import java.util.HashMap;

public final class ColorHelper {
    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static float getRedF(int color) {
        return (float)ColorHelper.getRed(color) / 255.0f;
    }

    public static float getGreenF(int color) {
        return (float)ColorHelper.getGreen(color) / 255.0f;
    }

    public static float getBlueF(int color) {
        return (float)ColorHelper.getBlue(color) / 255.0f;
    }

    public static float getAlphaF(int color) {
        return (float)ColorHelper.getAlpha(color) / 255.0f;
    }

    public static int simplyMixColor(int color1, float alpha1, int color2, float alpha2) {
        int red = (int)((float)ColorHelper.getRed(color1) * alpha1 + (float)ColorHelper.getRed(color2) * alpha2);
        int green = (int)((float)ColorHelper.getGreen(color1) * alpha1 + (float)ColorHelper.getGreen(color2) * alpha2);
        int blue = (int)((float)ColorHelper.getBlue(color1) * alpha1 + (float)ColorHelper.getBlue(color2) * alpha2);
        int alpha = (int)((float)ColorHelper.getAlpha(color1) * alpha1 + (float)ColorHelper.getAlpha(color2) * alpha2);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static float getAvg(ArrayList<Integer> list) {
        int[] nArray;
        boolean sum = false;
        float interval = 51.0f;
        HashMap<Integer, Integer> colorMap = new HashMap<Integer, Integer>();
        colorMap.put(10, 0);
        colorMap.put(51, 0);
        colorMap.put(102, 0);
        colorMap.put(153, 0);
        colorMap.put(204, 0);
        colorMap.put(240, 0);
        block8: for (int i = 0; i < list.size(); ++i) {
            float tmp = (float)list.get(i).intValue() / interval;
            int stage = Math.round(tmp);
            switch (stage) {
                case 0: {
                    colorMap.replace(10, (Integer)colorMap.get(10) + 1);
                    continue block8;
                }
                case 1: {
                    colorMap.replace(51, (Integer)colorMap.get(51) + 1);
                    continue block8;
                }
                case 2: {
                    colorMap.replace(102, (Integer)colorMap.get(102) + 1);
                    continue block8;
                }
                case 3: {
                    colorMap.replace(153, (Integer)colorMap.get(153) + 1);
                    continue block8;
                }
                case 4: {
                    colorMap.replace(204, (Integer)colorMap.get(204) + 1);
                    continue block8;
                }
                case 5: {
                    colorMap.replace(240, (Integer)colorMap.get(240) + 1);
                }
            }
        }
        int[] maxColor = new int[]{10};
        colorMap.forEach((key, value) -> {
            if ((Integer)colorMap.get(maxColor[0]) < value) {
                maxColor[0] = key;
            }
        });
        float maxAmount = ((Integer)colorMap.get(maxColor[0])).intValue();
        colorMap.remove(maxColor[0]);
        if (maxColor[0] != 10) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 10;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 51;
        }
        int[] secondColor = nArray;
        colorMap.forEach((key, value) -> {
            if ((Integer)colorMap.get(secondColor[0]) < value) {
                secondColor[0] = key;
            }
        });
        float secondAmount = ((Integer)colorMap.get(secondColor[0])).intValue();
        float r = secondAmount / maxAmount;
        if ((double)r > 0.7) {
            return (float)maxColor[0] * 0.6f + (float)secondColor[0] * 0.4f;
        }
        return maxColor[0];
    }

    public static int frostify(int pixel, float hueShift, float satReduce, float lightAdd) {
        int a = ColorHelper.getAlpha(pixel);
        float[] hsl = ColorHelper.rgbToHSL(ColorHelper.getRed(pixel), ColorHelper.getGreen(pixel), ColorHelper.getBlue(pixel));
        hsl[0] = (hsl[0] + hueShift) % 360.0f;
        hsl[1] = ColorHelper.clamp01(hsl[1] - satReduce);
        hsl[2] = ColorHelper.clamp01(hsl[2] + lightAdd);
        int[] rgb = ColorHelper.hslToRGB(hsl[0], hsl[1], hsl[2]);
        return a << 24 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    private static float[] rgbToHSL(int r, int g, int b) {
        float h;
        float s;
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = l > 0.5f ? d / (2.0f - max - min) : d / (max + min);
            h = max == rf ? ((gf - bf) / d + (gf < bf ? 6.0f : 0.0f)) * 60.0f : (max == gf ? ((bf - rf) / d + 2.0f) * 60.0f : ((rf - gf) / d + 4.0f) * 60.0f);
        }
        return new float[]{h, s, l};
    }

    private static int[] hslToRGB(float h, float s, float l) {
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs(h / 60.0f % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        float r1 = 0.0f;
        float g1 = 0.0f;
        float b1 = 0.0f;
        if (h < 60.0f) {
            r1 = c;
            g1 = x;
        } else if (h < 120.0f) {
            r1 = x;
            g1 = c;
        } else if (h < 180.0f) {
            g1 = c;
            b1 = x;
        } else if (h < 240.0f) {
            g1 = x;
            b1 = c;
        } else if (h < 300.0f) {
            r1 = x;
            b1 = c;
        } else {
            r1 = c;
            g1 = 0.0f;
            b1 = x;
        }
        int r = ColorHelper.clamp((int)((r1 + m) * 255.0f));
        int g = ColorHelper.clamp((int)((g1 + m) * 255.0f));
        int b = ColorHelper.clamp((int)((b1 + m) * 255.0f));
        return new int[]{r, g, b};
    }

    private static float clamp01(float v) {
        return Math.max(0.0f, Math.min(1.0f, v));
    }

    private static int clamp(int v) {
        return Math.max(0, Math.min(255, v));
    }
}

