/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.render.ber;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.quest.SeasonQuest;
import com.teamtea.eclipticseasons.common.block.blockentity.QuestHangingSignBlockEntity;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;

public class QuestSignRenderer
extends HangingSignRenderer {
    private final Map<WoodType, HangingSignRenderer.HangingSignModel> hangingSignModels = (Map)WoodType.m_61843_().collect(ImmutableMap.toImmutableMap(p_249901_ -> p_249901_, p_251956_ -> new HangingSignRenderer.HangingSignModel(context.m_173582_(ModelLayers.m_247439_((WoodType)p_251956_)))));
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, (double)-0.32f, (double)0.073f);
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final Font font;
    private final Material materail;

    public QuestSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.font = context.m_173586_();
        this.materail = QuestSignRenderer.createHangingSignMaterial(EclipticSeasons.rl("frame"));
    }

    public void m_6922_(SignBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity instanceof QuestHangingSignBlockEntity) {
            QuestHangingSignBlockEntity questHangingSignBlockEntity = (QuestHangingSignBlockEntity)blockEntity;
            BlockState blockstate = blockEntity.m_58900_();
            SignBlock signblock = (SignBlock)blockstate.m_60734_();
            WoodType woodtype = questHangingSignBlockEntity.getSignType().m_56297_();
            HangingSignRenderer.HangingSignModel hangingsignrenderer$hangingsignmodel = this.hangingSignModels.get(woodtype);
            hangingsignrenderer$hangingsignmodel.m_246561_(blockstate);
            this.renderSignWithText(questHangingSignBlockEntity, poseStack, bufferSource, packedLight, packedOverlay, blockstate, signblock, woodtype, (Model)hangingsignrenderer$hangingsignmodel);
        }
    }

    void renderSignWithText(QuestHangingSignBlockEntity signEntity, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, BlockState state, SignBlock signBlock, WoodType woodType, Model model) {
        poseStack.m_85836_();
        this.m_276777_(poseStack, -signBlock.m_276903_(state), state);
        this.m_278784_(poseStack, buffer, packedLight, packedOverlay, woodType, model);
        this.renderSignText(signEntity.m_58899_(), signEntity.m_277142_(), poseStack, buffer, packedLight, signEntity.m_245065_(), signEntity.m_245123_(), true, signEntity.getSeasonQuest());
        this.renderSignDecoration(poseStack, buffer, packedLight, packedOverlay, woodType, model);
        poseStack.m_85849_();
    }

    void m_276777_(PoseStack poseStack, float yRot, BlockState state) {
        poseStack.m_85837_(0.5, 0.9375, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
        poseStack.m_252880_(0.0f, -0.3125f, 0.0f);
    }

    void m_278784_(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, WoodType woodType, Model model) {
        poseStack.m_85836_();
        float f = this.m_278770_();
        poseStack.m_85841_(f, -f, -f);
        Material material = this.m_245629_(woodType);
        VertexConsumer vertexconsumer = material.m_119194_(buffer, arg_0 -> ((Model)model).m_103119_(arg_0));
        this.m_245885_(poseStack, packedLight, packedOverlay, model, vertexconsumer);
        poseStack.m_85849_();
    }

    void renderSignDecoration(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, WoodType woodType, Model model) {
        poseStack.m_85836_();
        float f = this.m_278770_();
        poseStack.m_85841_(f, -f, -f);
        VertexConsumer vertexconsumer = this.materail.m_119194_(buffer, arg_0 -> ((Model)model).m_103119_(arg_0));
        this.m_245885_(poseStack, LightTexture.m_109885_((int)8, (int)15), packedOverlay, model, vertexconsumer);
        poseStack.m_85849_();
    }

    void m_245885_(PoseStack poseStack, int packedLight, int packedOverlay, Model model, VertexConsumer vertexConsumer) {
        HangingSignRenderer.HangingSignModel hangingsignrenderer$hangingsignmodel = (HangingSignRenderer.HangingSignModel)model;
        hangingsignrenderer$hangingsignmodel.f_244554_.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    Material m_245629_(WoodType woodType) {
        return Sheets.m_246984_((WoodType)woodType);
    }

    Vec3 m_278725_() {
        return TEXT_OFFSET;
    }

    void renderSignText(BlockPos pos, SignText text, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int lineHeight, int maxWidth, boolean isFrontText, SeasonQuest seasonQuest) {
        int l;
        boolean flag;
        int k;
        poseStack.m_85836_();
        this.m_278823_(poseStack, isFrontText, this.m_278725_());
        boolean b = text.m_276843_();
        b = seasonQuest != null && seasonQuest.glowing().isPresent();
        int textColor = text.m_276773_().m_41071_();
        textColor = seasonQuest != null && seasonQuest.color().isPresent() ? seasonQuest.color().get().intValue() : Color.WHITE.getRGB();
        int i = QuestSignRenderer.getDarkColor(textColor, b);
        int j = 4 * lineHeight / 2;
        FormattedCharSequence[] aformattedcharsequence = text.m_277130_(Minecraft.m_91087_().m_167974_(), p_277227_ -> {
            List list = this.font.m_92923_((FormattedText)p_277227_, maxWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (b) {
            k = Color.WHITE.getRGB();
            flag = QuestSignRenderer.m_277119_(pos, k);
            l = 0xF000F0;
        } else {
            k = i;
            flag = false;
            l = packedLight;
        }
        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f = -this.font.m_92724_(formattedcharsequence) / 2;
            poseStack.m_85836_();
            float abs = Mth.m_14154_((float)f);
            if (abs > 32.0f) {
                poseStack.m_85841_(32.0f / abs * 0.97f, 1.0f, 1.0f);
            }
            if (flag) {
                this.font.m_168645_(formattedcharsequence, f, (float)(i1 * lineHeight - j), k, i, poseStack.m_85850_().m_252922_(), buffer, l);
            } else {
                this.font.m_272191_(formattedcharsequence, f, (float)(i1 * lineHeight - j), k, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, l);
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void m_278823_(PoseStack poseStack, boolean isFrontText, Vec3 offset) {
        if (!isFrontText) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        float f = 0.015625f * this.m_278631_();
        poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        poseStack.m_85841_(f, -f, f);
    }

    static boolean m_277119_(BlockPos pos, int textColor) {
        if (textColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    private static Material createHangingSignMaterial(ResourceLocation resourceLocation) {
        return new Material(Sheets.f_110739_, new ResourceLocation(resourceLocation.m_135827_(), "entity/signs/hanging/" + resourceLocation.m_135815_()));
    }

    public static int getDarkColor(int i, boolean hasGlowingText) {
        if (i == DyeColor.BLACK.m_41071_()) {
            return -988212;
        }
        double d0 = 0.4;
        int j = (int)((double)FastColor.ARGB32.m_13665_((int)i) * 0.4);
        int k = (int)((double)FastColor.ARGB32.m_13667_((int)i) * 0.4);
        int l = (int)((double)FastColor.ARGB32.m_13669_((int)i) * 0.4);
        return FastColor.ARGB32.m_13660_((int)0, (int)j, (int)k, (int)l);
    }
}

