/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.render.ber;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.EclipticSeasonsApi;
import com.teamtea.eclipticseasons.api.constant.solar.ISolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.client.render.ber.XYZ;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.block.CalendarBlock;
import com.teamtea.eclipticseasons.common.block.base.SimpleHorizontalEntityBlock;
import com.teamtea.eclipticseasons.common.block.blockentity.CalendarBlockEntity;
import com.teamtea.eclipticseasons.common.core.crop.CropGrowthHandler;
import com.teamtea.eclipticseasons.common.core.solar.SolarTermHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Vector3d;

public class CalendarBlockEntityRenderer
implements BlockEntityRenderer<CalendarBlockEntity> {
    private final Font font;

    public CalendarBlockEntityRenderer(BlockEntityRendererProvider.Context pContext) {
        this.font = pContext.m_173586_();
    }

    public void render(CalendarBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlay) {
        if (!blockEntity.isInit()) {
            Holder<Biome> cropBiome = CropGrowthHandler.getCropBiome((LevelAccessor)blockEntity.m_58904_(), blockEntity.m_58899_());
            blockEntity.setBiome(cropBiome);
            blockEntity.setInit(true);
        }
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)SimpleHorizontalEntityBlock.FACING);
        CalendarBlock.DisplayMode displayMode = (CalendarBlock.DisplayMode)((Object)blockEntity.m_58900_().m_61143_(CalendarBlock.MODE));
        SolarTerm st = ClientCon.nowSolarTerm;
        ISolarTerm iSolarTermOriginal = SolarTermHelper.get(blockEntity.getBiome(), st);
        ISolarTerm seasonPhaseUsed = displayMode == CalendarBlock.DisplayMode.NEXT ? SolarTermHelper.getNext(blockEntity.getBiome(), st) : iSolarTermOriginal;
        this.setEnv(facing, blockEntity.m_58899_(), poseStack, bufferIn, combinedLight, (matrixStackIn, multiBufferSource, combinedLightIn) -> {
            matrixStackIn.m_252880_(0.0f, -0.0f, 0.0f);
            this.drawIcon(seasonPhaseUsed.getIcon(), seasonPhaseUsed.getIconWidth(), seasonPhaseUsed.getIconHeight(), seasonPhaseUsed.getIconAtlasSize(), seasonPhaseUsed.getIconPosition().getKey(), seasonPhaseUsed.getIconPosition().getValue(), (PoseStack)matrixStackIn, (MultiBufferSource)multiBufferSource, (int)combinedLightIn);
            this.drawText(1, seasonPhaseUsed.getPatternTranslation().getString(), Optional.ofNullable(seasonPhaseUsed.getColor().m_126665_()).orElse(-1), (PoseStack)matrixStackIn, (MultiBufferSource)multiBufferSource);
            if (st != SolarTerm.NONE) {
                String string = "";
                switch (displayMode) {
                    case YEAR: {
                        string = Component.m_237110_((String)"info.eclipticseasons.environment.solar_term.hint2", (Object[])new Object[]{ClientCon.nowSolarYear}).getString();
                        break;
                    }
                    case NEXT: {
                        Pair<SolarTerm, ISolarTerm> nextPair = SolarTermHelper.getNextTermAndStart(blockEntity.getBiome(), st);
                        int lastingDaysOfEachTerm = EclipticSeasonsApi.getInstance().getLastingDaysOfEachTerm(blockEntity.m_58904_());
                        int remain = Mth.m_14143_((float)((1.0f - (float)ClientCon.progress / 100.0f) * (float)lastingDaysOfEachTerm));
                        remain = iSolarTermOriginal == nextPair.getSecond() ? 0 : (remain += lastingDaysOfEachTerm * ((((SolarTerm)nextPair.getFirst()).ordinal() < st.ordinal() ? 24 : 0) + ((SolarTerm)nextPair.getFirst()).ordinal() - st.getNextSolarTerm().ordinal()));
                        string = Component.m_237110_((String)"info.eclipticseasons.environment.solar_term.hint3", (Object[])new Object[]{remain}).getString();
                        break;
                    }
                    default: {
                        string = seasonPhaseUsed.getTittleTranslation().getString();
                    }
                }
                this.drawText(2, string, Color.GRAY.getRGB(), (PoseStack)matrixStackIn, (MultiBufferSource)multiBufferSource);
            }
        });
    }

    private void setEnv(Direction d, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource txtBuffer, int combinedLightIn, TBiConsumer<PoseStack, MultiBufferSource, Integer> runnable) {
        matrixStackIn.m_85836_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        this.handleMatrixAngle(matrixStackIn, player, pos, d);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        matrixStackIn.m_252880_(0.0f, -0.0625f, 0.0f);
        matrixStackIn.m_252880_(x, y, z + 0.74f);
        runnable.accept(matrixStackIn, txtBuffer, combinedLightIn);
        matrixStackIn.m_85849_();
    }

    private void drawIcon(ResourceLocation fullIcon, int twidth, int theight, float isize, int x, int y, PoseStack matrixStackIn, MultiBufferSource txtBuffer, int combinedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(0.2f, 0.2f, 0.2f);
        int size = 16;
        ResourceLocation location = fullIcon.m_246208_("textures/").m_266382_(".png");
        VertexConsumer builder = txtBuffer.m_6299_(RenderType.m_110476_((ResourceLocation)location));
        CalendarBlockEntityRenderer.blitRect(matrixStackIn, builder, combinedLightIn, OverlayTexture.f_118083_, (float)size / 2.0f, (float)(-size) * 0.6f, size * x, size * y, size, size, (int)((float)twidth / (isize / (float)size)), (int)((float)theight / (isize / (float)size)), true);
        matrixStackIn.m_85849_();
    }

    private void drawText(int line, String label, int color, PoseStack matrixStackIn, MultiBufferSource txtBuffer) {
        Font font = this.font;
        int lineWidth = 80;
        float scale = 0.007f;
        float x = 0.0f;
        float y = -0.3125f / scale;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85841_(scale, scale, scale);
        List lines = font.m_92923_(FormattedText.m_130775_((String)label), lineWidth);
        Objects.requireNonNull(font);
        int lineHeight = 9;
        float startY = (y += (float)(lineHeight * (2 - line + 1))) + 0.0f;
        ArrayList list = new ArrayList(lines);
        Collections.reverse(list);
        for (FormattedCharSequence charSequence : list) {
            int textWidth = font.m_92724_(charSequence);
            float drawX = x - (float)textWidth / 2.0f;
            font.m_272191_(charSequence, drawX, startY, color, false, matrixStackIn.m_85850_().m_252922_(), txtBuffer, Font.DisplayMode.NORMAL, 0, 0xF00000);
            startY -= (float)lineHeight;
        }
        matrixStackIn.m_85849_();
        if (!lines.isEmpty()) {
            matrixStackIn.m_85837_(0.0, -(((double)lines.size() - 0.75) * (double)lineHeight) * (double)scale, 0.0);
        }
    }

    private void handleMatrixAngle(PoseStack matrixStackIn, LocalPlayer player, BlockPos pos, Direction d) {
        Vector3d vector3d = new Vector3d(player.m_20318_(1.0f).m_7096_() - (double)pos.m_123341_() - 0.5, player.m_20318_(0.0f).m_7098_() - (double)pos.m_123342_(), player.m_20318_(0.0f).m_7094_() - (double)pos.m_123343_() - 0.5);
        if (d == Direction.DOWN || d == Direction.UP) {
            if (vector3d.x > 0.0 && Math.abs(vector3d.x) > Math.abs(vector3d.z)) {
                d = Direction.EAST;
            }
            if (vector3d.x < 0.0 && Math.abs(vector3d.x) > Math.abs(vector3d.z)) {
                d = Direction.WEST;
            }
            if (vector3d.x > 0.0 && Math.abs(vector3d.x) < Math.abs(vector3d.z)) {
                d = Direction.SOUTH;
            }
            if (vector3d.x < 0.0 && Math.abs(vector3d.x) < Math.abs(vector3d.z)) {
                d = Direction.NORTH;
            }
        }
        switch (d) {
            case SOUTH: {
                matrixStackIn.m_85837_(0.5, 0.15, 1.0);
                matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 180, 180));
                break;
            }
            case NORTH: {
                matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 0, 180));
                matrixStackIn.m_85837_(-0.5, -0.15, 0.0);
                break;
            }
            case EAST: {
                matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 270, 180));
                matrixStackIn.m_85837_(-0.5, -0.15, -1.0);
                break;
            }
            case WEST: {
                matrixStackIn.m_252781_(XYZ.deg_to_rad(0, 90, 180));
                matrixStackIn.m_85837_(0.5, -0.15, 0.0);
                break;
            }
            default: {
                matrixStackIn.m_85841_(0.01f, 0.01f, 0.01f);
            }
        }
    }

    protected static void blitRect(PoseStack matrixStack, VertexConsumer builder, int packedLight, int overlay, float x0, float y0, float xt, float yt, float width, float height, int tWidth, int tHeight, boolean mirrored) {
        float pixelScale = 0.0625f;
        x0 *= pixelScale;
        y0 *= pixelScale;
        float tx0 = (xt *= pixelScale) / ((float)tWidth * pixelScale);
        float ty0 = (yt *= pixelScale) / ((float)tHeight * pixelScale);
        float tx1 = tx0 + (width *= pixelScale) / ((float)tWidth * pixelScale);
        float ty1 = ty0 + (height *= pixelScale) / ((float)tHeight * pixelScale);
        float x1 = x0 - width;
        float y1 = y0 + height;
        if (mirrored) {
            x0 = -x0;
            x1 = -x1;
        }
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        PoseStack.Pose normal = matrixStack.m_85850_();
        builder.m_252986_(matrix, x0, y1, 0.0f).m_193479_(Color.WHITE.getRGB()).m_7421_(tx0, ty1).m_86008_(overlay).m_85969_(packedLight).m_252939_(normal.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, x1, y1, 0.0f).m_193479_(Color.WHITE.getRGB()).m_7421_(tx1, ty1).m_86008_(overlay).m_85969_(packedLight).m_252939_(normal.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, x1, y0, 0.0f).m_193479_(Color.WHITE.getRGB()).m_7421_(tx1, ty0).m_86008_(overlay).m_85969_(packedLight).m_252939_(normal.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_252986_(matrix, x0, y0, 0.0f).m_193479_(Color.WHITE.getRGB()).m_7421_(tx0, ty0).m_86008_(overlay).m_85969_(packedLight).m_252939_(normal.m_252943_(), 0.0f, 0.0f, 1.0f).m_5752_();
    }

    @FunctionalInterface
    private static interface TBiConsumer<T, U, R> {
        public void accept(T var1, U var2, R var3);
    }
}

