/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.unbake;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.client.model.seasonal.SeasonalTexture;
import com.teamtea.eclipticseasons.api.misc.BiomeHolderPredicate;
import com.teamtea.eclipticseasons.client.model.SeasonBiomeGoingModel;
import com.teamtea.eclipticseasons.client.model.SeasonGoingModel;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarBlockModel
extends BlockModel {
    protected List<SeasonalTexture> seasonalTexture = null;

    public SolarBlockModel(@Nullable ResourceLocation parentLocation, List<BlockElement> elements, Map<String, Either<Material, String>> textureMap, @Nullable Boolean hasAmbientOcclusion, @Nullable BlockModel.GuiLight guiLight, ItemTransforms transforms, List<ItemOverride> overrides) {
        super(parentLocation, elements, textureMap, hasAmbientOcclusion, guiLight, transforms, overrides);
    }

    public static SolarBlockModel of(BlockModel blockModel) {
        SolarBlockModel solarBlockModel = new SolarBlockModel(blockModel.getParentLocation(), blockModel.m_111436_(), blockModel.f_111417_, blockModel.m_111476_(), blockModel.m_111479_(), blockModel.m_111491_(), blockModel.m_111484_());
        solarBlockModel.customData.copyFrom(blockModel.customData);
        return solarBlockModel;
    }

    public BlockModel to(Map<String, ResourceLocation> stringStringMap, Map<String, Integer> integerMap) {
        HashMap map = new HashMap(this.f_111417_);
        if (this.f_111418_ != null) {
            map.putAll(this.f_111418_.f_111417_);
        }
        stringStringMap.forEach((string, location) -> {
            if (map.containsKey(string)) {
                map.put(string, Either.left((Object)new Material(InventoryMenu.f_39692_, location)));
            }
        });
        ArrayList<BlockElement> elements = this.m_111436_();
        if (!integerMap.isEmpty()) {
            elements = new ArrayList<BlockElement>(elements);
            int elementsSize = elements.size();
            for (int i = 0; i < elementsSize; ++i) {
                BlockElement element = (BlockElement)elements.get(i);
                EnumMap elementFace = new EnumMap(Direction.class);
                element.f_111310_.forEach((direction, face) -> {
                    Integer orDefault = integerMap.getOrDefault(face.f_111356_, null);
                    if (orDefault != null && face.f_111355_ != orDefault) {
                        elementFace.put((Direction)direction, new BlockElementFace(face.f_111354_, orDefault.intValue(), face.f_111356_, face.f_111357_, face.getFaceData()));
                    } else {
                        elementFace.put((Direction)direction, face);
                    }
                });
                BlockElement blockElement = new BlockElement(element.f_111308_, element.f_111309_, elementFace, element.f_111311_, element.f_111312_, element.getFaceData());
                elements.set(i, blockElement);
            }
        }
        return new BlockModel(this.getParentLocation(), elements, map, Boolean.valueOf(this.m_111476_()), this.m_111479_(), this.m_111491_(), this.m_111484_());
    }

    public List<BlockModel> toList(List<Map<String, ResourceLocation>> stringStringMap, Map<String, Integer> stringIntegerMap) {
        return stringStringMap.stream().map(m -> this.to((Map<String, ResourceLocation>)m, stringIntegerMap)).toList();
    }

    public List<Pair<BlockModel, BlockModel>> toPairList(List<Pair<Map<String, ResourceLocation>, Map<String, ResourceLocation>>> stringStringMap, Map<String, Integer> stringIntegerMap) {
        return stringStringMap.stream().map(p -> Pair.of((Object)this.to((Map)p.getFirst(), stringIntegerMap), (Object)this.to((Map)p.getSecond(), stringIntegerMap))).toList();
    }

    public SolarBlockModel setSeasonalTexture(List<SeasonalTexture> seasonalTexture) {
        this.seasonalTexture = seasonalTexture;
        return this;
    }

    @NotNull
    public BakedModel m_111449_(ModelBaker baker, BlockModel model, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state, ResourceLocation pLocation, boolean guiLight3d) {
        if (this.seasonalTexture != null) {
            BakedModel bake = UnbakedGeometryHelper.bake((BlockModel)this, (ModelBaker)baker, (BlockModel)model, spriteGetter, (ModelState)state, (ResourceLocation)pLocation, (boolean)guiLight3d);
            SeasonGoingModel<BakedModel> end = null;
            ArrayList list = new ArrayList();
            ArrayList<Pair> defaultList = new ArrayList<Pair>();
            Object2ObjectOpenCustomHashMap bakedCache = new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<BlockModel>(){

                public int hashCode(BlockModel blockModel) {
                    return Objects.hash(blockModel.m_111436_(), blockModel.f_111417_);
                }

                public boolean equals(BlockModel a, BlockModel b) {
                    if (a == b) {
                        return true;
                    }
                    if (b == null || a.getClass() != b.getClass()) {
                        return false;
                    }
                    return a.m_111436_().equals(b.m_111436_()) && a.f_111417_.equals(b.f_111417_);
                }
            });
            for (SeasonalTexture texture : this.seasonalTexture) {
                EnumMap solarTermBakedModelEnumMap = new EnumMap(SolarTerm.class);
                EnumMap snowSolarTermBakedModelEnumMap = new EnumMap(SolarTerm.class);
                texture.getFlatSliceEnumMap().forEach((arg_0, arg_1) -> this.lambda$bake$14(solarTermBakedModelEnumMap, (Map)bakedCache, baker, model, spriteGetter, state, pLocation, guiLight3d, snowSolarTermBakedModelEnumMap, arg_0, arg_1));
                end = new SeasonGoingModel<BakedModel>(bake, solarTermBakedModelEnumMap, snowSolarTermBakedModelEnumMap);
                if (texture.getBiomes().isEmpty()) {
                    defaultList.add(Pair.of(b -> true, end));
                    continue;
                }
                BiomeHolderPredicate biomePredicate = biomeHolder -> {
                    Optional biomeResourceKey;
                    Optional<Either<List<ResourceLocation>, TagKey<Biome>>> biomes = texture.getBiomes();
                    if (biomes.isEmpty()) {
                        return true;
                    }
                    Either<List<ResourceLocation>, TagKey<Biome>> either = biomes.get();
                    if (either.left().isPresent() && (biomeResourceKey = biomeHolder.m_203543_()).isPresent()) {
                        return ((List)either.left().get()).contains(((ResourceKey)biomeResourceKey.get()).m_135782_());
                    }
                    if (either.right().isPresent()) {
                        return biomeHolder.m_203656_((TagKey)either.right().get());
                    }
                    return true;
                };
                list.add(Pair.of((Object)biomePredicate, end));
            }
            if (end != null) {
                if (list.size() == 1 && ((Pair)list.get(0)).getFirst() == null) {
                    return end;
                }
                if (!defaultList.isEmpty()) {
                    list.add((Pair)defaultList.get(defaultList.size() - 1));
                }
                return new SeasonBiomeGoingModel<BakedModel>(bake, list);
            }
        }
        return super.m_111449_(baker, model, spriteGetter, state, pLocation, guiLight3d);
    }

    private /* synthetic */ void lambda$bake$14(EnumMap solarTermBakedModelEnumMap, Map bakedCache, ModelBaker baker, BlockModel model, Function spriteGetter, ModelState state, ResourceLocation pLocation, boolean guiLight3d, EnumMap snowSolarTermBakedModelEnumMap, SolarTerm solarTerm, SeasonalTexture.FlatSliceHolder flatSliceHolders) {
        if (flatSliceHolders.flatSlice().mid() != null) {
            solarTermBakedModelEnumMap.put(solarTerm, this.toList(flatSliceHolders.flatSlice().mid(), flatSliceHolders.flatSlice().tintMap()).stream().map(b -> {
                BakedModel sliceModel = bakedCache.computeIfAbsent(b, blockModel -> UnbakedGeometryHelper.bake((BlockModel)b, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (ResourceLocation)pLocation, (boolean)guiLight3d));
                return Pair.of((Object)sliceModel, (Object)sliceModel);
            }).toList());
        }
        if (flatSliceHolders.flatSlice().transitionModels() != null) {
            snowSolarTermBakedModelEnumMap.put(solarTerm, this.toPairList(flatSliceHolders.flatSlice().transitionModels(), flatSliceHolders.flatSlice().tintMap()).stream().map(b -> Pair.of((Object)bakedCache.computeIfAbsent((BlockModel)b.getFirst(), blockModel -> UnbakedGeometryHelper.bake((BlockModel)blockModel, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (ResourceLocation)pLocation, (boolean)guiLight3d)), (Object)bakedCache.computeIfAbsent((BlockModel)b.getSecond(), blockModel -> UnbakedGeometryHelper.bake((BlockModel)blockModel, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (ResourceLocation)pLocation, (boolean)guiLight3d)))).toList());
        }
        if (flatSliceHolders.snowSlice().mid() != null) {
            snowSolarTermBakedModelEnumMap.put(solarTerm, this.toList(flatSliceHolders.snowSlice().mid(), flatSliceHolders.snowSlice().tintMap()).stream().map(b -> {
                BakedModel sliceModel = bakedCache.computeIfAbsent(b, blockModel -> UnbakedGeometryHelper.bake((BlockModel)b, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (ResourceLocation)pLocation, (boolean)guiLight3d));
                return Pair.of((Object)sliceModel, (Object)sliceModel);
            }).toList());
        }
        if (flatSliceHolders.snowSlice().transitionModels() != null) {
            snowSolarTermBakedModelEnumMap.put(solarTerm, this.toPairList(flatSliceHolders.snowSlice().transitionModels(), flatSliceHolders.snowSlice().tintMap()).stream().map(b -> Pair.of((Object)bakedCache.computeIfAbsent((BlockModel)b.getFirst(), blockModel -> UnbakedGeometryHelper.bake((BlockModel)blockModel, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (ResourceLocation)pLocation, (boolean)guiLight3d)), (Object)bakedCache.computeIfAbsent((BlockModel)b.getSecond(), blockModel -> UnbakedGeometryHelper.bake((BlockModel)blockModel, (ModelBaker)baker, (BlockModel)model, (Function)spriteGetter, (ModelState)state, (ResourceLocation)pLocation, (boolean)guiLight3d)))).toList());
        }
    }
}

