/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model.bakequad;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;

public class QuadFixer {
    public static int posIndex = 0;
    public static int vertice_Space = DefaultVertexFormat.f_85811_.m_86020_() / 4;

    public static List<Object> getBakeQuadInfo(BakedQuad bakedQuad) {
        ArrayList<Object> stringLike = new ArrayList<Object>();
        stringLike.add(bakedQuad.m_173410_().m_245424_().m_246162_());
        stringLike.add(",");
        stringLike.add(bakedQuad.m_111306_());
        stringLike.add(",");
        stringLike.addAll(List.of(Float.valueOf(QuadFixer.getMinX(bakedQuad)), ",", Float.valueOf(QuadFixer.getMinY(bakedQuad)), ",", Float.valueOf(QuadFixer.getMinZ(bakedQuad)), ",", Float.valueOf(QuadFixer.getMaxX(bakedQuad)), ",", Float.valueOf(QuadFixer.getMaxY(bakedQuad)), ",", Float.valueOf(QuadFixer.getMaxZ(bakedQuad))));
        return stringLike;
    }

    public static float getMinValue(int[] vertices, int index) {
        float minV = 1.0f;
        for (int i = 0; i < 4; ++i) {
            int j = vertice_Space * i;
            float v = Float.intBitsToFloat(vertices[j + posIndex + index]);
            if (!(v < minV)) continue;
            minV = v;
        }
        float epsilon = 1.0E-7f;
        return Math.abs(minV) < epsilon ? 0.0f : minV;
    }

    public static float getMaxValue(int[] vertices, int index) {
        float maxV = -1.0f;
        for (int i = 0; i < 4; ++i) {
            int j = vertice_Space * i;
            float v = Float.intBitsToFloat(vertices[j + posIndex + index]);
            if (!(v > maxV)) continue;
            maxV = v;
        }
        return maxV;
    }

    public static float getMaxX(BakedQuad bakedQuad) {
        return QuadFixer.getMaxValue(bakedQuad.m_111303_(), 0);
    }

    public static float getMaxY(BakedQuad bakedQuad) {
        return QuadFixer.getMaxValue(bakedQuad.m_111303_(), 1);
    }

    public static float getMaxZ(BakedQuad bakedQuad) {
        return QuadFixer.getMaxValue(bakedQuad.m_111303_(), 2);
    }

    public static float getMinX(BakedQuad bakedQuad) {
        return QuadFixer.getMinValue(bakedQuad.m_111303_(), 0);
    }

    public static float getMinY(BakedQuad bakedQuad) {
        return QuadFixer.getMinValue(bakedQuad.m_111303_(), 1);
    }

    public static float getMinZ(BakedQuad bakedQuad) {
        return QuadFixer.getMinValue(bakedQuad.m_111303_(), 2);
    }

    public static boolean cover(BakedQuad bakedQuad, BakedQuad testQuad) {
        boolean result;
        float x0 = QuadFixer.getMinX(bakedQuad);
        float x1 = QuadFixer.getMaxX(bakedQuad);
        float x2 = QuadFixer.getMinX(testQuad);
        float x3 = QuadFixer.getMaxX(testQuad);
        float y0 = QuadFixer.getMinY(bakedQuad);
        float y1 = QuadFixer.getMaxY(bakedQuad);
        float y2 = QuadFixer.getMinY(testQuad);
        float y3 = QuadFixer.getMaxY(testQuad);
        float z0 = QuadFixer.getMinZ(bakedQuad);
        float z1 = QuadFixer.getMaxZ(bakedQuad);
        float z2 = QuadFixer.getMinZ(testQuad);
        float z3 = QuadFixer.getMaxZ(testQuad);
        boolean bl = result = (x0 == x1 ? 1 : 0) + (y0 == y1 ? 1 : 0) + (z0 == z1 ? 1 : 0) >= 2;
        if (result) {
            return false;
        }
        if (bakedQuad.m_111306_() == Direction.UP) {
            if (y0 > y3 && x1 >= x3 && x0 <= x2 && z1 >= z3 && z0 <= z2) {
                return true;
            }
        } else if (bakedQuad.m_111306_() == testQuad.m_111306_() && (x0 == x1 && x2 == x3 && x0 == x2 ? z0 <= z2 && z1 >= z3 : z0 == z1 && z2 == z3 && z0 == z2 && x0 <= x2 && x1 >= x3)) {
            return y1 > y3;
        }
        return false;
    }

    public static ArrayList<BakedQuad> fixQuadCTM(ArrayList<BakedQuad> quadsCTM) {
        quadsCTM.removeIf(bakedQuad -> bakedQuad.m_111306_() == Direction.DOWN);
        quadsCTM.removeIf(bakedQuad -> bakedQuad.m_173410_().m_245424_().m_246162_().m_135815_().contains("grape_small_leaves"));
        quadsCTM.removeIf(bakedQuad -> bakedQuad.m_173410_().m_245424_().m_246162_().m_135815_().contains("grape_stage"));
        quadsCTM.sort(Comparator.comparingDouble(b -> QuadFixer.getMaxY((BakedQuad)b)).reversed());
        ArrayList<BakedQuad> visibleFaces = new ArrayList<BakedQuad>();
        for (int i = 0; i < quadsCTM.size(); ++i) {
            BakedQuad faceA = quadsCTM.get(i);
            boolean isCovered = false;
            for (int j = 0; j < i; ++j) {
                BakedQuad faceB = quadsCTM.get(j);
                if (!QuadFixer.cover(faceB, faceA)) continue;
                isCovered = true;
                break;
            }
            if (isCovered) continue;
            visibleFaces.add(faceA);
        }
        return visibleFaces;
    }
}

