/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.model;

import com.teamtea.eclipticseasons.client.model.ISnowyReplaceModel;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.ConcatenatedListView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnowySeasonBakeModel<T extends BakedModel>
extends BakedModelWrapper<T>
implements ISnowyReplaceModel {
    private final T snowModel;
    private final ChunkRenderTypeSet snowRenderTypes;
    private boolean lowlayer = false;
    private boolean replace = false;
    private int flag = -1;

    public SnowySeasonBakeModel(T seasonModel, T snowModel, RenderType snowChunkRenderType) {
        super(seasonModel);
        this.snowModel = snowModel;
        this.snowRenderTypes = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{snowChunkRenderType});
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        return this.combineBakedQuads(this.originalModel.getQuads(state, side, rand, extraData, renderType), this.snowModel.getQuads(state, side, rand, extraData, renderType));
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        ChunkRenderTypeSet renderTypes = this.snowModel.getRenderTypes(state, rand, data);
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{renderTypes, this.snowRenderTypes});
    }

    @NotNull
    protected List<BakedQuad> combineBakedQuads(List<BakedQuad> quads, List<BakedQuad> snowModelQuads_Ori) {
        if (snowModelQuads_Ori.isEmpty()) {
            return quads;
        }
        if (quads.isEmpty()) {
            return snowModelQuads_Ori;
        }
        return ConcatenatedListView.of((List[])new List[]{quads, snowModelQuads_Ori});
    }

    @Override
    public boolean isLowLayer() {
        return this.lowlayer;
    }

    @Override
    public void setLowLayer(boolean lowLayer) {
        this.lowlayer = lowLayer;
    }

    @Override
    public void updateBlockType(int bindBlockType) {
        this.flag = bindBlockType;
    }

    @Override
    public int getBindBlockType() {
        return this.flag;
    }

    @Override
    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }
}

