/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.map;

import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.render.WorldRenderer;
import com.teamtea.eclipticseasons.common.core.map.ChunkInfoMap;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.core.map.XZPos;
import com.teamtea.eclipticseasons.common.misc.MapColorReplacer;
import com.teamtea.eclipticseasons.config.ClientConfig;
import com.teamtea.eclipticseasons.config.CommonConfig;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;

public class ClientMapFixer {
    private static final Long2ObjectOpenHashMap<Long2ObjectLinkedOpenHashMap<XZPos>> CHUNK_POS_XZ_POS_MAP = new Long2ObjectOpenHashMap();

    public static void clearAll() {
        CHUNK_POS_XZ_POS_MAP.clear();
    }

    public static void clearChunk(ChunkPos chunkPos) {
        CHUNK_POS_XZ_POS_MAP.remove(chunkPos.m_45588_());
    }

    public static void clearBlockPos(BlockPos blockPos) {
        Long2ObjectLinkedOpenHashMap orDefault = (Long2ObjectLinkedOpenHashMap)CHUNK_POS_XZ_POS_MAP.computeIfAbsent(new ChunkPos(blockPos).m_45588_(), a -> new Long2ObjectLinkedOpenHashMap());
        ObjectBidirectionalIterator iterator = orDefault.long2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            XZPos xzPos = (XZPos)entry.getValue();
            if (xzPos.x() != blockPos.m_123341_() || xzPos.z() != blockPos.m_123343_()) continue;
            iterator.remove();
        }
    }

    public static void addLightPlanner(ClientLevel level, long packedPos, int brightness) {
        if (CommonConfig.isSnowyWinter() && ((Boolean)ClientConfig.Renderer.realisticSnowyChange.get()).booleanValue() && ((Boolean)CommonConfig.Season.notSnowyNearGlowingBlock.get()).booleanValue()) {
            boolean isTooLight;
            boolean bl = isTooLight = brightness >= (Integer)CommonConfig.Season.notSnowyNearGlowingBlockLevel.get();
            if (isTooLight) {
                boolean isOldHeight;
                BlockPos pos = new BlockPos(BlockPos.m_121983_((long)packedPos), BlockPos.m_122008_((long)packedPos), BlockPos.m_122015_((long)packedPos));
                long startTick = level.m_46467_();
                pos = pos.m_7495_();
                BlockState state = level.m_8055_(pos);
                boolean bl2 = isOldHeight = pos.m_123342_() == ClientMapFixer.agentGetLevelHeight((Level)level, pos);
                if (ClientMapFixer.solidTest(state) && isOldHeight && MapColorReplacer.getTopSnowColor((BlockGetter)level, state, pos, true) != null) {
                    ChunkPos chunkPos = new ChunkPos(pos);
                    Long2ObjectLinkedOpenHashMap xzPosList = (Long2ObjectLinkedOpenHashMap)CHUNK_POS_XZ_POS_MAP.computeIfAbsent(chunkPos.m_45588_(), k -> new Long2ObjectLinkedOpenHashMap());
                    XZPos xzPos = new XZPos(pos.m_123341_(), pos.m_123343_(), startTick, pos.m_123342_());
                    long longKey = xzPos.toLongKey();
                    xzPosList.remove(longKey);
                    xzPosList.put(longKey, (Object)xzPos);
                    MapChecker.updatePosForce((Level)level, pos, level.m_151558_() + 1);
                }
            }
        }
    }

    public static int agentGetLevelHeight(Level level, BlockPos pos) {
        ChunkInfoMap chunkMap = MapChecker.getChunkMap(level, pos);
        Integer old = null;
        if (chunkMap != null && (old = Integer.valueOf(chunkMap.getHeight(pos))) > level.m_151558_()) {
            return old;
        }
        return MapChecker.getMCHeightWithCheck(level, pos, old);
    }

    public static boolean solidTest(BlockState state) {
        return Heightmap.Types.MOTION_BLOCKING.m_64299_().test(state) && !MapChecker.extraSnowPassable(state);
    }

    public static void addPlanner(Level level, BlockState state, BlockPos pos, long startTick, int startY) {
        if (((Boolean)ClientConfig.Renderer.realisticSnowyChange.get()).booleanValue()) {
            boolean isNotOldHeight;
            boolean bl = isNotOldHeight = startY != ClientMapFixer.agentGetLevelHeight(level, pos);
            if ((ClientMapFixer.solidTest(state) || state.m_60734_() == Blocks.f_50016_) && isNotOldHeight && EclipticUtil.isHereWithSnow(level, pos)) {
                ChunkPos chunkPos = new ChunkPos(pos);
                Long2ObjectLinkedOpenHashMap xzPosList = (Long2ObjectLinkedOpenHashMap)CHUNK_POS_XZ_POS_MAP.computeIfAbsent(chunkPos.m_45588_(), k -> new Long2ObjectLinkedOpenHashMap());
                startY = level.m_151558_() + 1;
                XZPos xzPos = new XZPos(pos.m_123341_(), pos.m_123343_(), startTick, startY);
                long longKey = xzPos.toLongKey();
                xzPosList.remove(longKey);
                xzPosList.put(longKey, (Object)xzPos);
                MapChecker.updatePosForce(level, pos, startY);
            } else if (isNotOldHeight) {
                MapChecker.getHeightOrUpdate(level, pos, true);
            }
        } else {
            MapChecker.getHeightOrUpdate(level, pos, true);
        }
    }

    public static void tick(Level level) {
        long tick = level.m_46467_();
        ArrayList removeNeedChunkPosList = new ArrayList();
        HashSet updateSectionsList = new HashSet();
        CHUNK_POS_XZ_POS_MAP.forEach((chunkPos, xzPosList) -> {
            Long2ObjectMap.Entry entry;
            XZPos xzPos2;
            ObjectBidirectionalIterator iterator = xzPosList.long2ObjectEntrySet().iterator();
            ArrayList<XZPos> xzPosToReAdd = null;
            while (iterator.hasNext() && tick - (xzPos2 = (XZPos)(entry = (Long2ObjectMap.Entry)iterator.next()).getValue()).startTick() > 160L && updateSectionsList.size() < 12) {
                BlockPos.MutableBlockPos updatePos = new BlockPos.MutableBlockPos(xzPos2.x(), xzPos2.startY(), xzPos2.z());
                if (!EclipticUtil.isHereSnowy(level, (BlockPos)updatePos) && EclipticUtil.isHereWithSnow(level, (BlockPos)updatePos)) {
                    iterator.remove();
                    if (xzPosToReAdd == null) {
                        xzPosToReAdd = new ArrayList<XZPos>();
                    }
                    xzPosToReAdd.add(new XZPos(xzPos2.x(), xzPos2.z(), level.m_46467_() - 50L, level.m_151558_() + 1));
                    MapChecker.updatePosForce(level, (BlockPos)updatePos, xzPos2.startY());
                    SectionPos sectionPos = SectionPos.m_123199_((BlockPos)updatePos);
                    updateSectionsList.add(sectionPos);
                    continue;
                }
                iterator.remove();
                int y = MapChecker.getHeightOrUpdate(level, (BlockPos)updatePos, true);
                updatePos.m_142448_(y);
                SectionPos sectionPos = SectionPos.m_123199_((BlockPos)updatePos);
                updateSectionsList.add(sectionPos);
            }
            if (xzPosToReAdd != null) {
                for (XZPos xzPos2 : xzPosToReAdd) {
                    xzPosList.put(xzPos2.toLongKey(), (Object)xzPos2);
                }
            }
            if (xzPosList.isEmpty()) {
                removeNeedChunkPosList.add(new ChunkPos(chunkPos.longValue()));
            }
        });
        for (ChunkPos chunkPos2 : removeNeedChunkPosList) {
            CHUNK_POS_XZ_POS_MAP.remove(chunkPos2.m_45588_());
        }
        for (SectionPos sectionPos : updateSectionsList) {
            WorldRenderer.setSectionDirty(sectionPos);
        }
    }
}

