/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client.core;

import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.common.core.biome.WeatherManager;
import com.teamtea.eclipticseasons.common.core.map.MapChecker;
import com.teamtea.eclipticseasons.common.misc.SimplePair;
import com.teamtea.eclipticseasons.config.ClientConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class ClientWeatherChecker {
    public static List<SimplePair<Biome, Long>> lastRainyBiome = new ArrayList<SimplePair<Biome, Long>>();
    public static float lastBiomeRainLevel = -1.0f;
    public static float lastBiomeRThunderLevel = -1.0f;
    public static float nowBiomeRainLevel = 0.0f;
    public static int changeTime = 0;
    public static long lastTime = 0L;
    public static int changeTime_thunder = 0;
    public static int MAX_CHANGE_TIME = 200;
    public static boolean updateForPlayerLogin = true;
    public static float rate = 0.008f;

    public static float getRate() {
        return ((Double)ClientConfig.Weather.weatherTransitionSpeed.get()).floatValue();
    }

    private static boolean isNear(float a, float b, float interval) {
        return Math.abs(a - b) < interval;
    }

    public static boolean isRain(Level clientLevel) {
        return (double)ClientWeatherChecker.getRainLevel(clientLevel, 1.0f) > 0.2;
    }

    public static float getStandardRainLevel(float p46723, Level clientLevel, Holder<Biome> biomeHolder) {
        ArrayList<WeatherManager.BiomeWeather> lists = WeatherManager.getBiomeList(clientLevel);
        if (lists != null) {
            for (WeatherManager.BiomeWeather biomeWeather : lists) {
                if (biomeWeather.biomeHolder != biomeHolder) continue;
                return biomeWeather.rainTime > 0 ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    public static float getRainLevel(Level clientLevel, float p46723) {
        if (updateForPlayerLogin && ClientCon.agent.getCameraEntity() instanceof Player) {
            updateForPlayerLogin = false;
            lastBiomeRainLevel = -1.0f;
        }
        if (lastBiomeRainLevel < 0.0f) {
            float f;
            Entity entity = ClientCon.agent.getCameraEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                f = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, player.m_20097_().m_7494_()));
            } else {
                f = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, null);
            }
            lastBiomeRainLevel = f;
        }
        return lastBiomeRainLevel;
    }

    public static float updateRainLevel(Level clientLevel) {
        float rainLevel = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, null);
        Entity entity = ClientCon.agent.getCameraEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos pos = player.m_20097_();
            int offset = (Integer)ClientConfig.Weather.weatherBufferDistance.get();
            boolean frontUse = (Boolean)ClientConfig.Weather.weatherFrontBias.get();
            float count = 1.0f;
            rainLevel = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, pos));
            if (frontUse && ClientCon.agent.getHitResult() != null) {
                BlockPos[] lookAt = ClientCon.agent.getHitResult().m_82450_();
                Vec3 crs = lookAt.m_82546_(ClientCon.agent.getCameraEntity().m_20182_());
                lookAt = lookAt.m_82549_(crs.m_82541_().m_82490_((double)offset));
                BlockPos lookPos = BlockPos.m_274446_((Position)lookAt);
                rainLevel += ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, lookPos)) * 2.0f;
                count += 2.0f;
            }
            for (BlockPos blockPos : new BlockPos[]{pos.m_122030_(offset), pos.m_122013_(offset), pos.m_122020_(offset), pos.m_122025_(offset)}) {
                Holder<Biome> standBiome = MapChecker.getSurfaceBiome(clientLevel, blockPos);
                float orainLevel = ClientWeatherChecker.getStandardRainLevel(1.0f, clientLevel, standBiome);
                rainLevel += orainLevel;
                count += 1.0f;
            }
            rainLevel /= count;
            if (changeTime > 0) {
                --changeTime;
                if (lastBiomeRainLevel >= 0.0f && !ClientWeatherChecker.isNear(rainLevel, lastBiomeRainLevel, 0.01f)) {
                    float add = ClientWeatherChecker.getRate() * (float)(rainLevel - lastBiomeRainLevel > 0.0f ? 1 : -1);
                    rainLevel = lastBiomeRainLevel += add;
                }
                lastBiomeRainLevel = rainLevel;
                lastBiomeRainLevel = Mth.m_14036_((float)rainLevel, (float)0.0f, (float)1.0f);
            } else if (rainLevel != lastBiomeRainLevel) {
                changeTime = MAX_CHANGE_TIME;
                rainLevel = lastBiomeRainLevel;
            }
        }
        return rainLevel;
    }

    public static float getStandardThunderLevel(float p46723, Level clientLevel, Holder<Biome> biomeHolder) {
        ArrayList<WeatherManager.BiomeWeather> lists = WeatherManager.getBiomeList(clientLevel);
        if (lists != null) {
            for (WeatherManager.BiomeWeather biomeWeather : lists) {
                if (biomeWeather.biomeHolder != biomeHolder) continue;
                return biomeWeather.thunderTime > 0 ? 1.0f : 0.0f;
            }
        }
        return 0.0f;
    }

    public static boolean isThundering(Level clientLevel) {
        return (double)ClientWeatherChecker.getThunderLevel(clientLevel, 1.0f) > 0.2;
    }

    public static float getThunderLevel(Level clientLevel, float p46723) {
        if (updateForPlayerLogin && ClientCon.agent.getCameraEntity() instanceof Player) {
            lastBiomeRainLevel = -1.0f;
        }
        if (lastBiomeRThunderLevel < 0.0f) {
            float f;
            Entity entity = ClientCon.agent.getCameraEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                f = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, player.m_20097_().m_7494_()));
            } else {
                f = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, null);
            }
            lastBiomeRThunderLevel = f;
        }
        return lastBiomeRThunderLevel;
    }

    public static float updateThunderLevel(Level clientLevel) {
        float thunderLevel = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, null);
        Entity entity = ClientCon.agent.getCameraEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos pos = player.m_20097_();
            int offset = (Integer)ClientConfig.Weather.weatherBufferDistance.get();
            boolean frontUse = (Boolean)ClientConfig.Weather.weatherFrontBias.get();
            thunderLevel = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, pos));
            float count = 1.0f;
            if (frontUse && ClientCon.agent.getHitResult() != null) {
                BlockPos[] lookAt = ClientCon.agent.getHitResult().m_82450_();
                Vec3 crs = lookAt.m_82546_(ClientCon.agent.getCameraEntity().m_20182_());
                lookAt = lookAt.m_82549_(crs.m_82541_().m_82490_((double)offset));
                BlockPos lookPos = BlockPos.m_274446_((Position)lookAt);
                thunderLevel += ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, lookPos)) * 2.0f;
                count += 2.0f;
            }
            for (BlockPos blockPos : new BlockPos[]{pos.m_122030_(offset), pos.m_122013_(offset), pos.m_122020_(offset), pos.m_122025_(offset)}) {
                Holder<Biome> standBiome = MapChecker.getSurfaceBiome(clientLevel, blockPos);
                float othunderLevel = ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, standBiome);
                thunderLevel += othunderLevel;
                count += 1.0f;
            }
            thunderLevel /= count;
            if (changeTime_thunder > 0) {
                --changeTime_thunder;
                if (lastBiomeRThunderLevel >= 0.0f && !ClientWeatherChecker.isNear(thunderLevel, lastBiomeRThunderLevel, 0.01f)) {
                    float add = ClientWeatherChecker.getRate() * (float)(thunderLevel - lastBiomeRThunderLevel > 0.0f ? 1 : -1);
                    thunderLevel = lastBiomeRThunderLevel += add;
                }
                lastBiomeRThunderLevel = Mth.m_14036_((float)thunderLevel, (float)0.0f, (float)1.0f);
            } else if (thunderLevel != lastBiomeRThunderLevel) {
                changeTime_thunder = MAX_CHANGE_TIME;
                thunderLevel = lastBiomeRThunderLevel;
            }
        }
        return thunderLevel;
    }

    public static boolean isRainingAt(Level clientLevel, BlockPos blockPos) {
        if (!clientLevel.m_45527_(blockPos)) {
            return false;
        }
        if (clientLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_123342_() > blockPos.m_123342_()) {
            return false;
        }
        return EclipticUtil.getRainOrSnow(clientLevel, (Biome)MapChecker.getSurfaceBiome(clientLevel, blockPos).m_203334_(), blockPos) == Biome.Precipitation.RAIN;
    }

    public static boolean isThunderAt(Level clientLevel, BlockPos blockPos) {
        if (!clientLevel.m_45527_(blockPos)) {
            return false;
        }
        if (clientLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos).m_123342_() > blockPos.m_123342_()) {
            return false;
        }
        return ClientWeatherChecker.getStandardThunderLevel(1.0f, clientLevel, MapChecker.getSurfaceBiome(clientLevel, blockPos)) > 0.9f;
    }

    public static int ModifySnowAmount(int constant, float pPartialTick, Level level) {
        if (level == null) {
            return constant;
        }
        return (int)((float)constant * Mth.m_14036_((float)(level.m_46722_(pPartialTick) * 0.6f), (float)0.6f, (float)1.0f));
    }

    public static float modifyVolume(SoundEvent soundEvent, float pVolume, Level level) {
        if (level == null) {
            return pVolume;
        }
        return pVolume * level.m_46722_(1.0f) * 0.55f;
    }

    public static float modifyPitch(SoundEvent soundEvent, float pPitch, Level level) {
        if (level == null) {
            return pPitch;
        }
        return pPitch * level.m_46722_(1.0f);
    }

    public static int modifyRainAmount(int originalNum, Level level) {
        if (level == null) {
            return originalNum;
        }
        return (int)((float)originalNum * level.m_46722_(1.0f) * 0.6f);
    }

    public static void unloadLevel(Level clientLevel) {
        lastBiomeRThunderLevel = -1.0f;
        lastBiomeRainLevel = -1.0f;
        updateForPlayerLogin = true;
        lastRainyBiome.clear();
    }

    public static void tickAllCheck(Level clientLevel) {
        ClientWeatherChecker.updateRainLevel(clientLevel);
        ClientWeatherChecker.updateThunderLevel(clientLevel);
        ClientWeatherChecker.tickLastRainyBiome(clientLevel);
    }

    public static void addLastRainyBiome(Biome biome, long gameTime) {
        lastRainyBiome.removeIf(biomeLongSimplePair -> biomeLongSimplePair.getKey() == biome);
        lastRainyBiome.add(SimplePair.of(biome, gameTime));
    }

    public static boolean isBiomeRainyLast(Biome biome) {
        return lastRainyBiome.stream().anyMatch(biomeLongEntry -> biomeLongEntry.getKey() == biome);
    }

    public static void tickLastRainyBiome(Level clientLevel) {
        for (int i = 0; i < lastRainyBiome.size(); ++i) {
            SimplePair<Biome, Long> biomeLongSimplePair = lastRainyBiome.get(i);
            biomeLongSimplePair.setValue(biomeLongSimplePair.getValue() - 1L);
            if (biomeLongSimplePair.getValue() > 0L) continue;
            lastRainyBiome.remove(i);
            --i;
        }
    }
}

