/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.client;

import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.biome.Rainfall;
import com.teamtea.eclipticseasons.api.constant.biome.Temperature;
import com.teamtea.eclipticseasons.api.util.EclipticUtil;
import com.teamtea.eclipticseasons.client.color.season.BiomeColorsHandler;
import com.teamtea.eclipticseasons.client.core.ExtraModelManager;
import com.teamtea.eclipticseasons.client.itemproperties.CounterItemProperty;
import com.teamtea.eclipticseasons.client.model.ItemRenderModel;
import com.teamtea.eclipticseasons.client.model.SnowyBakedModelWrapper;
import com.teamtea.eclipticseasons.client.particle.ButterflyParticle;
import com.teamtea.eclipticseasons.client.particle.ColorParticleOptions;
import com.teamtea.eclipticseasons.client.particle.FallenLeavesParticle;
import com.teamtea.eclipticseasons.client.particle.FireflyParticle;
import com.teamtea.eclipticseasons.client.particle.GreenHouseParticle;
import com.teamtea.eclipticseasons.client.particle.ParticleUtil;
import com.teamtea.eclipticseasons.client.particle.WildGooseParticle;
import com.teamtea.eclipticseasons.client.reload.ClientJsonCacheListener;
import com.teamtea.eclipticseasons.client.render.ber.BlockInBlockRender;
import com.teamtea.eclipticseasons.client.render.ber.CalendarBlockEntityRenderer;
import com.teamtea.eclipticseasons.client.render.ber.GreenHouseCoreFrameRenderer;
import com.teamtea.eclipticseasons.client.render.ber.GreenHouseCoreRenderer;
import com.teamtea.eclipticseasons.client.render.ber.PinWheelRenderer;
import com.teamtea.eclipticseasons.client.render.ber.QuestSignRenderer;
import com.teamtea.eclipticseasons.client.render.ber.WindChimesRenderer;
import com.teamtea.eclipticseasons.client.util.ClientClientAgent;
import com.teamtea.eclipticseasons.client.util.ClientCon;
import com.teamtea.eclipticseasons.client.util.ClientExtraUtil;
import com.teamtea.eclipticseasons.common.registry.BlockEntityRegistry;
import com.teamtea.eclipticseasons.common.registry.BlockRegistry;
import com.teamtea.eclipticseasons.common.registry.ItemRegistry;
import com.teamtea.eclipticseasons.common.registry.ParticleRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void blockRegister(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleRegistry.FIREFLY, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new FireflyParticle(level, x, y, z, p_277215_));
        event.registerSpriteSet((ParticleType)ParticleRegistry.WILD_GOOSE, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new WildGooseParticle(level, x, y, z, 0.01, 0.01, 0.01, p_277215_));
        event.registerSpriteSet((ParticleType)ParticleRegistry.BUTTERFLY, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new ButterflyParticle(level, x, y, z, p_277215_));
        event.registerSpriteSet(ParticleRegistry.FALLEN_LEAVES, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new FallenLeavesParticle(level, x, y, z, p_277222_, p_277223_, p_277224_, (ColorParticleOptions)particleType, p_277215_));
        event.registerSpriteSet(ParticleRegistry.GREENHOUSE, p_277215_ -> (particleType, level, x, y, z, p_277222_, p_277223_, p_277224_) -> new GreenHouseParticle(level, x, y, z, p_277222_, p_277223_, p_277224_, (ColorParticleOptions)particleType, p_277215_));
    }

    @SubscribeEvent
    public static void registerExtraModels(ModelEvent.RegisterAdditional event) {
        event.register(ExtraModelManager.stairs_top);
        event.register(ExtraModelManager.snowy_custom);
        event.register(ExtraModelManager.snowy_fern);
        event.register(ExtraModelManager.snowy_grass);
        event.register(ExtraModelManager.snowy_tall_grass_top);
        event.register(ExtraModelManager.snowy_tall_grass_bottom);
        event.register(ExtraModelManager.snowy_large_fern_top);
        event.register(ExtraModelManager.snowy_large_fern_bottom);
        event.register(ExtraModelManager.overlay_2);
        event.register(ExtraModelManager.snow_height2);
        event.register(ExtraModelManager.snow_height2_top);
        event.register(ExtraModelManager.grass_flower);
        event.register(ExtraModelManager.snowy_leaves_attach);
        event.register(ExtraModelManager.snowy_leaves_top);
        ExtraModelManager.flower_on_grass.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        ExtraModelManager.fourleaf_clovers.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        ExtraModelManager.snow_edge_overlays.forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    @SubscribeEvent
    public static void onClientEvent(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            BiomeColors.f_108789_ = BiomeColorsHandler.GRASS_COLOR;
            BiomeColors.f_108790_ = BiomeColorsHandler.FOLIAGE_COLOR;
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.snowyBlock.get()), (RenderType)RenderType.m_110457_());
            ItemProperties.register((Item)((Item)ItemRegistry.hyetometer.get()), (ResourceLocation)ItemRegistry.hyetometer.getId(), (ItemPropertyFunction)new CounterItemProperty(EclipticUtil::getRainfallAt, Rainfall.collectValues().length));
            ItemProperties.register((Item)((Item)ItemRegistry.hygrometer.get()), (ResourceLocation)ItemRegistry.hygrometer.getId(), (ItemPropertyFunction)new CounterItemProperty((level, pos) -> {
                float humidityAt = EclipticUtil.getHumidityLevelAt(level, pos);
                humidityAt = ClientExtraUtil.modifyHumidity(level, pos, humidityAt);
                return Humidity.getHumid(humidityAt);
            }, Humidity.collectValues().length));
            ItemProperties.register((Item)((Item)ItemRegistry.thermometer.get()), (ResourceLocation)ItemRegistry.thermometer.getId(), (ItemPropertyFunction)new CounterItemProperty(EclipticUtil::getTemperatureAt, Temperature.collectValues().length));
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.block_in_wooden_grate_block.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.hygrometer.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.bamboo_wind_chimes.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.paper_wind_chimes.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.wind_chimes.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.pinwheel_blue.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.pinwheel_lime.get()), (RenderType)RenderType.m_110457_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.pinwheel_orange.get()), (RenderType)RenderType.m_110457_());
            ClientCon.agent = new ClientClientAgent();
        });
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.calendar_entity_type.get(), CalendarBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.pinwheel_entity_type.get(), PinWheelRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.wind_chimes_entity_type.get(), WindChimesRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.greenhouse_core_container_entity_type.get(), GreenHouseCoreFrameRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.greenhouse_core_entity_type.get(), GreenHouseCoreRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.season_quest_hanging_sign_entity_type.get(), QuestSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.block_in_copper_grate_block_entity_type.get(), BlockInBlockRender::new);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onModelBaked(ModelEvent.ModifyBakingResult event) {
        ParticleUtil.onReloadResource();
        Map modelRegistry = event.getModels();
        ExtraModelManager.clearForRebaked(modelRegistry);
        ArrayList<ResourceLocation> bakedModels = new ArrayList<ResourceLocation>(List.of(ExtraModelManager.snowy_leaves_attach, ExtraModelManager.snowy_leaves_top, ExtraModelManager.snowy_custom, ExtraModelManager.stairs_top, ExtraModelManager.snowy_fern, ExtraModelManager.snowy_grass, ExtraModelManager.snowy_tall_grass_top, ExtraModelManager.snowy_tall_grass_bottom, ExtraModelManager.snowy_large_fern_top, ExtraModelManager.snowy_large_fern_bottom, ExtraModelManager.overlay_2, ExtraModelManager.snow_height2, ExtraModelManager.snow_height2_top, ExtraModelManager.snowOverlayLeaves, ExtraModelManager.snowySlabBottom, ExtraModelManager.snowOverlayBlock));
        bakedModels.addAll(((Block)BlockRegistry.snowyStairs.get()).m_49965_().m_61056_().stream().map(BlockModelShaper::m_110895_).toList());
        bakedModels.addAll(ExtraModelManager.snow_edge_overlays);
        for (ResourceLocation resourceLocation : bakedModels) {
            BakedModel bakedModel1 = (BakedModel)modelRegistry.get(resourceLocation);
            if (bakedModel1 != null) {
                modelRegistry.put(resourceLocation, new SnowyBakedModelWrapper<BakedModel>(bakedModel1));
                continue;
            }
            EclipticSeasons.logger("Missing Model", resourceLocation);
        }
        for (RegistryObject registryObject : List.of(ItemRegistry.greenhouse_core_container_item, ItemRegistry.spring_greenhouse_core_item, ItemRegistry.summer_greenhouse_core_item, ItemRegistry.autumn_greenhouse_core_item, ItemRegistry.winter_greenhouse_core_item, ItemRegistry.spring_greenhouse_essence_item, ItemRegistry.summer_greenhouse_essence_item, ItemRegistry.autumn_greenhouse_essence_item, ItemRegistry.winter_greenhouse_essence_item)) {
            ModelResourceLocation inventory = new ModelResourceLocation(registryObject.getId(), "inventory");
            BakedModel itemModel = modelRegistry.getOrDefault(inventory, null);
            if (itemModel == null) continue;
            modelRegistry.put(inventory, new ItemRenderModel<BakedModel>(itemModel));
        }
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersEvent_Block(RegisterColorHandlersEvent.Block event) {
        event.register(BiomeColorsHandler::getSpruceColor, new Block[]{Blocks.f_50051_});
        event.register(BiomeColorsHandler::getBirchColor, new Block[]{Blocks.f_50052_});
        event.register(BiomeColorsHandler::getMangroveColor, new Block[]{Blocks.f_220838_});
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersEvent_Item(RegisterColorHandlersEvent.Item event) {
    }

    @SubscribeEvent
    public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener(ClientJsonCacheListener.leafCache);
        event.registerReloadListener(ClientJsonCacheListener.biomeCache);
        event.registerReloadListener(ClientJsonCacheListener.snowDefOverrideCache);
        event.registerReloadListener(ClientJsonCacheListener.ambientCache);
        event.registerReloadListener(ClientJsonCacheListener.seasonDefCache);
    }
}

