/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util.fast;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Enum2ObjectMap<K extends Enum<K>, V>
implements Map<K, V> {
    private final V[] values;
    private final BitSet setFlags;
    private final Class<K> keyType;
    private final V defaultValue;

    public Enum2ObjectMap(Class<K> keyType) {
        this(keyType, null);
    }

    public Enum2ObjectMap(Class<K> keyType, V defaultValue) {
        this.keyType = keyType;
        this.defaultValue = defaultValue;
        Enum[] constants = (Enum[])keyType.getEnumConstants();
        this.values = new Object[constants.length];
        this.setFlags = new BitSet(constants.length);
    }

    @Override
    public V put(K key, V value) {
        this.values[((Enum)key).ordinal()] = value;
        this.setFlags.set(((Enum)key).ordinal());
        return value;
    }

    @Override
    public V get(Object key) {
        if (!this.keyType.isInstance(key)) {
            return null;
        }
        return this.get((K)((Enum)key));
    }

    @Override
    public V get(K key) {
        return this.setFlags.get(((Enum)key).ordinal()) ? this.values[((Enum)key).ordinal()] : this.defaultValue;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyType.isInstance(key) && this.setFlags.get(((Enum)key).ordinal());
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.setFlags.get(i) || !Objects.equals(this.values[i], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        if (!this.keyType.isInstance(key)) {
            return null;
        }
        return this.remove((K)((Enum)key));
    }

    @Override
    public V remove(K key) {
        int ordinal = ((Enum)key).ordinal();
        if (this.setFlags.get(ordinal)) {
            V oldValue = this.values[ordinal];
            this.setFlags.clear(ordinal);
            this.values[ordinal] = null;
            return oldValue;
        }
        return this.defaultValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put((K)((Enum)entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.setFlags.clear();
        Arrays.fill(this.values, null);
    }

    @Override
    public int size() {
        return this.setFlags.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        EnumSet<K> keys = EnumSet.noneOf(this.keyType);
        for (Enum key : (Enum[])this.keyType.getEnumConstants()) {
            if (!this.setFlags.get(key.ordinal())) continue;
            keys.add(key);
        }
        return keys;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<V> vals = new ArrayList<V>();
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.setFlags.get(i)) continue;
            vals.add(this.values[i]);
        }
        return vals;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Enum key : (Enum[])this.keyType.getEnumConstants()) {
            if (!this.setFlags.get(key.ordinal())) continue;
            entries.add(new AbstractMap.SimpleEntry<Enum, V>(key, this.get((K)key)));
        }
        return entries;
    }

    public void fill(V value) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = value;
            this.setFlags.set(i);
        }
    }

    public Class<K> getKeyType() {
        return this.keyType;
    }
}

