/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.util.codec.InterfaceCodec;
import com.teamtea.eclipticseasons.api.util.codec.RecursiveCodec;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class CodecUtil {
    public static <K, V> Codec<Pair<K, V>> pairCodec(Codec<K> keyCodec, Codec<V> valueCodec) {
        return Codec.compoundList(keyCodec, valueCodec).xmap(l -> (Pair)l.get(0), Collections::singletonList);
    }

    public static <K, V> Codec<Pair<K, V>> pairCodec(String nkey, Codec<K> key, String nval, Codec<V> val) {
        return RecordCodecBuilder.create(t -> t.group((App)key.fieldOf(nkey).forGetter(Pair::getFirst), (App)val.fieldOf(nval).forGetter(Pair::getSecond)).apply((Applicative)t, Pair::of));
    }

    public static <K, V> Codec<Pair<K, V>> pairCodec(Function<String, K> keyCodec, Function<String, V> valueCodec) {
        return Codec.STRING.listOf().xmap(c -> Pair.of(keyCodec.apply((String)c.get(0)), valueCodec.apply((String)c.get(1))), p -> List.of(p.getFirst().toString(), p.getSecond().toString()));
    }

    public static <K, V> Codec<Map<K, V>> mapCodec(Codec<K> keyCodec, Codec<V> valueCodec) {
        return Codec.compoundList(keyCodec, valueCodec).xmap(pl -> {
            LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
            for (Pair kvPair : pl) {
                map.put(kvPair.getFirst(), kvPair.getSecond());
            }
            return map;
        }, map -> map.entrySet().stream().map(ent -> Pair.of(ent.getKey(), ent.getValue())).collect(Collectors.toList()));
    }

    public static <K, V> Codec<Map<K, V>> mapCodec(String nkey, Codec<K> keyCodec, String nval, Codec<V> valueCodec) {
        return Codec.list(CodecUtil.pairCodec(nkey, keyCodec, nval, valueCodec)).xmap(pl -> pl.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(ent -> Pair.of(ent.getKey(), ent.getValue())).collect(Collectors.toList()));
    }

    public static <K extends Enum<K>, V> Codec<EnumMap<K, V>> enumMapCodec(StringRepresentable.EnumCodec<K> keyCodec, Codec<V> valueCodec, Class<K> kClass) {
        return Codec.compoundList(keyCodec, valueCodec).xmap(pl -> {
            EnumMap<Enum, Object> collect = new EnumMap<Enum, Object>(kClass);
            int plSize = pl.size();
            for (int i = 0; i < plSize; ++i) {
                Pair kvPair = (Pair)pl.get(i);
                collect.put((Enum)kvPair.getFirst(), kvPair.getSecond());
            }
            return collect;
        }, map -> map.entrySet().stream().map(ent -> Pair.of((Object)((Enum)ent.getKey()), ent.getValue())).collect(Collectors.toList()));
    }

    public static <E> RegistryFixedCodec<E> holderCodec(ResourceKey<? extends Registry<E>> registryKey) {
        return RegistryFixedCodec.m_206740_(registryKey);
    }

    public static <E> Codec<HolderSet<E>> holderSetCodec(ResourceKey<? extends Registry<E>> registryKey) {
        return RegistryCodecs.m_206310_(registryKey, (boolean)false);
    }

    public static <E> Codec<E> empty(E e) {
        return Codec.unit(e);
    }

    public static <I, F extends I, S extends I> Codec<I> either(Codec<F> first, Codec<S> second, Class<F> fClass, Class<S> sClass) {
        return new InterfaceCodec(first, fClass, second, sClass);
    }

    public static <A> Codec<A> lazyInitialized(Supplier<Codec<A>> delegate) {
        return new RecursiveCodec(delegate.toString(), self -> (Codec)delegate.get());
    }

    public static <E> Codec<List<E>> listFrom(Codec<E> singleCodec) {
        return Codec.either(singleCodec, (Codec)singleCodec.listOf()).flatXmap(either -> DataResult.success(either.left().isPresent() ? List.of(either.left().get()) : (either.right().isPresent() ? (List)either.right().get() : List.of())), cond -> {
            if (cond.size() == 1) {
                return DataResult.success((Object)Either.left(cond.get(0)));
            }
            return DataResult.success((Object)Either.right((Object)cond));
        });
    }
}

