/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.util.backport;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.util.backport.FakeStatePropertiesPredicate;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record FakeBlockPredicate(Optional<HolderSet<Block>> blocks, Optional<FakeStatePropertiesPredicate> properties) {
    public static final Codec<FakeBlockPredicate> CODEC = RecordCodecBuilder.create(p_337342_ -> p_337342_.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).optionalFieldOf("blocks").forGetter(FakeBlockPredicate::blocks), (App)FakeStatePropertiesPredicate.CODEC.optionalFieldOf("state").forGetter(FakeBlockPredicate::properties)).apply((Applicative)p_337342_, FakeBlockPredicate::new));

    public FakeBlockPredicate(HolderSet<Block> blockHolderSet) {
        this(Optional.of(blockHolderSet), Optional.empty());
    }

    public boolean matches(BlockState state) {
        return !(!this.blocks.isEmpty() && !state.m_204341_(this.blocks.get()) || !this.properties.isEmpty() && !this.properties.get().matches(state));
    }

    public boolean matches(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        return this.matches(level.m_8055_(pos));
    }

    public HolderSet<Block> getBlocks() {
        return this.blocks.orElseGet(() -> HolderSet.m_205809_((Holder[])new Holder[0]));
    }

    public static class Builder {
        private Optional<HolderSet<Block>> blocks = Optional.empty();
        private Optional<FakeStatePropertiesPredicate> properties = Optional.empty();

        private Builder() {
        }

        public static Builder block() {
            return new Builder();
        }

        public Builder of(Block ... blocks) {
            this.blocks = Optional.of(HolderSet.m_205806_(Block::m_204297_, (Object[])blocks));
            return this;
        }

        public Builder of(TagKey<Block> tag) {
            this.blocks = Optional.of(BuiltInRegistries.f_256975_.m_203561_(tag));
            return this;
        }

        public Builder setProperties(FakeStatePropertiesPredicate.Builder properties) {
            this.properties = properties.build();
            return this;
        }

        public FakeBlockPredicate build() {
            return new FakeBlockPredicate(this.blocks, this.properties);
        }
    }
}

