/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.misc;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;

public interface RegistryFilter<T> {
    public List<? extends Holder<T>> toHolders(Registry<T> var1);

    public record Not<T>(RegistryFilter<T>[] filters) implements RegistryFilter<T>
    {
        @Override
        public List<? extends Holder<T>> toHolders(Registry<T> biomes) {
            HashSet excluded = new HashSet();
            for (RegistryFilter<T> f : this.filters) {
                excluded.addAll(f.toHolders(biomes));
            }
            return biomes.m_203611_().filter(holder -> !excluded.contains(holder)).toList();
        }
    }

    public record Or<T>(RegistryFilter<T>[] filters) implements RegistryFilter<T>
    {
        @SafeVarargs
        public Or(TagKey<T> ... tags) {
            this((RegistryFilter[])Stream.of(tags).map(TagHolder::new).toArray(RegistryFilter[]::new));
        }

        @Override
        public List<Holder<T>> toHolders(Registry<T> biomes) {
            HashSet<Holder<T>> result = new HashSet<Holder<T>>();
            for (RegistryFilter<T> f : this.filters) {
                result.addAll(f.toHolders(biomes));
            }
            return List.copyOf(result);
        }
    }

    public record And<T>(RegistryFilter<T>[] filters) implements RegistryFilter<T>
    {
        @Override
        public List<Holder<T>> toHolders(Registry<T> biomes) {
            if (this.filters.length == 0) {
                return List.of();
            }
            HashSet<Holder<T>> result = new HashSet<Holder<T>>(this.filters[0].toHolders(biomes));
            for (int i = 1; i < this.filters.length; ++i) {
                result.retainAll(this.filters[i].toHolders(biomes));
            }
            return List.copyOf(result);
        }
    }

    public record TagHolder<T>(TagKey<T> tag) implements RegistryFilter<T>
    {
        @Override
        public List<Holder<T>> toHolders(Registry<T> biomes) {
            return biomes.m_203431_(this.tag).map(b -> b.m_203614_().toList()).orElse(List.of());
        }
    }

    public record DirectHolder<T>(ResourceKey<T> key) implements RegistryFilter<T>
    {
        @Override
        public List<? extends Holder<T>> toHolders(Registry<T> biomes) {
            return biomes.m_203636_(this.key).map(List::of).orElse(List.of());
        }
    }
}

