/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.weather;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.constant.solar.TimePeriod;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.api.data.weather.CustomRain;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.biome.Biome;

public record CustomRainBuilder(HolderSet<Biome> biomes, SolarTermValueMap<List<Weather>> weathers) {
    public static final Codec<CustomRainBuilder> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)CodecUtil.holderSetCodec(Registries.f_256952_).fieldOf("biomes").forGetter(CustomRainBuilder::biomes), (App)SolarTermValueMap.codec(CodecUtil.listFrom(Weather.CODEC)).fieldOf("weathers").forGetter(CustomRainBuilder::weathers)).apply((Applicative)ins, CustomRainBuilder::new));
    public static final Codec<CustomRainBuilder> DIRECT_CODEC = RecordCodecBuilder.create(ins -> ins.group((App)SolarTermValueMap.codec(CodecUtil.listFrom(Weather.CODEC)).fieldOf("weathers").forGetter(CustomRainBuilder::weathers)).apply((Applicative)ins, m -> new CustomRainBuilder((HolderSet<Biome>)HolderSet.m_205809_((Holder[])new Holder[0]), (SolarTermValueMap<List<Weather>>)m)));

    public Map<SolarTerm, CustomRain> build() {
        return this.weathers.combine().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            List<CustomRain.Weather> weatherList = ((List)e.getValue()).stream().map(w -> CustomRain.Weather.of((SolarTerm)e.getKey(), w)).toList();
            return new CustomRain(((SolarTerm)e.getKey()).ordinal(), weatherList, weatherList.size() == 1 && weatherList.get(0).timePeriod().isEmpty() ? Optional.of((BiomeRain)weatherList.get(0)) : Optional.empty(), (float)weatherList.stream().mapToDouble(CustomRain.Weather::getRainChance).average().orElse(0.0), (float)weatherList.stream().mapToDouble(CustomRain.Weather::getThunderChance).average().orElse(0.0));
        }, (a, b) -> b, () -> new EnumMap(SolarTerm.class)));
    }

    public record Weather(Optional<IntProvider> rain, Optional<IntProvider> rainDelay, Optional<IntProvider> thunder, Optional<IntProvider> thunderDelay, float rainChance, float thunderChance, List<TimePeriod> timePeriod) {
        public static final Codec<Weather> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)IntProvider.f_146533_.optionalFieldOf("rain").forGetter(Weather::rain), (App)IntProvider.f_146533_.optionalFieldOf("rain_delay").forGetter(Weather::rainDelay), (App)IntProvider.f_146533_.optionalFieldOf("thunder").forGetter(Weather::thunder), (App)IntProvider.f_146533_.optionalFieldOf("thunder_delay").forGetter(Weather::thunderDelay), (App)Codec.FLOAT.fieldOf("rain_chance").forGetter(Weather::rainChance), (App)Codec.FLOAT.optionalFieldOf("thunder_chance", (Object)Float.valueOf(0.0f)).forGetter(Weather::thunderChance), (App)StringRepresentable.m_216439_(TimePeriod::collectValues).listOf().optionalFieldOf("time_periods", List.of()).forGetter(Weather::timePeriod)).apply((Applicative)ins, Weather::new));

        public Weather(Optional<IntProvider> rain, Optional<IntProvider> rainDelay, Optional<IntProvider> thunder, float rainChance, float thunderChance, List<TimePeriod> timePeriod) {
            this(rain, rainDelay, thunder, Optional.empty(), rainChance, thunderChance, timePeriod);
        }

        public Weather(float rainChance, float thunderChance, List<TimePeriod> timePeriod) {
            this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), rainChance, thunderChance, timePeriod);
        }

        public Weather(float rainChance, float thunderChance) {
            this(rainChance, thunderChance, List.of());
        }
    }
}

