/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.season.definition.selector;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.teamtea.eclipticseasons.EclipticSeasons;
import com.teamtea.eclipticseasons.api.data.season.definition.ISeasonChangeContext;
import com.teamtea.eclipticseasons.api.data.season.definition.condition.IChangeCondition;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.BlockSelector;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.ChangeSelectors;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public interface IChangeSelector {
    public static final Codec<IChangeSelector> CCODEC = Codec.either((Codec)BlockSelector.CODEC.codec(), (Codec)Codec.STRING.xmap(s -> s.contains(":") ? new ResourceLocation(s) : EclipticSeasons.rl(s), r -> r.m_135827_().equals("eclipticseasons") ? r.m_135815_() : r.toString()).dispatch("type", IChangeSelector::getType, id -> ChangeSelectors.CONDITIONS.get(id).codec())).xmap(e -> e.left().map(bs -> bs).orElseGet(() -> (IChangeSelector)e.right().orElseThrow()), ics -> {
        Either either;
        if (ics instanceof BlockSelector) {
            BlockSelector bs = (BlockSelector)ics;
            either = Either.left((Object)bs);
        } else {
            either = Either.right((Object)ics);
        }
        return either;
    });
    public static final int DEFAULT_WEIGHT = 10;

    public ResourceLocation getType();

    public MapCodec<? extends IChangeSelector> codec();

    public boolean place(ServerLevel var1, BlockPos var2, ISeasonChangeContext var3);

    default public int getWeight() {
        return 10;
    }

    default public List<IChangeCondition> getConditions() {
        return List.of();
    }

    default public Optional<ResourceLocation> getLoot() {
        return Optional.empty();
    }

    default public boolean shouldApply(Level level, BlockPos pos, ISeasonChangeContext context) {
        for (IChangeCondition condition : this.getConditions()) {
            if (condition.test(level, pos, context)) continue;
            return false;
        }
        return true;
    }

    default public boolean dropWhenApplied(Level level, BlockPos pos, ISeasonChangeContext context) {
        return true;
    }
}

