/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.season.definition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.data.season.definition.selector.IChangeSelector;
import com.teamtea.eclipticseasons.api.util.backport.FakeBlockPredicate;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public record ChangeMode(FakeBlockPredicate original, List<IChangeSelector> selectors, float chance, boolean fixedSeed) {
    public static final Codec<ChangeMode> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)FakeBlockPredicate.CODEC.fieldOf("target").forGetter(ChangeMode::original), (App)CodecUtil.listFrom(IChangeSelector.CCODEC).fieldOf("place").forGetter(ChangeMode::selectors), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(0.0625f)).forGetter(ChangeMode::chance), (App)Codec.BOOL.optionalFieldOf("fixed_seed", (Object)false).forGetter(ChangeMode::fixedSeed)).apply((Applicative)ins, ChangeMode::new));

    public List<BlockState> getPossibleStates() {
        ArrayList<BlockState> blockStates;
        block5: {
            block4: {
                blockStates = new ArrayList<BlockState>();
                if (!this.original.blocks().isPresent()) break block4;
                for (Holder blockHolder : this.original.blocks().get()) {
                    for (BlockState possibleState : ((Block)blockHolder.m_203334_()).m_49965_().m_61056_()) {
                        if (!this.original.properties().isEmpty() && !this.original.properties().get().matches(possibleState)) continue;
                        blockStates.add(possibleState);
                    }
                }
                break block5;
            }
            if (!this.original.properties().isPresent()) break block5;
            for (Block block : BuiltInRegistries.f_256975_) {
                for (BlockState possibleState : block.m_49965_().m_61056_()) {
                    if (!this.original.properties().isEmpty() && !this.original.properties().get().matches(possibleState)) continue;
                    blockStates.add(possibleState);
                }
            }
        }
        return blockStates;
    }

    public List<Block> getPossibleBlocks() {
        ArrayList<Block> blocks;
        block4: {
            block3: {
                blocks = new ArrayList<Block>();
                if (!this.original.blocks().isPresent()) break block3;
                for (Holder blockHolder : this.original.blocks().get()) {
                    blocks.add((Block)blockHolder.m_203334_());
                }
                break block4;
            }
            if (!this.original.properties().isPresent()) break block4;
            block1: for (Block block : BuiltInRegistries.f_256975_) {
                for (BlockState possibleState : block.m_49965_().m_61056_()) {
                    if (!this.original.properties().isEmpty() && !this.original.properties().get().matches(possibleState)) continue;
                    blocks.add(block);
                    continue block1;
                }
            }
        }
        return blocks;
    }

    public boolean matchesState(BlockState state) {
        return !(!this.original.blocks().isEmpty() && !state.m_204341_(this.original.blocks().get()) || !this.original.properties().isEmpty() && !this.original.properties().get().matches(state));
    }

    private static boolean matchesBlockEntity(LevelReader level, @Nullable BlockEntity blockEntity, NbtPredicate nbtPredicate) {
        return blockEntity != null && nbtPredicate.m_57483_((Tag)blockEntity.m_187480_());
    }

    public boolean matches(BlockState state, Level level, BlockPos pos) {
        return this.matchesState(state);
    }

    @Generated
    public static ChangeModeBuilder builder() {
        return new ChangeModeBuilder();
    }

    @Generated
    public static class ChangeModeBuilder {
        @Generated
        private FakeBlockPredicate original;
        @Generated
        private ArrayList<IChangeSelector> selectors;
        @Generated
        private float chance;
        @Generated
        private boolean fixedSeed;

        @Generated
        ChangeModeBuilder() {
        }

        @Generated
        public ChangeModeBuilder original(FakeBlockPredicate original) {
            this.original = original;
            return this;
        }

        @Generated
        public ChangeModeBuilder selector(IChangeSelector selector) {
            if (this.selectors == null) {
                this.selectors = new ArrayList();
            }
            this.selectors.add(selector);
            return this;
        }

        @Generated
        public ChangeModeBuilder selectors(Collection<? extends IChangeSelector> selectors) {
            if (selectors == null) {
                throw new NullPointerException("selectors cannot be null");
            }
            if (this.selectors == null) {
                this.selectors = new ArrayList();
            }
            this.selectors.addAll(selectors);
            return this;
        }

        @Generated
        public ChangeModeBuilder clearSelectors() {
            if (this.selectors != null) {
                this.selectors.clear();
            }
            return this;
        }

        @Generated
        public ChangeModeBuilder chance(float chance) {
            this.chance = chance;
            return this;
        }

        @Generated
        public ChangeModeBuilder fixedSeed(boolean fixedSeed) {
            this.fixedSeed = fixedSeed;
            return this;
        }

        @Generated
        public ChangeMode build() {
            return new ChangeMode(this.original, switch (this.selectors == null ? 0 : this.selectors.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.selectors.get(0));
                default -> Collections.unmodifiableList(new ArrayList<IChangeSelector>(this.selectors));
            }, this.chance, this.fixedSeed);
        }

        @Generated
        public String toString() {
            return "ChangeMode.ChangeModeBuilder(original=" + String.valueOf(this.original) + ", selectors=" + String.valueOf(this.selectors) + ", chance=" + this.chance + ", fixedSeed=" + this.fixedSeed + ")";
        }
    }
}

