/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.quest;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.quest.WarpItemPredicate;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record SeasonQuest(Optional<SolarTerm> end, Optional<SolarTerm> start, List<WarpItemPredicate> need, List<ItemStack> award, Optional<String> tittle, Optional<List<String>> description, Optional<HolderSet<AgroClimaticZone>> climate, Optional<Integer> max_count, Optional<Integer> seasonal_count, Optional<Integer> weight, Optional<Boolean> glowing, Optional<Integer> color) {
    public static final Codec<String> TRANSLATE_CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.STRING.fieldOf("translate").forGetter(c -> c)).apply((Applicative)ins, String::new));
    public static final Codec<SeasonQuest> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)StringRepresentable.m_216439_(SolarTerm::collectValues).optionalFieldOf("end").forGetter(SeasonQuest::end), (App)StringRepresentable.m_216439_(SolarTerm::collectValues).optionalFieldOf("start").forGetter(SeasonQuest::start), (App)WarpItemPredicate.CODEC.listOf().fieldOf("need").forGetter(SeasonQuest::need), (App)ItemStack.f_41582_.listOf().fieldOf("award").forGetter(SeasonQuest::award), (App)TRANSLATE_CODEC.optionalFieldOf("tittle").forGetter(SeasonQuest::tittle), (App)TRANSLATE_CODEC.listOf().optionalFieldOf("description").forGetter(SeasonQuest::description), (App)CodecUtil.holderSetCodec(ESRegistries.AGRO_CLIMATE).optionalFieldOf("climate").forGetter(SeasonQuest::climate), (App)Codec.INT.optionalFieldOf("max_count").forGetter(SeasonQuest::max_count), (App)Codec.INT.optionalFieldOf("seasonal_count").forGetter(SeasonQuest::seasonal_count), (App)Codec.INT.optionalFieldOf("weight").forGetter(SeasonQuest::weight), (App)Codec.BOOL.optionalFieldOf("glowing").forGetter(SeasonQuest::glowing), (App)Codec.INT.optionalFieldOf("color").forGetter(SeasonQuest::color)).apply((Applicative)ins, SeasonQuest::new));
    public static final Codec<SeasonQuest> DIRECT_CODEC = RecordCodecBuilder.create(ins -> ins.group((App)StringRepresentable.m_216439_(SolarTerm::collectValues).optionalFieldOf("end").forGetter(SeasonQuest::end), (App)StringRepresentable.m_216439_(SolarTerm::collectValues).optionalFieldOf("start").forGetter(SeasonQuest::start), (App)TRANSLATE_CODEC.optionalFieldOf("tittle").forGetter(SeasonQuest::tittle), (App)TRANSLATE_CODEC.listOf().optionalFieldOf("description").forGetter(SeasonQuest::description), (App)Codec.INT.optionalFieldOf("max_count").forGetter(SeasonQuest::max_count), (App)Codec.INT.optionalFieldOf("seasonal_count").forGetter(SeasonQuest::seasonal_count), (App)Codec.INT.optionalFieldOf("weight").forGetter(SeasonQuest::weight), (App)Codec.BOOL.optionalFieldOf("glowing").forGetter(SeasonQuest::glowing), (App)Codec.INT.optionalFieldOf("color").forGetter(SeasonQuest::color)).apply((Applicative)ins, (solarTerm, solarTerm2, s, strings, integer, integer2, integer3, aBoolean, integer4) -> new SeasonQuest((Optional<SolarTerm>)solarTerm, (Optional<SolarTerm>)solarTerm2, List.of(), List.of(), (Optional<String>)s, (Optional<List<String>>)strings, Optional.empty(), (Optional<Integer>)integer, (Optional<Integer>)integer2, (Optional<Integer>)integer3, (Optional<Boolean>)aBoolean, (Optional<Integer>)integer4)));

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SolarTerm end;
        private SolarTerm start;
        private List<WarpItemPredicate> need = new ArrayList<WarpItemPredicate>();
        private List<ItemStack> award = new ArrayList<ItemStack>();
        private String tittle;
        private List<String> description = new ArrayList<String>();
        private HolderSet<AgroClimaticZone> climate;
        private Integer max_count;
        private Integer seasonal_count;
        private Integer weight;
        private Boolean glowing;
        private Integer color;

        private Builder() {
        }

        public Builder setEnd(SolarTerm end) {
            this.end = end;
            return this;
        }

        public Builder setStart(SolarTerm start2) {
            this.start = start2;
            return this;
        }

        public Builder addNeed(WarpItemPredicate need) {
            this.need.add(need);
            return this;
        }

        public Builder addNeed(Holder<Item> need, int count) {
            this.need.add(new WarpItemPredicate((HolderSet<Item>)HolderSet.m_205809_((Holder[])new Holder[]{need}), count));
            return this;
        }

        public Builder addNeed(HolderSet<Item> need, int count) {
            this.need.add(new WarpItemPredicate(need, count));
            return this;
        }

        public Builder addAward(ItemStack award) {
            this.award.add(award);
            return this;
        }

        public Builder addAward(Item award) {
            this.award.add(award.m_7968_());
            return this;
        }

        public Builder setTittle(String tittle) {
            this.tittle = tittle;
            return this;
        }

        public Builder addDescription(String description) {
            this.description.add(description);
            return this;
        }

        public Builder setClimate(HolderSet<AgroClimaticZone> climate) {
            this.climate = climate;
            return this;
        }

        public Builder setMaxCount(Integer max_count) {
            this.max_count = max_count;
            return this;
        }

        public Builder setSeasonalCount(Integer seasonal_count) {
            this.seasonal_count = seasonal_count;
            return this;
        }

        public Builder setWeight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public Builder setGlowing(Boolean glowing) {
            this.glowing = glowing;
            return this;
        }

        public Builder setColor(Integer color) {
            this.color = color;
            return this;
        }

        public SeasonQuest build() {
            return new SeasonQuest(Optional.ofNullable(this.end), Optional.ofNullable(this.start), this.need, this.award, Optional.ofNullable(this.tittle), this.description.isEmpty() ? Optional.empty() : Optional.of(this.description), Optional.ofNullable(this.climate), Optional.ofNullable(this.max_count), Optional.ofNullable(this.seasonal_count), Optional.ofNullable(this.weight), Optional.ofNullable(this.glowing), Optional.ofNullable(this.color));
        }
    }
}

