/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.crop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.biome.Humidity;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.climate.AgroClimaticZone;
import com.teamtea.eclipticseasons.api.data.crop.CropGrowControl;
import com.teamtea.eclipticseasons.api.data.crop.GrowParameter;
import com.teamtea.eclipticseasons.api.util.backport.FakeBlockPredicate;
import com.teamtea.eclipticseasons.api.util.codec.CodecUtil;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.common.misc.SimplePair;
import com.teamtea.eclipticseasons.common.registry.ESRegistries;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;

public record CropGrowControlBuilder(HolderSet<AgroClimaticZone> cropClimateType, FakeBlockPredicate applyTarget, HolderSet<CropGrowControlBuilder> parent, Optional<GrowParameter> defaultSolarTermGrowParameter, Optional<GrowParameter> defaultHumidityGrowParameter, EnumMap<SolarTerm, GrowParameter> solarTermList, EnumMap<Season, GrowParameter> seasonList, EnumMap<Humidity, GrowParameter> humidList, Optional<HolderSet<Block>> notGreenHouse) {
    public static final Codec<SolarTerm> SOLAR_TERM_CODEC_STRING = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)SolarTerm.valueOf(s.toUpperCase()));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return DataResult.error(() -> "Not a valid solar term: " + s + " " + resourcelocationexception.getMessage());
        }
    }, SolarTerm::getName).stable();
    public static final Codec<EnumMap<Season, GrowParameter>> Season_ENUM_MAP_CODEC = CodecUtil.enumMapCodec(StringRepresentable.m_216439_(Season::collectValues), GrowParameter.CODEC, Season.class);
    public static final Codec<EnumMap<Humidity, GrowParameter>> HUMID_ENUM_MAP_CODEC = CodecUtil.enumMapCodec(StringRepresentable.m_216439_(Humidity::collectValues), GrowParameter.CODEC, Humidity.class);
    public static final Codec<EnumMap<SolarTerm, GrowParameter>> SOLAR_TERM_ENUM_MAP_CODEC = CodecUtil.enumMapCodec(StringRepresentable.m_216439_(SolarTerm::collectValues), GrowParameter.CODEC, SolarTerm.class);
    public static final HolderSet.Direct<CropGrowControlBuilder> EMPTY = HolderSet.m_205800_(List.of());
    public static final Codec<CropGrowControlBuilder> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)GrowParameter.CODEC.optionalFieldOf("humidity_default").forGetter(CropGrowControlBuilder::defaultHumidityGrowParameter), (App)SOLAR_TERM_ENUM_MAP_CODEC.optionalFieldOf("solar_terms", new EnumMap(SolarTerm.class)).forGetter(CropGrowControlBuilder::solarTermList), (App)Season_ENUM_MAP_CODEC.optionalFieldOf("seasons", new EnumMap(Season.class)).forGetter(CropGrowControlBuilder::seasonList), (App)HUMID_ENUM_MAP_CODEC.optionalFieldOf("humidity", new EnumMap(Humidity.class)).forGetter(CropGrowControlBuilder::humidList), (App)CodecUtil.holderSetCodec(ESRegistries.AGRO_CLIMATE).fieldOf("climate").forGetter(CropGrowControlBuilder::cropClimateType), (App)ESExtraCodec.BLOCK_HOLDER_SET_CODEC.optionalFieldOf("unlike_greenhouse_material").forGetter(CropGrowControlBuilder::notGreenHouse), (App)CodecUtil.holderSetCodec(ESRegistries.CROP).fieldOf("parent").orElse((Object)HolderSet.m_205809_((Holder[])new Holder[0])).forGetter(CropGrowControlBuilder::parent), (App)GrowParameter.CODEC.optionalFieldOf("season_default").forGetter(CropGrowControlBuilder::defaultSolarTermGrowParameter), (App)FakeBlockPredicate.CODEC.fieldOf("apply_target").forGetter(CropGrowControlBuilder::applyTarget)).apply((Applicative)ins, (defaultGrowParameter2, solarTermGrowParameterEnumMap, seasonGrowParameterEnumMap, humidityGrowParameterEnumMap, holders, notGreenHouse, holders2, defaultGrowParameter, blockPredicate) -> new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)holders, (FakeBlockPredicate)blockPredicate, (HolderSet<CropGrowControlBuilder>)holders2, (Optional<GrowParameter>)defaultGrowParameter, (Optional<GrowParameter>)defaultGrowParameter2, (EnumMap<SolarTerm, GrowParameter>)solarTermGrowParameterEnumMap, (EnumMap<Season, GrowParameter>)seasonGrowParameterEnumMap, (EnumMap<Humidity, GrowParameter>)humidityGrowParameterEnumMap, (Optional<HolderSet<Block>>)notGreenHouse)));
    public static final Codec<CropGrowControlBuilder> DIRECT_CODEC = RecordCodecBuilder.create(ins -> ins.group((App)GrowParameter.CODEC.optionalFieldOf("humidity_default").forGetter(CropGrowControlBuilder::defaultHumidityGrowParameter), (App)SOLAR_TERM_ENUM_MAP_CODEC.optionalFieldOf("solar_terms", new EnumMap(SolarTerm.class)).forGetter(CropGrowControlBuilder::solarTermList), (App)Season_ENUM_MAP_CODEC.optionalFieldOf("seasons", new EnumMap(Season.class)).forGetter(CropGrowControlBuilder::seasonList), (App)HUMID_ENUM_MAP_CODEC.optionalFieldOf("humidity", new EnumMap(Humidity.class)).forGetter(CropGrowControlBuilder::humidList), (App)GrowParameter.CODEC.optionalFieldOf("season_default").forGetter(CropGrowControlBuilder::defaultSolarTermGrowParameter)).apply((Applicative)ins, (defaultGrowParameter2, solarTermGrowParameterEnumMap, seasonGrowParameterEnumMap, humidityGrowParameterEnumMap, defaultGrowParameter) -> new CropGrowControlBuilder((HolderSet<AgroClimaticZone>)HolderSet.m_205809_((Holder[])new Holder[0]), new FakeBlockPredicate(Optional.empty(), Optional.empty()), (HolderSet<CropGrowControlBuilder>)HolderSet.m_205809_((Holder[])new Holder[0]), (Optional<GrowParameter>)defaultGrowParameter, (Optional<GrowParameter>)defaultGrowParameter2, (EnumMap<SolarTerm, GrowParameter>)solarTermGrowParameterEnumMap, (EnumMap<Season, GrowParameter>)seasonGrowParameterEnumMap, (EnumMap<Humidity, GrowParameter>)humidityGrowParameterEnumMap, Optional.empty())));

    public SimplePair<Block, CropGrowControl> build() {
        SimplePair<Object, Object> pair = SimplePair.of(null, null);
        return pair;
    }

    public boolean isChildClimateType(HolderSet<AgroClimaticZone> parentClimateType) {
        Holder cropClimateTypeHolder;
        int i;
        if (this.cropClimateType().m_203632_() > parentClimateType.m_203632_()) {
            return false;
        }
        HashSet<Holder> cropClimateTypes = new HashSet<Holder>();
        for (i = 0; i < parentClimateType.m_203632_(); ++i) {
            cropClimateTypeHolder = parentClimateType.m_203662_(i);
            cropClimateTypes.add(cropClimateTypeHolder);
        }
        for (i = 0; i < this.cropClimateType().m_203632_(); ++i) {
            cropClimateTypeHolder = this.cropClimateType().m_203662_(i);
            if (cropClimateTypes.contains(cropClimateTypeHolder)) continue;
            return false;
        }
        return true;
    }
}

