/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.client.ColorMode;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.api.misc.util.HolderMappable;
import com.teamtea.eclipticseasons.api.misc.util.Mergable;
import com.teamtea.eclipticseasons.api.util.codec.ESExtraCodec;
import com.teamtea.eclipticseasons.api.util.fast.Enum2IntMap;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public record LeafColor(ColorSource colorSource, HolderSet<Block> blockPredicate, Optional<HolderSet<Biome>> locationPredicate, Optional<SolarTermValueMap<ColorMode>> colors, Optional<SolarTermValueMap<List<ResourceLocation>>> sprites, Optional<SolarTermValueMap<Integer>> weights, Optional<Boolean> replace) implements HolderMappable<HolderSet<Block>, Pair<InstanceHolder, Instance>>
{
    public static final Codec<LeafColor> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)StringRepresentable.m_216439_(ColorSource::collectValues).fieldOf("source").orElse((Object)ColorSource.CUSTOM).forGetter(LeafColor::colorSource), (App)ESExtraCodec.BLOCK_HOLDER_SET_CODEC.fieldOf("block").forGetter(LeafColor::blockPredicate), (App)ESExtraCodec.BIOME_HOLDER_SET_CODEC.optionalFieldOf("location").forGetter(LeafColor::locationPredicate), (App)SolarTermValueMap.codec(ColorMode.CODEC).optionalFieldOf("colors").forGetter(LeafColor::colors), (App)SolarTermValueMap.codec(ResourceLocation.f_135803_.listOf()).optionalFieldOf("sprites").forGetter(LeafColor::sprites), (App)SolarTermValueMap.codec(Codec.INT).optionalFieldOf("weights").forGetter(LeafColor::weights), (App)Codec.BOOL.optionalFieldOf("replace").forGetter(LeafColor::replace)).apply((Applicative)ins, LeafColor::new));
    private static final SolarTermValueMap<ColorMode> EMPTY_MODE_MAP = new SolarTermValueMap(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final SolarTermValueMap<List<ResourceLocation>> EMPTY_LIST_MAP = new SolarTermValueMap(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    private static final SolarTermValueMap<Integer> EMPTY_INTEGER_MAP = new SolarTermValueMap(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());

    @Override
    public Pair<HolderSet<Block>, Pair<InstanceHolder, Instance>> asHolderMapping() {
        return Pair.of(this.blockPredicate(), this.toInstance());
    }

    @NotNull
    public Pair<InstanceHolder, Instance> toInstance() {
        EnumMap<SolarTerm, ColorMode> colorMap = this.colors.orElse(EMPTY_MODE_MAP).combine();
        EnumMap<SolarTerm, List<ResourceLocation>> spriteMap = this.sprites.orElse(EMPTY_LIST_MAP).combine();
        EnumMap<SolarTerm, Integer> weightMap = this.weights.orElse(EMPTY_INTEGER_MAP).combine();
        Enum2ObjectMap<SolarTerm, ColorMode.Instance> colorsE = SolarTermValueMap.convertToEnum2ObjectMap(colorMap, ColorMode::toInstance);
        Enum2ObjectMap<SolarTerm, List<ResourceLocation>> spritesE = SolarTermValueMap.convertToEnum2ObjectMap(spriteMap, Function.identity());
        Enum2IntMap<SolarTerm> weightsE = new Enum2IntMap<SolarTerm>(SolarTerm.class);
        weightMap.forEach(weightsE::put);
        return Pair.of((Object)new InstanceHolder(Optional.ofNullable(this.blockPredicate), this.locationPredicate), (Object)new Instance(this.colorSource, colorsE, spritesE, weightsE, this.replace.orElse(false)));
    }

    public static enum ColorSource implements StringRepresentable
    {
        MAP,
        BLOCK,
        TEXTURE,
        CUSTOM;

        private static final ColorSource[] VALUES;

        public static ColorSource[] collectValues() {
            return VALUES;
        }

        @NotNull
        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = ColorSource.values();
        }
    }

    public record InstanceHolder(Optional<HolderSet<Block>> blockPredicate, Optional<HolderSet<Biome>> locationPredicate) {
        private static final InstanceHolder EMPTY = new InstanceHolder(Optional.empty(), Optional.empty());

        public boolean matches(Level level, int i, int j, int k, RandomSource random, BlockState blockstate) {
            Holder biomeHolder;
            HolderSet<Biome> location;
            HolderSet<Block> predicate;
            if (this.blockPredicate.isPresent() && !(predicate = this.blockPredicate.get()).m_203333_(blockstate.m_222976_())) {
                return false;
            }
            return !this.locationPredicate.isPresent() || (location = this.locationPredicate.get()).m_203333_(biomeHolder = level.m_204166_(new BlockPos(i, j, k)));
        }
    }

    public record Instance(ColorSource colorSource, Enum2ObjectMap<SolarTerm, ColorMode.Instance> colors, Enum2ObjectMap<SolarTerm, List<ResourceLocation>> sprites, Enum2IntMap<SolarTerm> weights, boolean replace) implements Mergable<Instance>
    {
        private static final Enum2ObjectMap<SolarTerm, ColorMode.Instance> EMPTY_COLOR_MAP = new Enum2ObjectMap<SolarTerm, Object>(SolarTerm.class, null);
        private static final Instance EMPTY = new Instance(ColorSource.MAP, new Enum2ObjectMap<SolarTerm, Object>(SolarTerm.class, null), new Enum2ObjectMap<SolarTerm, Object>(SolarTerm.class, null), new Enum2IntMap<SolarTerm>(SolarTerm.class), false);

        @Override
        public Instance merge(Instance next) {
            Enum2ObjectMap<SolarTerm, ColorMode.Instance> newColors = new Enum2ObjectMap<SolarTerm, ColorMode.Instance>(SolarTerm.class);
            Enum2ObjectMap<SolarTerm, List<ResourceLocation>> newSprites = new Enum2ObjectMap<SolarTerm, List<ResourceLocation>>(SolarTerm.class);
            Enum2IntMap<SolarTerm> newWeights = new Enum2IntMap<SolarTerm>(SolarTerm.class);
            newColors.putAll(this.colors);
            newColors.putAll(next.colors);
            newSprites.putAll(this.sprites);
            newSprites.putAll(next.sprites);
            newWeights.putAll(this.weights);
            newWeights.putAll(next.weights);
            return new Instance(next.colorSource, newColors, newSprites, newWeights, next.replace);
        }
    }
}

