/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nullable;

public record ColorMode(Optional<Integer> color, Optional<Float> mix, Optional<String> sColor) {
    public static final Codec<ColorMode> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)Codec.INT.optionalFieldOf("color").forGetter(ColorMode::color), (App)Codec.FLOAT.optionalFieldOf("mix").forGetter(ColorMode::mix), (App)Codec.STRING.optionalFieldOf("color_string").forGetter(ColorMode::sColor)).apply((Applicative)ins, ColorMode::new));

    private static DataResult<ColorMode> check(ColorMode o) {
        if (o.color.isEmpty() && o.sColor().isEmpty()) {
            return DataResult.error(() -> "All Empty");
        }
        if (o.mix.isPresent() && o.mix.get().floatValue() < 0.0f) {
            return DataResult.error(() -> "Not valid mix " + String.valueOf(o.mix.get()));
        }
        return DataResult.success((Object)o);
    }

    @Nullable
    public Instance toInstance() {
        if (this.color.isEmpty() && this.sColor.isEmpty()) {
            return null;
        }
        Integer colorInt = this.color.orElseGet(() -> this.sColor.map(s -> {
            try {
                String formattedColor = s.startsWith("#") ? s.substring(1) : s;
                return Color.decode("0x" + formattedColor).getRGB();
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).orElse(null));
        if (colorInt == null) {
            return null;
        }
        return new Instance(colorInt, this.mix.orElse(Float.valueOf(1.0f)).floatValue());
    }

    public record Instance(int value, float mix) {
    }
}

