/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.data.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import com.teamtea.eclipticseasons.api.data.client.ColorMode;
import com.teamtea.eclipticseasons.api.data.misc.SolarTermValueMap;
import com.teamtea.eclipticseasons.api.misc.util.HolderMappable;
import com.teamtea.eclipticseasons.api.misc.util.Mergable;
import com.teamtea.eclipticseasons.api.util.fast.Enum2ObjectMap;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;

public record BiomeColor(HolderSet<Biome> biomes, Optional<SolarTermValueMap<ColorMode>> grassColor, Optional<SolarTermValueMap<ColorMode>> foliageColor) implements HolderMappable<HolderSet<Biome>, Instance>
{
    public static final Codec<BiomeColor> CODEC = RecordCodecBuilder.create(ins -> ins.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).fieldOf("biomes").forGetter(BiomeColor::biomes), (App)SolarTermValueMap.codec(ColorMode.CODEC).optionalFieldOf("grass_colors").forGetter(BiomeColor::grassColor), (App)SolarTermValueMap.codec(ColorMode.CODEC).optionalFieldOf("foliage_colors").forGetter(BiomeColor::foliageColor)).apply((Applicative)ins, BiomeColor::new));
    private static final SolarTermValueMap<ColorMode> EMPTY_MODE_MAP = new SolarTermValueMap(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());

    @NotNull
    public Instance toInstance() {
        EnumMap<SolarTerm, ColorMode> grassMap = this.grassColor.orElse(EMPTY_MODE_MAP).combine();
        EnumMap<SolarTerm, ColorMode> foliageMap = this.foliageColor.orElse(EMPTY_MODE_MAP).combine();
        if (grassMap.isEmpty() && foliageMap.isEmpty()) {
            return Instance.EMPTY;
        }
        Enum2ObjectMap<SolarTerm, ColorMode.Instance> grassColorMap = SolarTermValueMap.convertToEnum2ObjectMap(grassMap, ColorMode::toInstance);
        Enum2ObjectMap<SolarTerm, ColorMode.Instance> foliageColorMap = SolarTermValueMap.convertToEnum2ObjectMap(foliageMap, ColorMode::toInstance);
        if (grassColorMap.isEmpty() && foliageColorMap.isEmpty()) {
            return Instance.EMPTY;
        }
        return new Instance(grassColorMap, foliageColorMap);
    }

    @Override
    public Pair<HolderSet<Biome>, Instance> asHolderMapping() {
        return Pair.of(this.biomes, (Object)this.toInstance());
    }

    public record Instance(Enum2ObjectMap<SolarTerm, ColorMode.Instance> grassColor, Enum2ObjectMap<SolarTerm, ColorMode.Instance> foliageColor) implements Mergable<Instance>
    {
        private static final Enum2ObjectMap<SolarTerm, ColorMode.Instance> EMPTY_COLOR_MAP = new Enum2ObjectMap<SolarTerm, Object>(SolarTerm.class, null);
        private static final Instance EMPTY = new Instance(EMPTY_COLOR_MAP, EMPTY_COLOR_MAP);

        @Override
        public Instance merge(Instance next) {
            Enum2ObjectMap<SolarTerm, ColorMode.Instance> newGrassColor = new Enum2ObjectMap<SolarTerm, ColorMode.Instance>(SolarTerm.class);
            Enum2ObjectMap<SolarTerm, ColorMode.Instance> newFoliageColor = new Enum2ObjectMap<SolarTerm, ColorMode.Instance>(SolarTerm.class);
            newGrassColor.putAll(this.grassColor);
            newGrassColor.putAll(next.grassColor);
            newFoliageColor.putAll(this.foliageColor);
            newFoliageColor.putAll(next.foliageColor);
            return new Instance(newGrassColor, newFoliageColor);
        }
    }
}

