/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.climate.seasonal;

import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import java.util.Locale;

public enum ColdRain implements BiomeRain
{
    BEGINNING_OF_SPRING(0.1f),
    RAIN_WATER(0.3f, 0.008f),
    INSECTS_AWAKENING(0.25f, 0.015f),
    SPRING_EQUINOX(0.2f, 0.01f),
    FRESH_GREEN(0.35f, 0.005f),
    GRAIN_RAIN(0.45f),
    BEGINNING_OF_SUMMER(0.5f),
    LESSER_FULLNESS(0.5f, 0.08f),
    GRAIN_IN_EAR(0.6f, 0.05f),
    SUMMER_SOLSTICE(0.75f, 0.15f),
    LESSER_HEAT(0.8f, 0.1f),
    GREATER_HEAT(0.7f, 0.025f),
    BEGINNING_OF_AUTUMN(0.32f),
    END_OF_HEAT(0.3f),
    WHITE_DEW(0.15f),
    AUTUMNAL_EQUINOX(0.12f),
    COLD_DEW(0.3f),
    FIRST_FROST(0.25f),
    BEGINNING_OF_WINTER(0.3f),
    LIGHT_SNOW(0.1f),
    HEAVY_SNOW(0.2f),
    WINTER_SOLSTICE(0.25f),
    LESSER_COLD(0.45f),
    GREATER_COLD(0.35f),
    NONE(0.0f, 0.0f);

    private final float rainChane;
    private final float thunderChance;
    private static final ColdRain[] values;

    private ColdRain(float rainChane) {
        this(rainChane, 0.0f);
    }

    private ColdRain(float rainChane, float thunderChance) {
        this.rainChane = rainChane;
        this.thunderChance = thunderChance;
    }

    public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public float getRainChance() {
        return this.rainChane;
    }

    @Override
    public float getThunderChance() {
        return this.thunderChance;
    }

    @Override
    public SolarTerm getSolarTerm() {
        return SolarTerm.collectValues()[this.ordinal()];
    }

    @Override
    public Season getSeason() {
        return Season.collectValues()[this.ordinal() / 6];
    }

    public static ColdRain[] collectValues() {
        return values;
    }

    static {
        values = ColdRain.values();
    }
}

