/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.climate;

import com.teamtea.eclipticseasons.api.constant.climate.ISnowTerm;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import java.util.Arrays;

public enum SnowTerm implements ISnowTerm
{
    T1(SolarTerm.NONE, SolarTerm.NONE, 1.0f),
    T095(SolarTerm.GREATER_COLD, SolarTerm.GREATER_COLD, 0.95f),
    T08(SolarTerm.WINTER_SOLSTICE, SolarTerm.GREATER_COLD, 0.8f),
    T06(SolarTerm.LIGHT_SNOW, SolarTerm.GREATER_COLD, 0.6f),
    T05(SolarTerm.BEGINNING_OF_WINTER, SolarTerm.GREATER_COLD, 0.5f),
    T04(SolarTerm.FIRST_FROST, SolarTerm.GREATER_COLD, 0.4f),
    T03(SolarTerm.COLD_DEW, SolarTerm.BEGINNING_OF_SPRING, 0.3f),
    T02(SolarTerm.AUTUMNAL_EQUINOX, SolarTerm.RAIN_WATER, 0.2f),
    T015(SolarTerm.WHITE_DEW, SolarTerm.INSECTS_AWAKENING, 0.15f),
    T01(SolarTerm.BEGINNING_OF_AUTUMN, SolarTerm.FRESH_GREEN, 0.1f),
    T005(SolarTerm.GREATER_HEAT, SolarTerm.GRAIN_RAIN, 0.005f),
    T000(SolarTerm.LESSER_HEAT, SolarTerm.BEGINNING_OF_SUMMER, 0.0f),
    TN(SolarTerm.SUMMER_SOLSTICE, SolarTerm.GRAIN_IN_EAR, Float.NEGATIVE_INFINITY),
    NONE(SolarTerm.NONE, SolarTerm.NONE, 2.0f);

    private final SolarTerm start;
    private final SolarTerm end;
    private final float temp;
    private static final SnowTerm[] snowTerms;
    private static final SnowTerm[] validSnowTerms;

    private SnowTerm(SolarTerm start2, SolarTerm end, float temp) {
        this.start = start2;
        this.end = end;
        this.temp = temp;
    }

    @Override
    public SolarTerm getStart() {
        return this.start;
    }

    @Override
    public SolarTerm getEnd() {
        return this.end;
    }

    public static SnowTerm[] collectValues() {
        return snowTerms;
    }

    public static SnowTerm[] collectValidValues() {
        return validSnowTerms;
    }

    public static SnowTerm get(float biomeTmep, float tempChange) {
        float oldT = biomeTmep;
        biomeTmep += tempChange;
        for (SnowTerm value : SnowTerm.collectValidValues()) {
            if (!(biomeTmep >= value.temp)) continue;
            return value;
        }
        return NONE;
    }

    static {
        snowTerms = SnowTerm.values();
        validSnowTerms = (SnowTerm[])Arrays.stream(SnowTerm.values()).filter(s -> s != NONE).toArray(SnowTerm[]::new);
    }
}

