/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.climate;

import com.teamtea.eclipticseasons.api.constant.climate.BiomeRain;
import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import java.util.Locale;

public enum MonsoonRain implements BiomeRain
{
    BEGINNING_OF_SPRING,
    RAIN_WATER,
    INSECTS_AWAKENING,
    SPRING_EQUINOX,
    FRESH_GREEN,
    GRAIN_RAIN,
    BEGINNING_OF_SUMMER(0.3f),
    LESSER_FULLNESS(0.5f, 0.1f),
    GRAIN_IN_EAR(0.7f, 0.15f),
    SUMMER_SOLSTICE(0.8f, 0.2f),
    LESSER_HEAT(0.95f, 0.15f),
    GREATER_HEAT(0.8f, 0.1f),
    BEGINNING_OF_AUTUMN(0.7f, 0.05f),
    END_OF_HEAT(0.6f, 0.03f),
    WHITE_DEW(0.5f, 0.02f),
    AUTUMNAL_EQUINOX(0.4f, 0.02f),
    COLD_DEW(0.3f, 0.01f),
    FIRST_FROST(0.25f, 0.01f),
    BEGINNING_OF_WINTER,
    LIGHT_SNOW,
    HEAVY_SNOW,
    WINTER_SOLSTICE,
    LESSER_COLD,
    GREATER_COLD,
    NONE(0.0f, 0.0f);

    private final float rainChane;
    private final float thunderChance;
    private static final MonsoonRain[] values;

    private MonsoonRain() {
        this(0.0f, 0.0f);
    }

    private MonsoonRain(float rainChane) {
        this(rainChane, 0.0f);
    }

    private MonsoonRain(float rainChane, float thunderChance) {
        this.rainChane = rainChane;
        this.thunderChance = thunderChance;
    }

    public String getName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    @Override
    public float getRainChance() {
        return this.rainChane;
    }

    @Override
    public float getThunderChance() {
        return this.thunderChance;
    }

    @Override
    public SolarTerm getSolarTerm() {
        return SolarTerm.collectValues()[this.ordinal()];
    }

    @Override
    public Season getSeason() {
        return Season.collectValues()[this.ordinal() / 6];
    }

    public static MonsoonRain[] collectValues() {
        return values;
    }

    static {
        values = MonsoonRain.values();
    }
}

