/*
 * Decompiled with CFR 0.152.
 */
package com.teamtea.eclipticseasons.api.constant.climate;

import com.teamtea.eclipticseasons.api.constant.solar.Season;
import com.teamtea.eclipticseasons.api.constant.solar.SolarTerm;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public interface BiomeRain {
    public static final float DEFAULT_RAIN_CHANE = 0.0f;
    public static final float DEFAULT_THUNDER_CHANCE = 0.0f;

    public int ordinal();

    @Deprecated(forRemoval=true, since="0.12")
    default public float getRainChane() {
        return 0.0f;
    }

    default public float getRainChance() {
        return this.getRainChane();
    }

    default public float getThunderChance() {
        return 0.0f;
    }

    default public SolarTerm getSolarTerm() {
        return SolarTerm.collectValues()[this.ordinal()];
    }

    default public Season getSeason() {
        return Season.collectValues()[this.ordinal() / 6];
    }

    default public BiomeRain resolve(Level level) {
        return this;
    }

    default public int getRainDuration(RandomSource random) {
        return ServerLevel.f_263681_.m_214085_(random);
    }

    default public int getRainDelay(RandomSource random) {
        return ServerLevel.f_263704_.m_214085_(random);
    }

    default public int getThunderDuration(RandomSource random) {
        return ServerLevel.f_263755_.m_214085_(random);
    }

    default public int getThunderDelay(RandomSource random) {
        return ServerLevel.f_263684_.m_214085_(random);
    }
}

